/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.codehaus.plexus.resource.ResourceManager;

public class CloverReportMojo
extends AbstractMavenReport {
    private File reportDescriptor;
    private boolean resolveReportDescriptor;
    protected ArtifactResolver artifactResolver;
    protected List repositories;
    protected ArtifactFactory artifactFactory;
    protected ArtifactRepository localRepository;
    private String cloverDatabase;
    private String cloverMergeDatabase;
    private File outputDirectory;
    private String historyDir;
    private int flushInterval;
    private boolean waitForFlush;
    private boolean generateHtml;
    private boolean generatePdf;
    private boolean generateXml;
    private boolean generateJson;
    private boolean generateHistorical;
    private String orderBy;
    private String contextFilters;
    private Renderer siteRenderer;
    private MavenProject project;
    private List reactorProjects;
    private String licenseLocation;
    private String license;
    private ResourceManager resourceManager;
    static /* synthetic */ Class class$com$atlassian$maven$plugin$clover$CloverReportMojo;

    public void executeReport(Locale locale) throws MavenReportException {
        File mergedCloverDatabase;
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"No report being generated for this module.");
        }
        try {
            AbstractCloverMojo.registerLicenseFile(this.project, this.resourceManager, this.licenseLocation, this.getLog(), ((Object)((Object)this)).getClass().getClassLoader(), this.license);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Failed to locate Clover license", (Exception)((Object)e));
        }
        this.outputDirectory.mkdirs();
        if (this.reportDescriptor == null) {
            this.reportDescriptor = this.resolveCloverDescriptor();
        }
        this.getLog().info((CharSequence)("Using Clover report descriptor: " + this.reportDescriptor.getAbsolutePath()));
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        if (singleModuleCloverDatabase.exists()) {
            this.createAllReportTypes(this.cloverDatabase, this.project.getName());
        }
        if ((mergedCloverDatabase = new File(this.cloverMergeDatabase)).exists()) {
            this.createAllReportTypes(this.cloverMergeDatabase, this.project.getName() + "(Aggregated)");
        }
    }

    private void createAllReportTypes(String database, String titlePrefix) throws MavenReportException {
        String outpath = this.outputDirectory.getAbsolutePath();
        if (this.generateHtml) {
            this.createReport(database, "html", titlePrefix, outpath, outpath, false);
        }
        if (this.generatePdf) {
            this.createReport(database, "pdf", titlePrefix, outpath + "/clover.pdf", outpath + "/historical.pdf", true);
        }
        if (this.generateXml) {
            this.createReport(database, "xml", titlePrefix, outpath + "/clover.xml", null, false);
        }
        if (this.generateJson) {
            this.createReport(database, "json", titlePrefix, outpath, null, false);
        }
    }

    private void createReport(String database, String format, String title, String output, String historyOut, boolean summary) {
        Project antProject = new Project();
        antProject.init();
        antProject.setUserProperty("ant.file", this.reportDescriptor.getAbsolutePath());
        antProject.setCoreLoader(((Object)((Object)this)).getClass().getClassLoader());
        antProject.setProperty("cloverdb", database);
        antProject.setProperty("output", output);
        antProject.setProperty("history", this.historyDir);
        antProject.setProperty("title", title);
        String testDir = this.project.getBuild().getTestSourceDirectory();
        antProject.setProperty("tests", testDir);
        antProject.setProperty("filter", this.contextFilters != null ? this.contextFilters : "");
        antProject.setProperty("orderBy", this.orderBy);
        antProject.setProperty("type", format);
        antProject.setProperty("summary", String.valueOf(summary));
        if (historyOut != null) {
            antProject.setProperty("historyout", historyOut);
        }
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        ProjectHelper.configureProject((Project)antProject, (File)this.reportDescriptor);
        antProject.setBaseDir(this.project.getBasedir());
        String target = this.isHistoricalDirectoryValid(output) && historyOut != null ? "historical" : "current";
        antProject.executeTarget(target);
    }

    private boolean isHistoricalDirectoryValid(String outFile) {
        boolean isValid = false;
        File dir = new File(this.historyDir);
        if (dir.exists()) {
            if (dir.listFiles().length > 0) {
                isValid = true;
            } else {
                this.getLog().warn((CharSequence)("No Clover historical data found in [" + this.historyDir + "], skipping Clover " + "historical report generation ([" + outFile + "])"));
            }
        } else {
            this.getLog().warn((CharSequence)("Clover historical directory [" + this.historyDir + "] does not exist, skipping Clover " + "historical report generation ([" + outFile + "])"));
        }
        return isValid;
    }

    public String getOutputName() {
        return "clover/index";
    }

    public String getDescription(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.description");
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("clover-report", locale, (class$com$atlassian$maven$plugin$clover$CloverReportMojo == null ? (class$com$atlassian$maven$plugin$clover$CloverReportMojo = CloverReportMojo.class$("com.atlassian.maven.plugin.clover.CloverReportMojo")) : class$com$atlassian$maven$plugin$clover$CloverReportMojo).getClassLoader());
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getName(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.name");
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean canGenerate = false;
        AbstractCloverMojo.waitForFlush(this.waitForFlush, this.flushInterval);
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            if (this.generateHtml || this.generatePdf || this.generateXml) {
                canGenerate = true;
            }
        } else {
            this.getLog().warn((CharSequence)"No Clover database found, skipping report generation");
        }
        return canGenerate;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("clover") ? new File(reportOutputDirectory, "clover") : reportOutputDirectory;
    }

    protected File resolveCloverDescriptor() throws MavenReportException {
        if (this.resolveReportDescriptor) {
            this.getLog().info((CharSequence)"Attempting to resolve the clover-report configuration as an xml artifact.");
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "xml", "clover-report");
            try {
                this.artifactResolver.resolve(artifact, this.repositories, this.localRepository);
                return artifact.getFile();
            }
            catch (ArtifactResolutionException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.getLog().info((CharSequence)"Using /default-clover-report descriptor.");
            File file = AbstractCloverMojo.getResourceAsFile(this.project, this.resourceManager, "/default-clover-report.xml", this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
            file.deleteOnExit();
            return file;
        }
        catch (Exception e) {
            throw new MavenReportException("Could not resolve default-clover-report.xml. Please try specifying this via the maven.clover.reportDescriptor property.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

