/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import com.atlassian.maven.plugin.clover.internal.instrumentation.MainInstrumenter;
import com.atlassian.maven.plugin.clover.internal.instrumentation.TestInstrumenter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;

public class CloverInstrumentInternalMojo
extends AbstractCloverMojo
implements CloverConfiguration {
    private String cloverOutputDirectory;
    private List pluginArtifacts;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private Set includes = new HashSet();
    private Set excludes = new HashSet();
    private boolean includesAllSourceRoots;
    private boolean includesTestSourceRoots;
    private boolean useFullyQualifiedJavaLang;
    private String encoding;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover instrumentation.");
            return;
        }
        new File(this.cloverOutputDirectory).mkdirs();
        String cloverOutputSourceDirectory = new File(this.cloverOutputDirectory, "src").getPath();
        String cloverOutputTestSourceDirectory = new File(this.cloverOutputDirectory, "src-test").getPath();
        new File(this.getCloverDatabase()).getParentFile().mkdirs();
        super.execute();
        this.logArtifacts("before changes");
        MainInstrumenter mainInstrumenter = new MainInstrumenter(this, cloverOutputSourceDirectory);
        TestInstrumenter testInstrumenter = new TestInstrumenter(this, cloverOutputTestSourceDirectory);
        if (this.isJavaProject()) {
            mainInstrumenter.instrument();
            if (this.includesTestSourceRoots) {
                testInstrumenter.instrument();
            }
        }
        this.swizzleCloverDependencies();
        this.addCloverDependencyToCompileClasspath();
        mainInstrumenter.redirectSourceDirectories();
        if (this.includesTestSourceRoots) {
            testInstrumenter.redirectSourceDirectories();
        }
        this.redirectOutputDirectories();
        this.redirectArtifact();
        this.logArtifacts("after changes");
    }

    private boolean isJavaProject() {
        ArtifactHandler artifactHandler = this.getProject().getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().warn((CharSequence)("The reported language of this project is " + artifactHandler.getLanguage() + ", attempting to instrument sources anyway."));
        }
        return true;
    }

    private void redirectOutputDirectories() {
        this.getProject().getBuild().setDirectory(this.cloverOutputDirectory);
        this.getProject().getBuild().setOutputDirectory(new File(this.cloverOutputDirectory, "classes").getPath());
        new File(this.getProject().getBuild().getOutputDirectory()).mkdirs();
        this.getProject().getBuild().setTestOutputDirectory(new File(this.cloverOutputDirectory, "test-classes").getPath());
    }

    private void redirectArtifact() {
        if (!this.getProject().getPackaging().equals("pom")) {
            Artifact oldArtifact = this.getProject().getArtifact();
            Artifact newArtifact = this.artifactFactory.createArtifactWithClassifier(oldArtifact.getGroupId(), oldArtifact.getArtifactId(), oldArtifact.getVersion(), oldArtifact.getType(), "clover");
            this.getProject().setArtifact(newArtifact);
            this.getProject().getBuild().setFinalName(this.getProject().getArtifactId() + "-" + this.getProject().getVersion() + "-clover");
        }
    }

    private void swizzleCloverDependencies() {
        this.getProject().setDependencyArtifacts(this.swizzleCloverDependencies(this.getProject().getDependencyArtifacts()));
        this.getProject().setArtifacts(this.swizzleCloverDependencies(this.getProject().getArtifacts()));
    }

    protected Set swizzleCloverDependencies(Set artifacts) {
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (artifact.getClassifier() == null) {
                Artifact cloveredArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "clover");
                try {
                    this.artifactResolver.resolve(cloveredArtifact, new ArrayList(), this.localRepository);
                    cloveredArtifact.setScope(artifact.getScope());
                    if (cloveredArtifact.getFile().lastModified() + 2000L < artifact.getFile().lastModified()) {
                        this.getLog().warn((CharSequence)("Using [" + artifact.getId() + "] even though a Clovered version exists " + "but it's older and could fail the build. Please consider running Clover again on that " + "dependency's project."));
                        resolvedArtifacts.add(artifact);
                        continue;
                    }
                    resolvedArtifacts.add(cloveredArtifact);
                }
                catch (ArtifactResolutionException e) {
                    resolvedArtifacts.add(artifact);
                }
                catch (ArtifactNotFoundException e) {
                    resolvedArtifacts.add(artifact);
                }
                continue;
            }
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    protected Artifact findCloverArtifact(List pluginArtifacts) {
        Artifact cloverArtifact = null;
        Iterator artifacts = pluginArtifacts.iterator();
        while (artifacts.hasNext() && cloverArtifact == null) {
            Artifact artifact = (Artifact)artifacts.next();
            if (!"com.cenqua.clover".equals(artifact.getGroupId()) || !"clover".equals(artifact.getArtifactId())) continue;
            cloverArtifact = artifact;
        }
        return cloverArtifact;
    }

    private void addCloverDependencyToCompileClasspath() throws MojoExecutionException {
        Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
        if (cloverArtifact == null) {
            throw new MojoExecutionException("Couldn't find [com.cenqua.clover:clover] artifact in plugin dependencies");
        }
        cloverArtifact = this.artifactFactory.createArtifact(cloverArtifact.getGroupId(), cloverArtifact.getArtifactId(), cloverArtifact.getVersion(), "compile", cloverArtifact.getType());
        HashSet<Artifact> set = new HashSet<Artifact>(this.getProject().getDependencyArtifacts());
        set.add(cloverArtifact);
        this.getProject().setDependencyArtifacts(set);
    }

    private void logArtifacts(String message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("[Clover] List of dependency artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getDependencyArtifacts());
            this.getLog().debug((CharSequence)("[Clover] List of artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getArtifacts());
        }
    }

    private void logArtifacts(Set artifacts) {
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("[Clover]   Artifact [" + artifact.getId() + "], scope = [" + artifact.getScope() + "]"));
        }
    }

    protected void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    protected void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public Set getIncludes() {
        return this.includes;
    }

    public Set getExcludes() {
        return this.excludes;
    }

    public boolean includesAllSourceRoots() {
        return this.includesAllSourceRoots;
    }

    public boolean isUseFullyQualifiedJavaLang() {
        return this.useFullyQualifiedJavaLang;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

