/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.tasks.CloverPassTask;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class CloverCheckMojo
extends AbstractCloverMojo {
    private String targetPercentage;
    private String contextFilters;
    private boolean failOnViolation;
    private File historyDir;
    private String historyThreshold;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover check.");
            return;
        }
        if (!this.isInCloverForkedLifecycle()) {
            if (this.areCloverDatabasesAvailable()) {
                super.execute();
                AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
                this.check();
            } else {
                this.getLog().info((CharSequence)"No Clover database found, skipping test coverage verification");
            }
        }
    }

    private void check() throws MojoExecutionException {
        if (new File(this.getCloverDatabase()).exists()) {
            this.checkDatabase(this.getCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.checkDatabase(this.getCloverMergeDatabase());
        }
    }

    private void checkDatabase(String database) throws MojoExecutionException {
        Project antProject = new Project();
        antProject.init();
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        CloverPassTask cloverPassTask = (CloverPassTask)antProject.createTask("clover-check");
        cloverPassTask.init();
        cloverPassTask.setInitString(database);
        cloverPassTask.setHaltOnFailure(true);
        cloverPassTask.setFailureProperty("clovercheckproperty");
        if (this.targetPercentage != null) {
            cloverPassTask.setTarget(new Percentage(this.targetPercentage));
            this.getLog().info((CharSequence)("Checking for coverage of [" + this.targetPercentage + "] for database [" + database + "]"));
        } else {
            cloverPassTask.setHistorydir(this.historyDir);
            cloverPassTask.setThreshold(new Percentage(this.historyThreshold));
            this.getLog().info((CharSequence)("Checking coverage against historical data [" + this.historyDir + " +/-" + this.historyThreshold + " ] for database [" + database + "]"));
        }
        if (this.contextFilters != null) {
            cloverPassTask.setFilter(this.contextFilters);
        }
        try {
            cloverPassTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)antProject.getProperty("clovercheckproperty"));
            if (this.failOnViolation) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().warn((CharSequence)"Clover test percentage coverage is below threshold but failOnViolation is set to  false, preventing the build from failing.");
        }
    }

    private boolean isInCloverForkedLifecycle() {
        return this.getProject().getBuild().getDirectory().endsWith("clover");
    }
}

