/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.cenqua.clover.CloverMerge;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class CloverAggregateMojo
extends AbstractCloverMojo {
    private List reactorProjects;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover aggregate.");
            return;
        }
        if (this.getProject().getModules() != null && this.getProject().getModules().size() > 0) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            if (this.getChildrenCloverDatabases().size() > 0) {
                new File(this.getCloverMergeDatabase()).getParentFile().mkdirs();
                this.mergeCloverDatabases();
            } else {
                this.getLog().warn((CharSequence)"No Clover databases found in children projects - No merge done");
            }
        }
    }

    private List getChildrenCloverDatabases() {
        String relativeCloverDatabasePath = this.getCloverDatabase().substring(this.getProject().getBasedir().getPath().length());
        ArrayList<String> dbFiles = new ArrayList<String>();
        List projects = this.getDescendentModuleProjects(this.getProject());
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            MavenProject childProject = (MavenProject)i.next();
            File cloverDb = new File(childProject.getBasedir(), relativeCloverDatabasePath);
            if (!cloverDb.exists()) continue;
            dbFiles.add(cloverDb.getPath());
        }
        return dbFiles;
    }

    private List getDescendentModuleProjects(MavenProject project) {
        return this.getModuleProjects(project, -1);
    }

    private List getModuleProjects(MavenProject project, int levels) {
        boolean infinite;
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        boolean bl = infinite = levels == -1;
        if (this.reactorProjects != null && (infinite || levels > 0)) {
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject reactorProject = (MavenProject)i.next();
                if (!this.isModuleOfProject(project, reactorProject)) continue;
                projects.add(reactorProject);
                projects.addAll(this.getModuleProjects(reactorProject, infinite ? levels : levels - 1));
            }
        }
        return projects;
    }

    private boolean isModuleOfProject(MavenProject parentProject, MavenProject potentialModule) {
        boolean result = false;
        List modules = parentProject.getModules();
        if (modules != null) {
            File parentBaseDir = parentProject.getBasedir();
            Iterator i = modules.iterator();
            while (i.hasNext()) {
                String module = (String)i.next();
                File moduleBaseDir = new File(parentBaseDir, module);
                try {
                    String rhs;
                    String lhs = potentialModule.getBasedir().getCanonicalPath();
                    if (!lhs.equals(rhs = moduleBaseDir.getCanonicalPath())) continue;
                    result = true;
                    break;
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"error encountered trying to resolve canonical module paths");
                }
            }
        }
        return result;
    }

    private void mergeCloverDatabases() throws MojoExecutionException {
        List dbFiles = this.getChildrenCloverDatabases();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-i");
        parameters.add(this.getCloverMergeDatabase());
        if (this.getLog().isDebugEnabled()) {
            parameters.add("-d");
        }
        parameters.addAll(dbFiles);
        int mergeResult = CloverMerge.mainImpl((String[])parameters.toArray(new String[0]));
        if (mergeResult != 0) {
            throw new MojoExecutionException("Clover has failed to merge the children module databases");
        }
    }
}

