/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.distribution.mojo;

import com.atlassian.distribution.DependencyBundle;
import com.atlassian.distribution.ExtraResources;
import com.atlassian.distribution.MavenVersion;
import com.atlassian.distribution.scriptwriter.AbstractScriptWriter;
import com.atlassian.distribution.scriptwriter.FinalMavenBuildCommand;
import com.atlassian.distribution.scriptwriter.PosixScriptWriter;
import com.atlassian.distribution.scriptwriter.WindowsScriptWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="source", aggregator=true, requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.TEST)
public class SourceDistributionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${user.dir}", property="source.baseProjectDirectory")
    private File baseProjectDirectory;
    @Parameter(defaultValue="false")
    private String checkoutFromScm;
    @Parameter(defaultValue="checkouts")
    private String checkoutDirectoryName;
    @Parameter(property="scmVersionName")
    private String scmVersionName;
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List remoteRepositories;
    @Deprecated
    @Parameter
    private String[] excludedSubtrees;
    @Parameter
    private String includeSettingsFile;
    @Parameter
    private String localRepoDirectory;
    @Parameter
    private FinalMavenBuildCommand[] finalMavenBuildCommands;
    @Parameter
    private List excludedArtifacts;
    @Parameter
    private List<DependencyBundle> bundles;
    @Parameter
    private boolean skipCheckout;
    @Parameter(defaultValue="false")
    private boolean skipDownloadingDependencyJars;
    @Parameter(defaultValue="false")
    private boolean skipUnResolvedSourceJar;
    @Parameter(defaultValue="true")
    private boolean useReactor;
    @Parameter
    private String baseProject;
    private MavenProject baseMavenProject;
    @Component
    protected ArtifactMetadataSource metadataSource;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    private MavenSession session;
    @Component
    private DependencyTreeBuilder treeBuilder;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    private MavenProjectBuilder projectBuilder;
    private Set<String> totalExcludedArtifacts;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File checkoutDirectory = this.createCheckoutDirectory();
        this.initialize();
        if (Boolean.valueOf(this.checkoutFromScm).booleanValue()) {
            this.callScmCheckoutPlugin(checkoutDirectory);
        } else {
            this.copyCurrentRepoAsSource(checkoutDirectory);
        }
        this.downloadAtlassianDependencySource(checkoutDirectory);
        Set<MavenVersion> mavenVersions = this.getMavenVersions();
        ExtraResources.copyResources(checkoutDirectory, this.artifactFactory, this.resolver, this.remoteRepositories, this.localRepository, mavenVersions, this.getLog());
        this.generateBuildCommand();
    }

    private Set<MavenVersion> getMavenVersions() throws MojoExecutionException {
        HashSet<MavenVersion> result = new HashSet<MavenVersion>();
        for (FinalMavenBuildCommand command : this.finalMavenBuildCommands) {
            result.add(command.getMavenVersionEnum());
        }
        return result;
    }

    private void initialize() throws MojoExecutionException {
        if (this.useReactor) {
            this.baseMavenProject = this.reactorProjects.get(0);
        } else {
            try {
                Set artifacts = this.project.createArtifacts(this.artifactFactory, null, null);
                for (Artifact artifact : artifacts) {
                    if (!(artifact.getGroupId() + ":" + artifact.getArtifactId()).equals(this.baseProject)) continue;
                    this.getLog().info((CharSequence)("init result: " + this.formatArtifact(artifact)));
                    this.baseMavenProject = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
                }
            }
            catch (InvalidDependencyVersionException e) {
                throw new MojoExecutionException("Failed to get dependencies for project: " + this.project, (Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Failed to build project:" + this.baseProject, (Exception)((Object)e));
            }
        }
    }

    private File createCheckoutDirectory() throws MojoExecutionException {
        File checkoutDirectory = new File(this.outputDirectory, this.checkoutDirectoryName);
        if (!checkoutDirectory.exists() && !checkoutDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + checkoutDirectory.getAbsolutePath());
        }
        return checkoutDirectory;
    }

    private void copyCurrentRepoAsSource(File checkoutDirectory) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying from " + this.baseProjectDirectory + " to " + checkoutDirectory));
            File projectDir = new File(checkoutDirectory, this.baseMavenProject.getArtifactId());
            projectDir.mkdir();
            FileUtils.copyDirectory((File)this.baseProjectDirectory, (File)projectDir, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !SourceDistributionMojo.this.isSCMFile(file.getName()) && (!file.isDirectory() || !file.getName().equals("target"));
                }
            }, (boolean)true);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy source dir", (Exception)e);
        }
    }

    private void callScmCheckoutPlugin(File checkoutDirectory) throws MojoExecutionException {
        InvocationResult result;
        String projectOutputDirectory = checkoutDirectory.getAbsolutePath() + File.separator + this.baseMavenProject.getArtifactId();
        if (!this.baseMavenProject.getScm().getConnection().startsWith("scm:svn") && (StringUtils.isEmpty((String)this.scmVersionName) || StringUtils.isEmpty((String)this.scmVersionType))) {
            this.getLog().info((CharSequence)("Project is SVN: " + this.baseMavenProject.getScm().getConnection().startsWith("scm:svn")));
            this.getLog().info((CharSequence)("scmVersionName is: " + this.scmVersionName));
            this.getLog().info((CharSequence)("scmVersionType is: " + this.scmVersionType));
            this.initSCMVersion();
        }
        this.getLog().info((CharSequence)("Trying to checkout " + this.baseMavenProject.getScm().getConnection() + ", " + this.scmVersionType + " " + this.scmVersionName + " to directory " + projectOutputDirectory));
        if (this.skipCheckout) {
            this.getLog().info((CharSequence)"Skipping Source code checkout");
            return;
        }
        DefaultInvoker invoker = new DefaultInvoker(){};
        invoker.setLocalRepositoryDirectory(new File(this.session.getLocalRepository().getBasedir()));
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Arrays.asList("org.apache.maven.plugins:maven-scm-plugin:1.9:checkout"));
        request.setPomFile(this.baseMavenProject.getFile());
        Properties arguments = new Properties(this.session.getUserProperties());
        request.setProperties(arguments);
        arguments.put("checkoutDirectory", projectOutputDirectory);
        if (!this.baseMavenProject.getScm().getConnection().startsWith("scm:svn")) {
            arguments.put("scmVersion", this.scmVersionName);
            arguments.put("scmVersionType", this.scmVersionType);
        }
        arguments.put("connectionUrl", this.baseMavenProject.getScm().getConnection());
        try {
            result = invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException(e.getMessage(), e.getCause());
        }
        if (result.getExitCode() != 0) {
            throw new IllegalStateException("Failed to checkout. See messages above. ");
        }
        try {
            this.deleteSCMFiles(new File(projectOutputDirectory));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to delete scm files", e);
        }
        this.getLog().info((CharSequence)("Checkout complete to " + projectOutputDirectory));
    }

    private void deleteSCMFiles(File projectOutputDirectory) throws IOException {
        File[] scmFiles;
        for (File scmFile : scmFiles = projectOutputDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return SourceDistributionMojo.this.isSCMFile(name);
            }
        })) {
            if (!scmFile.exists()) continue;
            if (scmFile.isDirectory()) {
                FileUtils.deleteDirectory((File)scmFile);
                continue;
            }
            scmFile.delete();
        }
    }

    private boolean isSCMFile(String fileName) {
        return ".git".equals(fileName) || ".gitignore".equals(fileName) || ".hg".equals(fileName) || ".svn".equals(fileName);
    }

    private void downloadAtlassianDependencySource(File checkoutDirectory) throws MojoExecutionException {
        if (this.skipDownloadingDependencyJars) {
            this.getLog().info((CharSequence)"Skip downloading dependency jars");
            return;
        }
        this.getLog().info((CharSequence)"Begin to download source jars of dependencies from maven.atlassian.com");
        checkoutDirectory = new File(checkoutDirectory, "dependencySources");
        checkoutDirectory.mkdir();
        HashSet<Artifact> atlassianDependencies = new HashSet<Artifact>();
        ArrayList<MavenProject> projectList = new ArrayList<MavenProject>();
        if (this.useReactor) {
            projectList.addAll(this.reactorProjects);
        } else {
            projectList.add(this.project);
        }
        if (this.bundles != null) {
            projectList.addAll(this.buildBundledDependenciesProjectList());
        }
        for (MavenProject project : projectList) {
            Set<Artifact> artifacts = this.retrieveDependenciesFromTree(project, this.localRepository, this.excludedSubtrees == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.excludedSubtrees)));
            for (Artifact artifact : artifacts) {
                this.getLog().debug((CharSequence)("Adding artifact to list:" + this.formatArtifact(artifact)));
                Artifact artifactWithClassifier = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "sources");
                artifactWithClassifier.setScope(artifact.getScope());
                atlassianDependencies.add(artifactWithClassifier);
            }
        }
        this.resolveAndCopyArtifacts(atlassianDependencies, checkoutDirectory);
    }

    private List<MavenProject> buildBundledDependenciesProjectList() {
        ArrayList<MavenProject> list = new ArrayList<MavenProject>();
        for (DependencyBundle bundle : this.bundles) {
            try {
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion(), bundle.getType(), bundle.getClassifier());
                this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                list.add(this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository));
            }
            catch (ProjectBuildingException e) {
                throw new RuntimeException(e);
            }
            catch (ArtifactNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    private boolean shouldDownloadSource(Artifact artifact) throws MojoExecutionException {
        return artifact.getGroupId().startsWith("com.atlassian") && !artifact.getScope().equals("test") && !this.getTotalExcludedSingleArtifacts().contains(artifact.getGroupId() + ":" + artifact.getArtifactId()) && !artifact.getType().equals("pom") && !this.isIncludedInReactor(artifact);
    }

    private boolean isIncludedInReactor(Artifact artifact) throws MojoExecutionException {
        for (MavenProject project : this.reactorProjects) {
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId())) continue;
            this.getLog().debug((CharSequence)("Ignoring " + this.formatArtifact(artifact) + " because it is sub module of base project"));
            return true;
        }
        if (!this.useReactor) {
            try {
                for (MavenProject parent = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository); parent != null; parent = parent.getParent()) {
                    if (!(parent.getGroupId() + ":" + parent.getArtifactId()).equals(this.baseProject)) continue;
                    this.getLog().debug((CharSequence)("Ignoring " + this.formatArtifact(artifact) + " because it is sub module of base project"));
                    return true;
                }
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Failed to build project:", (Exception)((Object)e));
            }
        }
        return false;
    }

    private Set<String> getTotalExcludedSingleArtifacts() throws MojoExecutionException {
        if (this.totalExcludedArtifacts == null) {
            this.totalExcludedArtifacts = new HashSet<String>();
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/excludedArtifacts.txt");
                this.totalExcludedArtifacts.addAll(IOUtils.readLines((InputStream)is));
                is.close();
                if (this.excludedArtifacts != null) {
                    this.totalExcludedArtifacts.addAll(this.excludedArtifacts);
                }
            }
            catch (IOException ie) {
                throw new MojoExecutionException("Cannot read excluded artifacts:", (Exception)ie);
            }
        }
        return this.totalExcludedArtifacts;
    }

    private Set<Artifact> retrieveDependenciesFromTree(MavenProject project, ArtifactRepository localRepository, Set<String> ignoredTrees) throws MojoExecutionException {
        DependencyNode rootNode = null;
        try {
            rootNode = this.treeBuilder.buildDependencyTree(project, localRepository, this.artifactFactory, this.metadataSource, null, this.artifactCollector);
        }
        catch (DependencyTreeBuilderException e) {
            throw new IllegalArgumentException("The project couldn't generate a dependency tree", e);
        }
        HashSet<Artifact> depArtifacts = new HashSet<Artifact>();
        LinkedList nodesToVisit = new LinkedList(rootNode.getChildren());
        DependencyNode actualNode = null;
        while ((actualNode = (DependencyNode)nodesToVisit.poll()) != null) {
            if (!this.isNodeIdPresentOnSet(ignoredTrees, actualNode)) {
                if (actualNode.getState() == 0 && !actualNode.getArtifact().getScope().equals("test")) {
                    depArtifacts.add(actualNode.getArtifact());
                } else {
                    this.getLog().debug((CharSequence)("Ignoring artifact: " + this.formatArtifact(actualNode.getArtifact())));
                }
                nodesToVisit.addAll(actualNode.getChildren());
                continue;
            }
            this.getLog().debug((CharSequence)("Ignore sub tree: " + this.formatArtifact(actualNode.getArtifact())));
        }
        return depArtifacts;
    }

    private boolean isNodeIdPresentOnSet(Set<String> artifacts, DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String prefix = artifact.getGroupId() + ":" + artifact.getArtifactId();
        return artifacts.contains(prefix);
    }

    private String formatArtifact(Artifact artifact) {
        return String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    private Set<Artifact> resolveAndCopyArtifacts(Set<Artifact> artifacts, File checkoutDirectory) throws MojoExecutionException {
        ArrayList<Artifact> artifactsCannotBeFound = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.shouldDownloadSource(artifact)) continue;
            try {
                this.getLog().debug((CharSequence)("Resolving artifact:" + this.formatArtifact(artifact)));
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                this.getLog().debug((CharSequence)("Copying " + artifact.getFile().getPath() + " to " + checkoutDirectory.getPath()));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)checkoutDirectory);
            }
            catch (ArtifactResolutionException e) {
                artifactsCannotBeFound.add(artifact);
            }
            catch (ArtifactNotFoundException e) {
                artifactsCannotBeFound.add(artifact);
            }
            catch (IOException e) {
                artifactsCannotBeFound.add(artifact);
            }
        }
        if (artifactsCannotBeFound.size() > 0) {
            StringBuilder message = new StringBuilder("\n\nArtifacts whose source jar cannot be downloaded from maven.atlassian.com( ");
            message.append(artifactsCannotBeFound.size()).append(" artifacts )\n");
            for (Artifact atf : artifactsCannotBeFound) {
                message.append("\t - ").append(this.formatArtifact(atf));
                message.append(":").append(atf.getType()).append("\n");
            }
            message.append("\n");
            this.getLog().error((CharSequence)message.toString());
            if (!this.skipUnResolvedSourceJar) {
                throw new MojoExecutionException("There are artifacts that don't have the sources available for download. See message above for more information. ");
            }
        }
        return artifacts;
    }

    private void generateBuildCommand() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating build command");
        File directory = new File(this.outputDirectory, this.checkoutDirectoryName);
        PosixScriptWriter posixWriter = new PosixScriptWriter(directory, "build.sh", false);
        WindowsScriptWriter winWriter = new WindowsScriptWriter(directory, "build.bat", false);
        ((AbstractScriptWriter)posixWriter).addSettingsLine("settings.xml");
        ((AbstractScriptWriter)winWriter).addSettingsLine("settings.xml");
        if (StringUtils.isNotBlank((String)this.localRepoDirectory)) {
            ((AbstractScriptWriter)posixWriter).addLocalRepoLine(this.localRepoDirectory);
            ((AbstractScriptWriter)winWriter).addLocalRepoLine(this.localRepoDirectory);
        }
        if (this.finalMavenBuildCommands != null && this.finalMavenBuildCommands.length > 0) {
            for (FinalMavenBuildCommand command : this.finalMavenBuildCommands) {
                if (StringUtils.isEmpty((String)command.getMavenVersion())) {
                    this.getLog().warn((CharSequence)"mavenVersion is not specified in finalMavenBuildCommand, will default to use maven 3.0.5");
                }
                ((AbstractScriptWriter)posixWriter).addCommand(command.getMavenVersionEnum().getMavenRunnerCmd() + "." + "sh", command.getCmdArgs(), true, true);
                ((AbstractScriptWriter)winWriter).addCommand(command.getMavenVersionEnum().getMavenRunnerCmd() + "." + "bat", command.getCmdArgs(), true, true);
            }
        } else {
            throw new MojoExecutionException("You need to configure the command to build your project");
        }
        try {
            if (this.includeSettingsFile != null && this.includeSettingsFile.length() > 0) {
                this.getLog().info((CharSequence)("re write settings file: " + this.includeSettingsFile));
                posixWriter.includeSettingsFile(this.includeSettingsFile, "settings.xml");
            }
            posixWriter.writeScript();
            winWriter.writeScript();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate build script: ", (Exception)e);
        }
    }

    private void initSCMVersion() {
        this.getLog().info((CharSequence)"Trying to detect the SCM information automatically");
        if (this.baseMavenProject.getVersion().contains("SNAPSHOT")) {
            this.getLog().info((CharSequence)"Base project is snapshot, default to master branch");
            this.scmVersionName = "master";
            this.scmVersionType = "branch";
        } else {
            String pomTag = this.baseMavenProject.getOriginalModel().getScm().getTag();
            String pomPropertiesTag = this.baseMavenProject.getProperties().getProperty("atlassian.release.scm.tag.prefix");
            this.scmVersionType = "tag";
            if (pomTag != null && !pomTag.equals("HEAD")) {
                this.getLog().info((CharSequence)"Using <tag> element inside <scm> element as tag");
                this.scmVersionName = pomTag;
            } else if (pomPropertiesTag != null) {
                this.getLog().info((CharSequence)"Using \"${atlassian.release.scm.tag.prefix}-version\" as the tag");
                this.scmVersionName = pomPropertiesTag + "-" + this.project.getVersion();
            } else {
                this.getLog().info((CharSequence)"Defaulting to ${artifactId}-${version} as the tag");
                this.scmVersionName = this.baseMavenProject.getArtifactId() + "-" + this.baseMavenProject.getVersion();
            }
        }
    }
}

