package com.atlassian.distribution;

import org.apache.maven.plugin.MojoExecutionException;

public enum MavenVersion
{
    MAVEN305("mvn305", "3.0.5"),
    MAVEN325("mvn325", "3.2.5"),
    MAVEN339("mvn339", "3.3.9");

    public static final String MAVEN_CMD_POSIX = "sh";
    public static final String MAVEN_CMD_WIN = "bat";

    private final String mavenRunnerCmd;
    private final String versionString;
    private MavenVersion(String mavenRunnerCmd, String versionString)
    {
        this.mavenRunnerCmd = mavenRunnerCmd;
        this.versionString = versionString;
    }

    public String getMavenRunnerCmd()
    {
        return mavenRunnerCmd;
    }

    public String getVersionString()
    {
        return versionString;
    }

    public static MavenVersion getMavenVersion(final String versionNumber) throws MojoExecutionException
    {
        MavenVersion result;
        if("3.0.5".equals(versionNumber))
        {
            result = MAVEN305;
        }
        else if("3.2.5".equals(versionNumber))
        {
            result = MAVEN325;
        }
        else if("3.3.9".equals(versionNumber))
        {
            result = MAVEN339;
        }
        else
        {
            throw new MojoExecutionException("Invalid maven version:" + versionNumber + ". Supported versions include 3.0.5, 3.2.5 and 3.3.9");
        }
        return result;
    }
}
