/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ProductContainerVersionMapper {
    private static final Map<String, TreeMap<ComparableVersion, String>> productMapping = new HashMap<String, TreeMap<ComparableVersion, String>>();
    private static final String TOMCAT6X = "tomcat6x";
    private static final String TOMCAT7X = "tomcat7x";
    private static final String TOMCAT8X = "tomcat8x";
    private static final String TOMCAT85X = "tomcat85x";

    private static void populateVersionMapForProduct(String productId, String tomcat6Version, String tomcat7Version, String tomcat8Version) {
        TreeMap<ComparableVersion, String> versions = new TreeMap<ComparableVersion, String>();
        versions.put(new ComparableVersion(tomcat6Version), TOMCAT6X);
        versions.put(new ComparableVersion(tomcat7Version), TOMCAT7X);
        versions.put(new ComparableVersion(tomcat8Version), TOMCAT8X);
        productMapping.put(productId, versions);
    }

    public static String containerForProductVersion(String productId, String version) {
        Map.Entry<ComparableVersion, String> entry;
        if (version == null) {
            version = "LATEST";
        }
        ComparableVersion productVersion = new ComparableVersion(version);
        TreeMap<ComparableVersion, String> versions = productMapping.get(productId);
        String containerId = null;
        if (versions != null && (entry = versions.floorEntry(productVersion)) != null) {
            containerId = entry.getValue();
        }
        if (containerId == null) {
            containerId = TOMCAT6X;
        }
        return containerId;
    }

    static {
        ProductContainerVersionMapper.populateVersionMapForProduct("bamboo", "0", "5.1.0", "5.10.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("confluence", "0", "5.5", "5.8");
        ProductContainerVersionMapper.populateVersionMapForProduct("jira", "0", "5.2", "7.0.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("refapp", "0", "2.21.0", "3.0.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("stash", "0", "2.0.0", "3.3.0");
        TreeMap<ComparableVersion, String> crowdVersions = new TreeMap<ComparableVersion, String>();
        crowdVersions.put(new ComparableVersion("0"), TOMCAT6X);
        crowdVersions.put(new ComparableVersion("2.7.0"), TOMCAT7X);
        crowdVersions.put(new ComparableVersion("3.1.0"), TOMCAT85X);
        productMapping.put("crowd", crowdVersions);
        TreeMap<ComparableVersion, String> versions = new TreeMap<ComparableVersion, String>();
        versions.put(new ComparableVersion("4.0.0"), TOMCAT8X);
        productMapping.put("bitbucket", versions);
    }
}

