/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.MavenProjectLoader;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;

public class BitbucketProductHandler
extends AbstractProductHandler {
    private static final String ADMIN_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private static final int DEFAULT_JMX_PORT = 7995;
    private static final DefaultArtifactVersion FIRST_SEARCH_VERSION = new DefaultArtifactVersion("4.6.0-a0");
    private static final DefaultArtifactVersion FIRST_SPRING_BOOT_VERSION = new DefaultArtifactVersion("5.0.0-a0");
    private static final String JMX_PORT_FILE = "jmx-port";
    private static final String JMX_URL_FORMAT = "service:jmx:rmi:///jndi/rmi://127.0.0.1:%1$d/jmxrmi";
    private static final String SEARCH_GROUP_ID = "com.atlassian.bitbucket.search";
    private static final String SERVER_GROUP_ID = "com.atlassian.bitbucket.server";
    private final MavenProjectLoader projectLoader;
    private final JavaTaskFactory taskFactory;

    public BitbucketProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory, MavenProjectLoader projectLoader) {
        super(context, goals, new BitbucketPluginProvider(), artifactFactory);
        this.projectLoader = projectLoader;
        this.taskFactory = new JavaTaskFactory(this.log);
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-bitbucket.log"));
        FileUtils.deleteQuietly((File)new File(snapshotDir, ".osgi-cache"));
    }

    @Override
    public String getId() {
        return "bitbucket";
    }

    @Override
    public List<ProductArtifact> getAdditionalPlugins(Product ctx) throws MojoExecutionException {
        ArrayList<ProductArtifact> additionalPlugins = new ArrayList<ProductArtifact>();
        if (new DefaultArtifactVersion(ctx.getVersion()).compareTo((ArtifactVersion)FIRST_SEARCH_VERSION) >= 0) {
            this.projectLoader.loadMavenProject(this.context.getExecutionEnvironment().getMavenSession(), this.context.getProject(), this.artifactFactory.createParentArtifact(SERVER_GROUP_ID, "bitbucket-parent", ctx.getVersion())).flatMap(mavenProject -> Optional.ofNullable(mavenProject.getDependencyManagement()).flatMap(dependencyManager -> dependencyManager.getDependencies().stream().filter(dep -> dep.getGroupId().equals(SEARCH_GROUP_ID)).findFirst().flatMap(dependency -> Optional.ofNullable(dependency.getVersion())))).ifPresent(version -> additionalPlugins.add(new ProductArtifact(SEARCH_GROUP_ID, "embedded-elasticsearch-plugin", (String)version)));
        }
        return additionalPlugins;
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact(SERVER_GROUP_ID, "bitbucket-webapp");
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        File bundledPluginsDir = new File(appDir, "WEB-INF/atlassian-bundled-plugins");
        if (bundledPluginsDir.isDirectory()) {
            return bundledPluginsDir;
        }
        return new File(appDir, "WEB-INF/classes/bitbucket-bundled-plugins.zip");
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public String getDefaultContainerId() {
        return "tomcat8x";
    }

    @Override
    public int getDefaultHttpPort() {
        return 7990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8447;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        String baseUrl = ctx.getBaseUrl();
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"baseurl", (Object)baseUrl).put((Object)"baseurl.display", (Object)baseUrl).put((Object)"bitbucket.home", (Object)BitbucketProductHandler.fixSlashes(this.getHomeDirectory(ctx).getPath())).put((Object)"johnson.spring.lifecycle.synchronousStartup", (Object)Boolean.TRUE.toString());
        return builder.build();
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact(SERVER_GROUP_ID, "bitbucket-it-resources");
    }

    @Override
    public File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File baseDir = homeDir;
        File sharedHomeDir = new File(homeDir, "shared");
        if (sharedHomeDir.exists()) {
            baseDir = sharedHomeDir;
        }
        return new File(new File(baseDir, "plugins"), "installed-plugins");
    }

    @Override
    public void stop(Product ctx) throws MojoExecutionException {
        if (BitbucketProductHandler.isSpringBoot(ctx)) {
            int jmxPort = this.readJmxPort(ctx);
            boolean connected = false;
            try (JMXConnector connector = this.createConnector(jmxPort);){
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connected = true;
                connection.invoke(new ObjectName(ADMIN_OBJECT_NAME), "shutdown", null, null);
            }
            catch (InstanceNotFoundException e) {
                throw new MojoExecutionException("Spring Boot administration is not available; Bitbucket Server will need to be stopped manually", (Exception)e);
            }
            catch (Exception e) {
                if (connected) {
                    this.log.debug((CharSequence)"Bitbucket Server has stopped");
                }
                this.log.warn((CharSequence)"There was an error attempting to stop Bitbucket Server", (Throwable)e);
            }
        } else {
            this.goals.stopWebapp(ctx.getInstanceId(), ctx.getContainerId(), ctx);
        }
    }

    @Override
    protected File extractApplication(Product ctx, File homeDir) throws MojoExecutionException {
        ProductArtifact defaults = this.getArtifact();
        ProductArtifact artifact = new ProductArtifact(ProjectUtils.firstNotNull(ctx.getGroupId(), defaults.getGroupId()), ProjectUtils.firstNotNull(ctx.getArtifactId(), defaults.getArtifactId()), ProjectUtils.firstNotNull(ctx.getVersion(), defaults.getVersion()));
        if ("RELEASE".equals(artifact.getVersion()) || "LATEST".equals(artifact.getVersion())) {
            this.log.info((CharSequence)"Determining latest stable product version...");
            Artifact warArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            String stableVersion = ctx.getArtifactRetriever().getLatestStableVersion(warArtifact);
            this.log.info((CharSequence)("Using latest stable product version: " + stableVersion));
            artifact.setVersion(stableVersion);
            ctx.setVersion(stableVersion);
        }
        File baseDir = this.getBaseDirectory(ctx);
        if (BitbucketProductHandler.isSpringBoot(ctx)) {
            File appDir = new File(baseDir, "app");
            this.goals.unpackWebappWar(appDir, artifact);
            return appDir;
        }
        return this.goals.copyWebappWar(ctx.getId(), baseDir, artifact);
    }

    @Override
    protected void fixJvmArgs(Product ctx) {
        String jvmArgs = JvmArgsFix.empty().with("-Xmx", "1g").apply(ctx.getJvmArgs());
        ctx.setJvmArgs(jvmArgs);
    }

    @Override
    protected int startApplication(Product ctx, File app, File homeDir, Map<String, String> properties) throws MojoExecutionException {
        if (BitbucketProductHandler.isSpringBoot(ctx)) {
            int connectorPort = ctx.isHttps() ? ctx.getHttpsPort() : ctx.getHttpPort();
            int jmxPort = this.pickJmxPort(ctx, connectorPort);
            AntJavaExecutorThread javaThread = this.startJavaThread(ctx, app, BitbucketProductHandler.addJmxProperties(properties, jmxPort));
            this.waitUntilReady(javaThread, jmxPort, ctx.getStartupTimeout());
            return connectorPort;
        }
        return this.goals.startWebapp(ctx.getInstanceId(), app, properties, Collections.emptyList(), Collections.emptyList(), ctx);
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return true;
    }

    private static Map<String, String> addJmxProperties(Map<String, String> properties, int jmxPort) {
        HashMap<String, String> updatedProperties = new HashMap<String, String>(properties);
        updatedProperties.put("com.sun.management.jmxremote.authenticate", "false");
        updatedProperties.put("com.sun.management.jmxremote.port", String.valueOf(jmxPort));
        updatedProperties.put("com.sun.management.jmxremote.ssl", "false");
        updatedProperties.put("com.sun.management.jmxremote.host", "127.0.0.1");
        updatedProperties.put("java.rmi.server.hostname", "127.0.0.1");
        return updatedProperties;
    }

    private static String fixSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    private static InetAddress getLoopbackAddress() {
        try {
            return InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    private static boolean isSpringBoot(Product ctx) {
        return new DefaultArtifactVersion(ctx.getVersion()).compareTo((ArtifactVersion)FIRST_SPRING_BOOT_VERSION) >= 0;
    }

    private static Optional<String> normalizeClientAuth(String value) {
        switch (StringUtils.defaultString((String)value)) {
            case "need": 
            case "require": 
            case "required": 
            case "true": 
            case "yes": {
                return Optional.of("need");
            }
            case "optional": 
            case "want": {
                return Optional.of("want");
            }
        }
        return Optional.empty();
    }

    private JMXConnector createConnector(int jmxPort) throws IOException {
        JMXServiceURL serviceURL = new JMXServiceURL(String.format(JMX_URL_FORMAT, jmxPort));
        return JMXConnectorFactory.connect(serviceURL);
    }

    private int pickJmxPort(Product ctx, int connectorPort) throws MojoExecutionException {
        int jmxPort = ProductHandlerUtil.pickFreePort(7995 == connectorPort ? 0 : 7995, BitbucketProductHandler.getLoopbackAddress());
        if (jmxPort != 7995) {
            Path jmxFile = this.getBaseDirectory(ctx).toPath().resolve(JMX_PORT_FILE);
            try {
                Files.write(jmxFile, String.valueOf(jmxPort).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("JMX port 7995 is not available, and the automatically-selected replacement could not be written to " + jmxFile.toAbsolutePath(), (Exception)e);
            }
        }
        return jmxPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readJmxPort(Product ctx) throws MojoExecutionException {
        Path jmxFile = this.getBaseDirectory(ctx).toPath().resolve(JMX_PORT_FILE);
        try (BufferedReader reader = Files.newBufferedReader(jmxFile, StandardCharsets.UTF_8);){
            int n = Integer.parseInt(reader.readLine());
            return n;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return 7995;
        }
        catch (IOException e) {
            throw new MojoExecutionException("The JMX port could not be read from " + jmxFile.toAbsolutePath(), (Exception)e);
        }
        catch (NumberFormatException e) {
            throw new MojoExecutionException("The JMX port in " + jmxFile.toAbsolutePath() + " is not valid", (Exception)e);
        }
    }

    private AntJavaExecutorThread startJavaThread(Product ctx, File app, Map<String, String> properties) {
        Java java = this.taskFactory.newJavaTask(JavaTaskFactory.output(ctx.getOutput()).systemProperties(properties));
        java.createClasspath().createPathElement().setLocation(app);
        java.createJvmarg().setLine(ctx.getJvmArgs());
        java.createJvmarg().setLine(ctx.getDebugArgs());
        if (ctx.isHttps()) {
            java.createArg().setValue("--server.port=" + ctx.getHttpsPort());
            java.createArg().setValue("--server.ssl.enabled=true");
            java.createArg().setValue("--server.ssl.key-alias=" + ctx.getHttpsKeyAlias());
            java.createArg().setValue("--server.ssl.key-password=" + ctx.getHttpsKeystorePass());
            java.createArg().setValue("--server.ssl.key-store=" + ctx.getHttpsKeystoreFile());
            java.createArg().setValue("--server.ssl.key-store-password=" + ctx.getHttpsKeystorePass());
            java.createArg().setValue("--server.ssl.protocol=" + ctx.getHttpsSSLProtocol());
            BitbucketProductHandler.normalizeClientAuth(ctx.getHttpsClientAuth()).ifPresent(clientAuth -> java.createArg().setValue("--server.ssl.client-auth=" + clientAuth));
        } else {
            java.createArg().setValue("--server.port=" + ctx.getHttpPort());
        }
        java.createArg().setValue("--server.contextPath=" + ctx.getContextPath());
        java.createArg().setValue("--spring.application.admin.enabled=true");
        java.createArg().setValue("--spring.application.admin.jmx-name=org.springframework.boot:type=Admin,name=SpringApplication");
        java.setClassname("org.springframework.boot.loader.WarLauncher");
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
        return javaThread;
    }

    private void waitUntilReady(AntJavaExecutorThread javaThread, int jmxPort, int wait) throws MojoExecutionException {
        long timeout = System.currentTimeMillis() + (long)wait;
        while (System.currentTimeMillis() < timeout) {
            if (javaThread.isFinished()) {
                throw new MojoExecutionException("Bitbucket Server failed to start", (Exception)((Object)javaThread.getBuildException()));
            }
            try (JMXConnector connector = this.createConnector(jmxPort);){
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Boolean ready = (Boolean)connection.getAttribute(new ObjectName(ADMIN_OBJECT_NAME), "Ready");
                if (Boolean.TRUE.equals(ready)) {
                    return;
                }
            }
            catch (AttributeNotFoundException e) {
                throw new MojoExecutionException("org.springframework.boot:type=Admin,name=SpringApplication has no \"Ready\" attribute", (Exception)e);
            }
            catch (InstanceNotFoundException e) {
                this.log.debug((CharSequence)"Spring Boot administration for Bitbucket Server is not available yet");
            }
            catch (ReflectionException e) {
                throw new MojoExecutionException("Failed to retrieve \"Ready\" attribute", (Exception)e);
            }
            catch (IOException e) {
                boolean rethrow = true;
                Throwable t = e;
                while (t != null) {
                    if (t instanceof ConnectException) {
                        this.log.debug((CharSequence)"Bitbucket Server's MBeanServer is not available yet");
                        rethrow = false;
                        t = null;
                        continue;
                    }
                    t = t.getCause();
                }
                if (rethrow) {
                    throw new MojoExecutionException("Could not be connect to Bitbucket Server via JMX", (Exception)e);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            try {
                this.log.debug((CharSequence)"Waiting to retry");
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for Bitbucket Server to start");
            }
        }
        javaThread.interrupt();
        throw new MojoExecutionException("Timed out waiting for Bitbucket Server to start");
    }

    private static class BitbucketPluginProvider
    extends AbstractPluginProvider {
        private BitbucketPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Collections.emptyList();
        }
    }
}

