/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginInformation {
    private static final Pattern MAVEN_PRODUCT_PLUGIN = Pattern.compile("maven-(.*)-plugin");
    private static final Pattern PRODUCT_MAVEN_PLUGIN = Pattern.compile("(.*)-maven-plugin");
    private final String artifactId;
    private final String groupId;
    private final String productId;
    private final String version;

    public PluginInformation(String groupId, String artifactId, String version, String productId) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.productId = productId;
        this.version = version;
    }

    @Deprecated
    public PluginInformation(String productId, String version) {
        this("maven-" + productId + "-plugin", version, productId);
    }

    private PluginInformation(String artifactId, String version, String productId) {
        this("com.atlassian.maven.plugins", artifactId, version, productId);
    }

    public static String extractProductId(String artifactId) {
        Matcher matcher = MAVEN_PRODUCT_PLUGIN.matcher(artifactId);
        if (!matcher.find()) {
            matcher = PRODUCT_MAVEN_PLUGIN.matcher(artifactId);
        }
        return matcher.replaceAll("$1");
    }

    public static PluginInformation fromArtifactId(String artifactId, String version) {
        return new PluginInformation(artifactId, version, PluginInformation.extractProductId(artifactId));
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getId() {
        return this.productId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getVersion() {
        return this.version;
    }
}

