/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ProductContainerVersionMapper {
    private static final Map<String, TreeMap<ComparableVersion, String>> productMapping = new HashMap<String, TreeMap<ComparableVersion, String>>();
    private static final String TOMCAT6X = "tomcat6x";
    private static final String TOMCAT7X = "tomcat7x";
    private static final String TOMCAT8X = "tomcat8x";
    private static final String TOMCAT85X = "tomcat85x";
    private static final String TOMCAT85_6 = "tomcat85_6";
    private static final String TOMCAT9X = "tomcat9x";

    private static <K, V> void populateVersionMapForProduct(String productId, ImmutableMap<String, String> productToTomcatVersions) {
        TreeMap<ComparableVersion, Object> versions = new TreeMap<ComparableVersion, Object>();
        for (String productVersion : productToTomcatVersions.keySet()) {
            versions.put(new ComparableVersion(productVersion), productToTomcatVersions.get((Object)productVersion));
        }
        productMapping.put(productId, versions);
    }

    private static void populateVersionMapForProduct(String productId, String tomcat6Version, String tomcat7Version, String tomcat8Version, String tomcat85Version, String tomcat9Version) {
        TreeMap<ComparableVersion, String> versions = new TreeMap<ComparableVersion, String>();
        if (tomcat6Version != null) {
            versions.put(new ComparableVersion(tomcat6Version), TOMCAT6X);
        }
        if (tomcat7Version != null) {
            versions.put(new ComparableVersion(tomcat7Version), TOMCAT7X);
        }
        if (tomcat8Version != null) {
            versions.put(new ComparableVersion(tomcat8Version), TOMCAT8X);
        }
        if (tomcat85Version != null) {
            versions.put(new ComparableVersion(tomcat85Version), TOMCAT85X);
        }
        if (tomcat9Version != null) {
            versions.put(new ComparableVersion(tomcat9Version), TOMCAT9X);
        }
        productMapping.put(productId, versions);
    }

    private static void populateVersionMapForProduct(String productId, String tomcat6Version, String tomcat7Version, String tomcat8Version, String tomcat85Version) {
        ProductContainerVersionMapper.populateVersionMapForProduct(productId, tomcat6Version, tomcat7Version, tomcat8Version, tomcat85Version, null);
    }

    private static void populateVersionMapForProduct(String productId, String tomcat6Version, String tomcat7Version, String tomcat8Version) {
        ProductContainerVersionMapper.populateVersionMapForProduct(productId, tomcat6Version, tomcat7Version, tomcat8Version, null);
    }

    public static String containerForProductVersion(String productId, String version) {
        Map.Entry<ComparableVersion, String> entry;
        if (version == null) {
            version = "LATEST";
        }
        ComparableVersion productVersion = new ComparableVersion(version);
        TreeMap<ComparableVersion, String> versions = productMapping.get(productId);
        String containerId = null;
        if (versions != null && (entry = versions.floorEntry(productVersion)) != null) {
            containerId = entry.getValue();
        }
        if (containerId == null) {
            containerId = TOMCAT6X;
        }
        return containerId;
    }

    static {
        ProductContainerVersionMapper.populateVersionMapForProduct("bamboo", "0", "5.1.0", "5.10.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("bitbucket", null, null, "4.0.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("confluence", "0", "5.5", "5.8", null, "6.10");
        ProductContainerVersionMapper.populateVersionMapForProduct("crowd", "0", "2.7.0", null, "3.1.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("jira", (ImmutableMap<String, String>)new ImmutableMap.Builder().put((Object)"0", (Object)TOMCAT6X).put((Object)"5.2", (Object)TOMCAT7X).put((Object)"7.0.0", (Object)TOMCAT8X).put((Object)"7.3.0", (Object)TOMCAT85_6).put((Object)"7.6.0", (Object)"tomcat85_29").put((Object)"7.12.0", (Object)TOMCAT85X).build());
        ProductContainerVersionMapper.populateVersionMapForProduct("refapp", "0", "2.21.0", "3.0.0");
        ProductContainerVersionMapper.populateVersionMapForProduct("stash", "0", "2.0.0", "3.3.0");
    }
}

