/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.updater.LocalSdk;
import com.atlassian.maven.plugins.updater.SdkPackageType;
import com.atlassian.maven.plugins.updater.SdkResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update", requiresProject=false)
public class UpdateMojo
extends AbstractAmpsMojo {
    private static final String INSTALLTYPE_FILE_NAME = "installtype.txt";
    @Component
    private SdkResource sdkResource;
    @Component
    private LocalSdk localSdk;
    @Parameter(property="update.version")
    private String updateVersion;
    @Parameter(property="sdk.archive.path")
    private String sdkArchivePath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File sdkArchive;
        SdkPackageType packageType = this.localSdk.sdkPackageType();
        this.checkUpdatePreconditions(packageType);
        if (StringUtils.isNotBlank((String)this.sdkArchivePath)) {
            sdkArchive = new File(this.sdkArchivePath);
            if (!sdkArchive.isFile() || !sdkArchive.canRead()) {
                throw new MojoExecutionException("Can't read archive file at " + this.sdkArchivePath);
            }
            this.getLog().info((CharSequence)("Using local file " + sdkArchive.getAbsolutePath() + " for SDK install."));
        } else {
            String downloadVersion = StringUtils.isNotBlank((String)this.updateVersion) ? this.updateVersion : this.sdkResource.getLatestSdkVersion(packageType);
            String ourVersion = this.getAmpsPluginVersion();
            if (ourVersion.equals(downloadVersion)) {
                this.getLog().info((CharSequence)("SDK is already at the latest version: " + ourVersion));
                return;
            }
            this.getLog().info((CharSequence)("Downloading SDK version " + downloadVersion + " from marketplace.atlassian.com..."));
            sdkArchive = this.sdkResource.downloadSdk(packageType, downloadVersion);
            this.getLog().info((CharSequence)"Download complete.");
            this.getLog().debug((CharSequence)("SDK download artifact at " + sdkArchive.getAbsolutePath()));
        }
        this.getLog().info((CharSequence)"Beginning upgrade of SDK.");
        if (packageType == SdkPackageType.TGZ) {
            this.installSdkFromTarGz(sdkArchive);
        } else {
            this.installSdkFromExecutable(sdkArchive, packageType);
        }
        this.getLog().info((CharSequence)"SDK upgrade successful.");
    }

    private void installSdkFromTarGz(File sdkZip) throws MojoExecutionException {
        String sdkHome = this.localSdk.sdkHomeDir();
        try {
            ZipUtils.untargz(sdkZip, sdkHome, 1);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error extracting new SDK", (Exception)e);
        }
    }

    private void installSdkFromExecutable(File sdkInstaller, SdkPackageType packageType) throws MojoExecutionException {
        sdkInstaller.setExecutable(true);
        ArrayList<String> commands = new ArrayList<String>();
        Collections.addAll(commands, packageType.installCommands());
        commands.add(sdkInstaller.getAbsolutePath());
        ProcessBuilder installer = new ProcessBuilder(commands);
        BufferedReader in = null;
        BufferedReader err = null;
        try {
            String line;
            Process p = installer.start();
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            this.getLog().debug((CharSequence)"Returned input from installer process follows:");
            while ((line = in.readLine()) != null) {
                this.getLog().info((CharSequence)line);
            }
            if (err.ready()) {
                this.getLog().info((CharSequence)"Errors returned by subprocess installer:");
                while ((line = err.readLine()) != null) {
                    this.getLog().error((CharSequence)line);
                }
            }
            try {
                if (p.waitFor() != 0) {
                    throw new MojoExecutionException("Installer failed; see above for errors.");
                }
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Subprocess installer interrupted", (Exception)e);
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("error from installer subprocess", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(err);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Reader)err);
    }

    private void checkUpdatePreconditions(SdkPackageType packageType) throws MojoExecutionException {
        if (packageType == SdkPackageType.TGZ) {
            String sdkHome = this.localSdk.sdkHomeDir();
            if (sdkHome == null) {
                throw new MojoExecutionException("SDK update must be run from the atlas-update script.");
            }
            File sdkHomeDir = new File(sdkHome);
            if (!sdkHomeDir.exists() || !sdkHomeDir.canWrite()) {
                throw new MojoExecutionException("To update successfully, SDK home directory " + sdkHome + " must be writable by the current user.");
            }
            this.getLog().debug((CharSequence)("Detected current SDK install from ATLAS_HOME in " + sdkHomeDir.getAbsolutePath()));
        }
    }
}

