/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.MavenProjectLoader;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;

public class BitbucketProductHandler
extends AbstractWebappProductHandler {
    private static final DefaultArtifactVersion FIRST_SEARCH_VERSION = new DefaultArtifactVersion("4.6.0-a0");
    private static final String SEARCH_GROUP_ID = "com.atlassian.bitbucket.search";
    private static final String SERVER_GROUP_ID = "com.atlassian.bitbucket.server";
    private final MavenProjectLoader projectLoader;

    public BitbucketProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory, MavenProjectLoader projectLoader) {
        super(context, goals, new BitbucketPluginProvider(), artifactFactory);
        this.projectLoader = projectLoader;
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-bitbucket.log"));
        FileUtils.deleteQuietly((File)new File(snapshotDir, ".osgi-cache"));
    }

    @Override
    public String getId() {
        return "bitbucket";
    }

    @Override
    public List<ProductArtifact> getAdditionalPlugins(Product ctx) throws MojoExecutionException {
        ArrayList<ProductArtifact> additionalPlugins = new ArrayList<ProductArtifact>();
        if (new DefaultArtifactVersion(ctx.getVersion()).compareTo((ArtifactVersion)FIRST_SEARCH_VERSION) >= 0) {
            this.projectLoader.loadMavenProject(this.context.getExecutionEnvironment().getMavenSession(), this.context.getProject(), this.artifactFactory.createParentArtifact(SERVER_GROUP_ID, "bitbucket-parent", ctx.getVersion())).flatMap(mavenProject -> Optional.ofNullable(mavenProject.getDependencyManagement()).flatMap(dependencyManager -> dependencyManager.getDependencies().stream().filter(dep -> dep.getGroupId().equals(SEARCH_GROUP_ID)).findFirst().flatMap(dependency -> Optional.ofNullable(dependency.getVersion())))).ifPresent(version -> additionalPlugins.add(new ProductArtifact(SEARCH_GROUP_ID, "embedded-elasticsearch-plugin", (String)version)));
        }
        return additionalPlugins;
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact(SERVER_GROUP_ID, "bitbucket-webapp");
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        File bundledPluginsDir = new File(appDir, "WEB-INF/atlassian-bundled-plugins");
        if (bundledPluginsDir.isDirectory()) {
            return bundledPluginsDir;
        }
        return new File(appDir, "WEB-INF/classes/bitbucket-bundled-plugins.zip");
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "data/db.log"));
        configFiles.add(new File(homeDir, "data/db.script"));
        configFiles.add(new File(homeDir, "data/db.properties"));
        configFiles.add(new File(homeDir, "shared/data/db.log"));
        configFiles.add(new File(homeDir, "shared/data/db.script"));
        configFiles.add(new File(homeDir, "shared/data/db.properties"));
        return configFiles;
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public String getDefaultContainerId() {
        return "tomcat8x";
    }

    @Override
    public int getDefaultHttpPort() {
        return 7990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8447;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        return super.getReplacements(ctx);
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        String baseUrl = MavenGoals.getBaseUrl(ctx, ctx.getHttpPort());
        return ImmutableMap.builder().putAll(super.getSystemProperties(ctx)).put((Object)"baseurl", (Object)baseUrl).put((Object)"baseurl.display", (Object)baseUrl).put((Object)"bitbucket.home", (Object)BitbucketProductHandler.fixSlashes(this.getHomeDirectory(ctx).getPath())).put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8").put((Object)"johnson.spring.lifecycle.synchronousStartup", (Object)Boolean.TRUE.toString()).build();
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact(SERVER_GROUP_ID, "bitbucket-it-resources");
    }

    @Override
    public File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        File baseDir = homeDir;
        File sharedHomeDir = new File(homeDir, "shared");
        if (sharedHomeDir.exists()) {
            baseDir = sharedHomeDir;
        }
        return new File(new File(baseDir, "plugins"), "installed-plugins");
    }

    private static String fixSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    private static class BitbucketPluginProvider
    extends AbstractPluginProvider {
        private BitbucketPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Collections.emptyList();
        }
    }
}

