/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseMssqlImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseMysqlImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseOracle10gImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseOracle12cImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabasePostgresImpl;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum JiraDatabaseType {
    HSQL("hsql", true, "jdbc:hsqldb", "org.hsqldb.jdbcDriver", "org.hsqldb:hsqldb", ds -> null),
    H2("h2", true, "jdbc:h2", "org.h2.Driver", "com.h2database:h2", ds -> null),
    MYSQL("mysql", false, "jdbc:mysql", "com.mysql.jdbc.Driver", "mysql:mysql-connector-java", JiraDatabaseMysqlImpl::new),
    POSTGRES("postgres72", true, "jdbc:postgresql", "org.postgresql.Driver", "org.postgresql:postgresql", JiraDatabasePostgresImpl::new),
    ORACLE_12C("oracle12c", false, "jdbc:oracle", "oracle.jdbc.OracleDriver", "com.oracle:ojdbc7", JiraDatabaseOracle12cImpl::new){

        @Override
        boolean matches(DataSource dataSource) {
            return super.matches(dataSource) && dataSource.getLibArtifacts().stream().anyMatch(driver -> "ojdbc7".equals(driver.getArtifactId()));
        }
    }
    ,
    ORACLE_10G("oracle10g", false, "jdbc:oracle", "oracle.jdbc.OracleDriver", "com.oracle:ojdbc6", JiraDatabaseOracle10gImpl::new),
    MSSQL("mssql", true, "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "net.sourceforge.jtds:jtds", JiraDatabaseMssqlImpl::new),
    MSSQL_JTDS("mssql", true, "jdbc:jtds", "net.sourceforge.jtds.jdbc.Driver", "net.sourceforge.jtds:jtds", JiraDatabaseMssqlImpl::new);

    private final String dbType;
    private final boolean hasSchema;
    private final String uriPrefix;
    private final String driverClassName;
    private final String libArtifact;
    private final Function<DataSource, JiraDatabase> jiraDbSupplier;

    @Nonnull
    public static Optional<JiraDatabaseType> getDatabaseType(DataSource dataSource) {
        return Arrays.stream(JiraDatabaseType.values()).filter(dbType -> dbType.matches(dataSource)).findFirst();
    }

    private JiraDatabaseType(String dbType, boolean hasSchema, String uriPrefix, @Nonnull String driverClassName, String libArtifact, Function<DataSource, JiraDatabase> jiraDbSupplier) {
        this.dbType = dbType;
        this.hasSchema = hasSchema;
        this.uriPrefix = uriPrefix;
        this.driverClassName = driverClassName;
        this.libArtifact = libArtifact;
        this.jiraDbSupplier = Objects.requireNonNull(jiraDbSupplier);
    }

    boolean matches(DataSource dataSource) {
        return this.accept(dataSource.getUrl()) && this.driverClassName.equals(dataSource.getDriver());
    }

    private boolean accept(String uri) {
        return null != uri && uri.trim().startsWith(this.uriPrefix);
    }

    public String getDbType() {
        return this.dbType;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getLibArtifact() {
        return this.libArtifact;
    }

    @Nullable
    public JiraDatabase getJiraDatabase(DataSource dataSource) {
        return this.jiraDbSupplier.apply(dataSource);
    }

    public String toString() {
        return super.toString();
    }
}

