/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraOracleDatabase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class JiraDatabaseOracle12cImpl
extends AbstractJiraOracleDatabase {
    public JiraDatabaseOracle12cImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String getSqlToDropAndCreateUser() {
        String dumpFileDirectoryPath = new File(this.getDataSource().getDumpFilePath()).getParent();
        return this.readFileToString("oracle12c-template.sql").replace("v_data_pump_dir", dumpFileDirectoryPath).replace("v_jira_user", this.getDataSource().getUsername()).replace("v_jira_pwd", this.getDataSource().getPassword());
    }

    private String readFileToString(String name) {
        InputStream fileStream = this.getClass().getResourceAsStream(name);
        Objects.requireNonNull(fileStream, String.format("Could not find '%s' on classpath of %s", name, this.getClass().getName()));
        try {
            return IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    protected Map<String, String> getDriverProperties() {
        return Collections.singletonMap("internal_logon", "SYSDBA");
    }
}

