/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import com.atlassian.maven.plugins.amps.util.MapUtils;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractJiraOracleDatabase
extends AbstractJiraDatabase {
    protected static final String DATA_PUMP_DIR = "DATA_PUMP_DIR";

    protected AbstractJiraOracleDatabase(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String dropDatabase() {
        return null;
    }

    @Override
    protected String dropUser() {
        return null;
    }

    @Override
    protected String createDatabase() {
        return null;
    }

    @Override
    protected String createUser() {
        return null;
    }

    @Override
    protected String grantPermissionForUser() {
        return null;
    }

    @Override
    protected String getDatabaseName(String url) {
        return this.getDataSource().getSchema();
    }

    @Override
    public Xpp3Dom getConfigDatabaseTool() throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.IMPDP.equals((Object)ImportMethod.getValueOf(this.getDataSource().getImportMethod()))) {
            File dumpFile = new File(this.getDataSource().getDumpFilePath());
            File dumpFileDirectory = dumpFile.getParentFile();
            String dumpFileName = dumpFile.getName();
            dumpFile.setExecutable(true, false);
            dumpFile.setReadable(true, false);
            dumpFile.setWritable(true, false);
            dumpFileDirectory.setExecutable(true, false);
            dumpFileDirectory.setReadable(true, false);
            dumpFileDirectory.setWritable(true, false);
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "impdp"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name("argument"), this.getDataSource().getUsername() + "/" + this.getDataSource().getPassword()), MojoExecutor.element(MojoExecutor.name("argument"), "DUMPFILE=" + dumpFileName), MojoExecutor.element(MojoExecutor.name("argument"), "DIRECTORY=DATA_PUMP_DIR")));
        }
        return configDatabaseTool;
    }

    @Override
    public Xpp3Dom getPluginConfiguration() {
        String sql = this.getSqlToDropAndCreateUser();
        this.getLog().info((CharSequence)("Oracle initialization database SQL: " + sql));
        Xpp3Dom sqlPluginConfiguration = this.systemDatabaseConfiguration();
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "sqlCommand", sql);
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "delimiter", "/");
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "delimiterType", "row");
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "driverProperties", MapUtils.join(this.getDriverProperties(), "=", ","));
        return sqlPluginConfiguration;
    }

    protected abstract String getSqlToDropAndCreateUser();

    private static void addChild(Xpp3Dom parentNode, String childName, String childValue) {
        parentNode.addChild(MojoExecutor.element(MojoExecutor.name(childName), childValue).toDom());
    }

    @Nonnull
    protected Map<String, String> getDriverProperties() {
        return Collections.emptyMap();
    }
}

