/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.LibArtifact;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DataSource {
    private static final String[] FIELDS_TO_EXCLUDE_FROM_TO_STRING = new String[]{"password", "systemPassword"};
    private String url;
    private String schema;
    private String driver;
    private String username;
    private String password;
    private String jndi;
    private String type;
    private String transactionSupport;
    private String properties;
    private String cargoString;
    private List<LibArtifact> libArtifacts = Lists.newArrayList();
    private String defaultDatabase;
    private String systemUsername;
    private String systemPassword;
    private String dumpFilePath;
    private String importMethod = "sql";

    public DataSource() {
    }

    public String getCargoString() {
        if (this.cargoString != null) {
            return this.cargoString;
        }
        ArrayList cargoProperties = Lists.newArrayList();
        cargoProperties.add("cargo.datasource.url=" + (String)Objects.firstNonNull((Object)this.url, (Object)""));
        cargoProperties.add("cargo.datasource.driver=" + (String)Objects.firstNonNull((Object)this.driver, (Object)""));
        cargoProperties.add("cargo.datasource.username=" + (String)Objects.firstNonNull((Object)this.username, (Object)""));
        cargoProperties.add("cargo.datasource.password=" + (String)Objects.firstNonNull((Object)this.password, (Object)""));
        cargoProperties.add("cargo.datasource.jndi=" + (String)Objects.firstNonNull((Object)this.jndi, (Object)""));
        if (!StringUtils.isBlank((String)this.type)) {
            cargoProperties.add("cargo.datasource.type=" + this.type);
        }
        if (!StringUtils.isBlank((String)this.transactionSupport)) {
            cargoProperties.add("cargo.datasource.transactionsupport=" + this.transactionSupport);
        }
        if (!StringUtils.isBlank((String)this.properties)) {
            cargoProperties.add("cargo.datasource.properties=" + this.properties);
        }
        this.cargoString = StringUtils.join((Collection)cargoProperties, (String)"|");
        return this.cargoString;
    }

    public DataSource(String cargoString) {
        this.cargoString = cargoString;
    }

    public void useForUnsetValues(DataSource defaultValues) {
        if (this.jndi == null) {
            this.jndi = defaultValues.jndi;
        }
        if (this.url == null) {
            this.url = defaultValues.url;
        }
        if (this.schema == null) {
            this.schema = defaultValues.schema;
        }
        if (this.driver == null) {
            this.driver = defaultValues.driver;
        }
        if (this.username == null) {
            this.username = defaultValues.username;
        }
        if (this.password == null) {
            this.password = defaultValues.password;
        }
        if (this.type == null) {
            this.type = defaultValues.type;
        }
        if (this.transactionSupport == null) {
            this.transactionSupport = defaultValues.transactionSupport;
        }
        if (this.properties == null) {
            this.properties = defaultValues.properties;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getJndi() {
        return this.jndi;
    }

    public void setJndi(String jndi) {
        this.jndi = jndi;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public List<LibArtifact> getLibArtifacts() {
        return this.libArtifacts;
    }

    public void setLibArtifacts(List<LibArtifact> libArtifacts) {
        this.libArtifacts = libArtifacts;
    }

    public void setCargoString(String cargoString) {
        this.cargoString = cargoString;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
    }

    public String getSystemUsername() {
        return this.systemUsername;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public String getSystemPassword() {
        return this.systemPassword;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public String getDumpFilePath() {
        return this.dumpFilePath;
    }

    public void setDumpFilePath(String dumpFilePath) {
        this.dumpFilePath = dumpFilePath;
    }

    public String getImportMethod() {
        return this.importMethod;
    }

    public void setImportMethod(String importMethod) {
        this.importMethod = importMethod;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).setExcludeFieldNames(FIELDS_TO_EXCLUDE_FROM_TO_STRING).toString();
    }
}

