/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.updater;

import com.atlassian.maven.plugins.updater.SdkPackageType;
import com.atlassian.maven.plugins.updater.SdkResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class MarketplaceSdkResource
extends AbstractLogEnabled
implements SdkResource {
    private static final String SDK_DOWNLOAD_URL_ROOT = "https://marketplace.atlassian.com/rest/1.0/plugins/atlassian-plugin-sdk-";
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int READ_TIMEOUT = 15000;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public File downloadLatestSdk(SdkPackageType packageType) {
        return this.downloadSdk(packageType, this.getLatestSdkVersion(packageType));
    }

    @Override
    public File downloadSdk(SdkPackageType packageType, String version) {
        File sdkDownloadTempFile;
        Map<?, ?> rootAsMap = this.getPluginJsonAsMap(packageType);
        String versionDownloadPath = null;
        Map versionsElement = (Map)rootAsMap.get("versions");
        ArrayList versions = (ArrayList)versionsElement.get("versions");
        block7: for (Map versionData : versions) {
            if (!versionData.get("version").equals(version)) continue;
            ArrayList links = (ArrayList)versionData.get("links");
            for (Map link : links) {
                if (!link.get("rel").equals("binary")) continue;
                versionDownloadPath = (String)link.get("href");
                continue block7;
            }
        }
        if (versionDownloadPath == null) {
            throw new RuntimeException("Couldn't find SDK version for " + packageType.key() + " on marketplace with version " + version);
        }
        HttpURLConnection conn = null;
        try {
            URL url;
            String tempFileSuffix = packageType == SdkPackageType.WINDOWS ? ".exe" : (packageType == SdkPackageType.MAC ? ".pkg" : (packageType == SdkPackageType.RPM ? ".rpm" : (packageType == SdkPackageType.DEB ? ".deb" : ".tar.gz")));
            sdkDownloadTempFile = File.createTempFile("atlassian-plugin-sdk-" + version, tempFileSuffix);
            try {
                url = new URL(versionDownloadPath);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            conn = (HttpURLConnection)url.openConnection();
            this.copyResponseStreamToFile(conn.getInputStream(), sdkDownloadTempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return sdkDownloadTempFile;
    }

    @Override
    public String getLatestSdkVersion(SdkPackageType packageType) {
        Map<?, ?> rootAsMap = this.getPluginJsonAsMap(packageType);
        if (rootAsMap.containsKey("version")) {
            Map version = (Map)rootAsMap.get("version");
            return (String)version.get("version");
        }
        return "";
    }

    private void copyResponseStreamToFile(InputStream stream, File file) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<?, ?> getPluginJsonAsMap(SdkPackageType packageType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

