/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.updater;

import com.atlassian.maven.plugins.updater.LocalSdk;
import com.atlassian.maven.plugins.updater.SdkPackageType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class FileSystemLocalSdk
implements LocalSdk {
    private static final String INSTALLTYPE_FILE_NAME = "installtype.txt";

    @Override
    public SdkPackageType sdkPackageType() {
        SdkPackageType detectedType;
        String sdkHome = this.sdkHomeDir();
        File installType = new File(sdkHome, INSTALLTYPE_FILE_NAME);
        if (installType.exists() && installType.canRead()) {
            String packageType = this.getInstallType(installType);
            try {
                detectedType = SdkPackageType.getType(packageType);
            }
            catch (IllegalArgumentException e) {
                detectedType = SdkPackageType.TGZ;
            }
        } else {
            detectedType = SdkPackageType.TGZ;
        }
        return detectedType;
    }

    @Override
    public String sdkHomeDir() {
        return System.getenv("ATLAS_HOME");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getInstallType(File file) {
        String string;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            string = in.readLine().trim();
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("file " + file.getAbsolutePath() + " wasn't found, even though it exists");
                catch (IOException e2) {
                    throw new RuntimeException("couldn't read from file " + file.getAbsolutePath() + " even though we checked it for readability");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        return string;
    }
}

