/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.ProductArtifact;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;

public class ArtifactRetriever {
    private final ArtifactResolver artifactResolver;
    private final ArtifactFactory artifactFactory;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final RepositoryMetadataManager repositoryMetadataManager;

    public ArtifactRetriever(ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, RepositoryMetadataManager repositoryMetadataManager) {
        this.artifactResolver = artifactResolver;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.repositoryMetadataManager = repositoryMetadataManager;
    }

    public String resolve(ProductArtifact dependency) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "compile", "jar");
        try {
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Cannot resolve artifact", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Cannot find artifact", (Exception)((Object)e));
        }
        return artifact.getFile().getPath();
    }

    public String getLatestStableVersion(Artifact artifact) throws MojoExecutionException {
        Object metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) || "RELEASE".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, this.remoteRepositories, this.localRepository);
            artifact.addMetadata((ArtifactMetadata)metadata);
            Metadata repoMetadata = metadata.getMetadata();
            String version = null;
            if (repoMetadata != null && repoMetadata.getVersioning() != null) {
                version = this.constructVersion(repoMetadata.getVersioning());
            }
            if (version == null) {
                version = artifact.getBaseVersion();
            }
            return version;
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new MojoExecutionException("Error resolving stable version", (Exception)((Object)e));
        }
    }

    private String constructVersion(Versioning versioning) {
        List versions = versioning.getVersions();
        DefaultArtifactVersion latestVersion = null;
        for (String version : versions) {
            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
            if (StringUtils.isNotBlank((String)artifactVersion.getQualifier())) continue;
            if (null == latestVersion) {
                latestVersion = artifactVersion;
                continue;
            }
            if (artifactVersion.compareTo((ArtifactVersion)latestVersion) <= 0) continue;
            latestVersion = artifactVersion;
        }
        if (null != latestVersion) {
            return latestVersion.toString();
        }
        return null;
    }
}

