/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseMssqlImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseMysqlImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseOracle10gImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseOracle12cImpl;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabasePostgresImpl;
import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public enum JiraDatabaseType {
    HSQL("hsql", true, "jdbc:hsqldb", "org.hsqldb.jdbcDriver", ds -> null),
    H2("h2", true, "jdbc:h2", "org.h2.Driver", ds -> null),
    MYSQL("mysql", false, "jdbc:mysql", "com.mysql.jdbc.Driver", JiraDatabaseMysqlImpl::new),
    POSTGRES("postgres72", true, "jdbc:postgresql", "org.postgresql.Driver", JiraDatabasePostgresImpl::new),
    ORACLE_12C("oracle12c", false, "jdbc:oracle", "oracle.jdbc.OracleDriver", JiraDatabaseOracle12cImpl::new){

        @Override
        boolean matches(DataSource dataSource) {
            return super.matches(dataSource) && JiraDatabaseType.dbVersionMatches(dataSource, version -> version.startsWith(JiraDatabaseType.ORACLE_12C_VERSION_PREFIX));
        }
    }
    ,
    ORACLE_10G("oracle10g", false, "jdbc:oracle", "oracle.jdbc.OracleDriver", JiraDatabaseOracle10gImpl::new),
    MSSQL("mssql", true, "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", JiraDatabaseMssqlImpl::new),
    MSSQL_JTDS("mssql", true, "jdbc:jtds", "net.sourceforge.jtds.jdbc.Driver", JiraDatabaseMssqlImpl::new);

    public static final String ORACLE_12C_VERSION_PREFIX = "Oracle Database 12c";
    private final String dbType;
    private final boolean hasSchema;
    private final String uriPrefix;
    private final String driverClassName;
    private final Function<DataSource, JiraDatabase> jiraDbSupplier;

    @ParametersAreNonnullByDefault
    private static boolean dbVersionMatches(DataSource dataSource, Predicate<String> predicate) {
        return dataSource.getJdbcMetaData(DatabaseMetaData::getDatabaseProductVersion).filter(predicate).isPresent();
    }

    @Nonnull
    public static Optional<JiraDatabaseType> getDatabaseType(DataSource dataSource) {
        return Arrays.stream(JiraDatabaseType.values()).filter(dbType -> dbType.matches(dataSource)).findFirst();
    }

    private JiraDatabaseType(String dbType, boolean hasSchema, @Nonnull String uriPrefix, String driverClassName, Function<DataSource, JiraDatabase> jiraDbSupplier) {
        this.dbType = dbType;
        this.hasSchema = hasSchema;
        this.uriPrefix = uriPrefix;
        this.driverClassName = driverClassName;
        this.jiraDbSupplier = Objects.requireNonNull(jiraDbSupplier);
    }

    boolean matches(DataSource dataSource) {
        return this.startsWithExpectedPrefix(dataSource.getUrl()) && this.driverClassName.equals(dataSource.getDriver());
    }

    private boolean startsWithExpectedPrefix(String uri) {
        return uri != null && uri.trim().startsWith(this.uriPrefix);
    }

    public String getDbType() {
        return this.dbType;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    @Nullable
    public JiraDatabase getJiraDatabase(DataSource dataSource) {
        return this.jiraDbSupplier.apply(dataSource);
    }

    public String toString() {
        return super.toString();
    }
}

