/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate-test-manifest")
public class ValidateTestManifestMojo
extends AbstractAmpsMojo {
    @Parameter(property="manifest.validation.skip")
    protected boolean skipManifestValidation = false;
    @Parameter
    private Map<String, String> testInstructions = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldBuildTestPlugin()) {
            File mfile = FileUtils.file(this.getMavenContext().getProject().getBuild().getTestOutputDirectory(), "META-INF", "MANIFEST.MF");
            if (!this.skipManifestValidation && mfile.exists()) {
                this.getLog().info((CharSequence)"Manifest found, validating...");
                try {
                    this.checkManifestEndsWithNewLine(mfile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to read manifest", (Exception)e);
                }
                this.getLog().info((CharSequence)"Manifest validated");
            } else {
                this.getLog().info((CharSequence)"No manifest found or validation skip flag specified, skipping validation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifestEndsWithNewLine(File mfile) throws IOException, MojoExecutionException, MojoFailureException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(mfile);
            long bytesToSkip = mfile.length() - 1L;
            long bytesSkipped = ((InputStream)is).skip(bytesToSkip);
            if (bytesSkipped != bytesToSkip) {
                throw new MojoExecutionException("Could not skip " + bytesToSkip + " bytes reading " + mfile.getAbsolutePath());
            }
            if (((InputStream)is).read() != 10) {
                throw new MojoFailureException("Manifests must end with a new line. " + mfile.getAbsolutePath() + " doesn't.");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

