/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.Application;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Product {
    protected String containerId;
    protected int httpPort = 0;
    protected int rmiPort = 0;
    private Boolean useHttps;
    private int httpsPort;
    private String httpsClientAuth;
    private String httpsSslProtocol;
    private String httpsKeystoreFile;
    private String httpsKeystorePass;
    private String httpsKeyAlias;
    private Boolean httpsHttpSecure;
    protected String contextPath;
    protected String server;
    protected String version;
    protected String jvmArgs = "";
    protected String debugArgs = "";
    protected File log4jProperties;
    protected String productDataVersion;
    protected String productDataPath = "";
    protected String dataHome = "";
    private List<Application> applications = new ArrayList<Application>();
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    private String salVersion;
    private String pdkVersion;
    private String restVersion;
    private String webConsoleVersion;
    private Boolean enableFastdev;
    private String fastdevVersion;
    private Boolean enableDevToolbox;
    private String devToolboxVersion;
    private Boolean enableQuickReload;
    private String quickReloadVersion;
    private Boolean enablePde;
    private String pdeVersion;
    protected String id;
    protected String instanceId;
    private ArtifactRetriever artifactRetriever;
    private Boolean installPlugin;
    private Map<String, Object> systemProperties = new HashMap<String, Object>();
    private String output;
    private int jvmDebugPort;
    private int startupTimeout = 0;
    private int shutdownTimeout = 0;
    private Boolean synchronousStartup;
    private String groupId;
    private String artifactId;
    protected List<DataSource> dataSources;
    private String sharedHome;
    private int ajpPort;

    public Product merge(Product product) {
        Product prod = new Product();
        prod.setOutput(this.output == null ? product.getOutput() : this.output);
        HashMap<String, Object> sysProps = new HashMap<String, Object>();
        sysProps.putAll(product.getSystemPropertyVariables());
        sysProps.putAll(this.systemProperties);
        prod.setSystemPropertyVariables(sysProps);
        prod.setInstallPlugin(this.installPlugin == null ? product.isInstallPlugin() : this.installPlugin);
        prod.setArtifactRetriever(this.artifactRetriever == null ? product.getArtifactRetriever() : this.artifactRetriever);
        prod.setId(this.id == null ? product.getId() : this.id);
        prod.setInstanceId(this.instanceId == null ? product.getInstanceId() : this.instanceId);
        prod.setWebConsoleVersion(this.webConsoleVersion == null ? product.getWebConsoleVersion() : this.webConsoleVersion);
        prod.setEnableFastdev(this.enableFastdev == null ? product.isEnableFastdev() : this.enableFastdev);
        prod.setFastdevVersion(this.fastdevVersion == null ? product.getFastdevVersion() : this.fastdevVersion);
        prod.setEnableDevToolbox(this.enableDevToolbox == null ? product.isEnableDevToolbox() : this.enableDevToolbox);
        prod.setDevToolboxVersion(this.devToolboxVersion == null ? product.getDevToolboxVersion() : this.devToolboxVersion);
        prod.setEnableQuickReload(this.enableQuickReload == null ? product.isEnableQuickReload() : this.enableQuickReload);
        prod.setQuickReloadVersion(this.quickReloadVersion == null ? product.getQuickReloadVersion() : this.quickReloadVersion);
        prod.setEnablePde(this.enablePde == null ? product.isEnablePde() : this.enablePde);
        prod.setPdeVersion(this.pdeVersion == null ? product.getPdeVersion() : this.pdeVersion);
        prod.setRestVersion(this.restVersion == null ? product.getRestVersion() : this.restVersion);
        prod.setPdkVersion(this.pdkVersion == null ? product.getPdkVersion() : this.pdkVersion);
        prod.setSalVersion(this.salVersion == null ? product.getSalVersion() : this.salVersion);
        prod.setBundledArtifacts(this.bundledArtifacts.isEmpty() ? product.getBundledArtifacts() : this.bundledArtifacts);
        prod.setPluginArtifacts(this.pluginArtifacts.isEmpty() ? product.getPluginArtifacts() : this.pluginArtifacts);
        prod.setLibArtifacts(this.libArtifacts.isEmpty() ? product.getLibArtifacts() : this.libArtifacts);
        prod.setApplications(this.applications.isEmpty() ? product.getApplications() : this.applications);
        prod.setDataPath(StringUtils.isBlank((String)this.productDataPath) ? product.getDataPath() : this.productDataPath);
        prod.setDataVersion(this.productDataVersion == null ? product.getDataVersion() : this.productDataVersion);
        prod.setDataHome(this.dataHome == null ? product.getDataHome() : this.dataHome);
        prod.setLog4jProperties(this.log4jProperties == null ? product.getLog4jProperties() : this.log4jProperties);
        prod.setJvmArgs(StringUtils.stripToNull((String)this.jvmArgs) == null ? product.getJvmArgs() : this.jvmArgs);
        prod.setDebugArgs(StringUtils.stripToNull((String)this.debugArgs) == null ? product.getDebugArgs() : this.debugArgs);
        prod.setDataSources(this.dataSources == null ? product.getDataSources() : this.dataSources);
        prod.setGroupId(this.groupId == null ? product.getGroupId() : this.groupId);
        prod.setArtifactId(this.artifactId == null ? product.getArtifactId() : this.artifactId);
        prod.setVersion(this.version == null ? product.getVersion() : this.version);
        prod.setServer(this.server == null ? product.getServer() : this.server);
        prod.setContextPath(this.contextPath == null ? product.getContextPath() : this.contextPath);
        prod.setContainerId(this.containerId == null ? product.getContainerId() : this.containerId);
        prod.setRmiPort(this.rmiPort == 0 ? product.getRmiPort() : this.rmiPort);
        prod.setHttpPort(this.httpPort == 0 ? product.getHttpPort() : this.httpPort);
        prod.setAjpPort(this.ajpPort == 0 ? product.getAjpPort() : this.ajpPort);
        prod.setJvmDebugPort(this.jvmDebugPort == 0 ? product.getJvmDebugPort() : this.jvmDebugPort);
        prod.setUseHttps(this.useHttps == null ? product.getUseHttps() : this.useHttps);
        prod.setStartupTimeout(this.startupTimeout == 0 ? product.getStartupTimeout() : this.startupTimeout);
        prod.setShutdownTimeout(this.shutdownTimeout == 0 ? product.getShutdownTimeout() : this.shutdownTimeout);
        prod.setSynchronousStartup(this.synchronousStartup == null ? product.getSynchronousStartup() : this.synchronousStartup);
        prod.setSharedHome(this.sharedHome == null ? product.getSharedHome() : this.sharedHome);
        prod.setHttpsPort(this.httpsPort == 0 ? product.getHttpsPort() : this.httpsPort);
        prod.setHttpsClientAuth(this.httpsClientAuth == null ? product.getHttpsClientAuth() : this.httpsClientAuth);
        prod.setHttpsSSLProtocol(this.httpsSslProtocol == null ? product.getHttpsSSLProtocol() : this.httpsSslProtocol);
        prod.setHttpsKeystoreFile(this.httpsKeystoreFile == null ? product.getHttpsKeystoreFile() : this.httpsKeystoreFile);
        prod.setHttpsKeystorePass(this.httpsKeystorePass == null ? product.getHttpsKeystorePass() : this.httpsKeystorePass);
        prod.setHttpsKeyAlias(this.httpsKeyAlias == null ? product.getHttpsKeyAlias() : this.httpsKeyAlias);
        prod.setHttpsHttpSecure(this.httpsHttpSecure == null ? product.getHttpsHttpSecure() : this.httpsHttpSecure);
        return prod;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public Boolean getUseHttps() {
        return this.useHttps;
    }

    public void setUseHttps(Boolean useHttps) {
        this.useHttps = useHttps;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsClientAuth(String httpsClientAuth) {
        this.httpsClientAuth = httpsClientAuth;
    }

    public String getHttpsClientAuth() {
        return this.httpsClientAuth;
    }

    public void setHttpsSSLProtocol(String httpsSslProtocol) {
        this.httpsSslProtocol = httpsSslProtocol;
    }

    public String getHttpsSSLProtocol() {
        return this.httpsSslProtocol;
    }

    public void setHttpsKeystoreFile(String httpsKeystoreFile) {
        this.httpsKeystoreFile = httpsKeystoreFile;
    }

    public String getHttpsKeystoreFile() {
        return this.httpsKeystoreFile;
    }

    public void setHttpsKeystorePass(String httpsKeystorePass) {
        this.httpsKeystorePass = httpsKeystorePass;
    }

    public String getHttpsKeystorePass() {
        return this.httpsKeystorePass;
    }

    public void setHttpsKeyAlias(String httpsKeyAlias) {
        this.httpsKeyAlias = httpsKeyAlias;
    }

    public String getHttpsKeyAlias() {
        return this.httpsKeyAlias;
    }

    public void setHttpsHttpSecure(Boolean httpsHttpSecure) {
        this.httpsHttpSecure = httpsHttpSecure;
    }

    public Boolean getHttpsHttpSecure() {
        return this.httpsHttpSecure;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs == null ? "" : jvmArgs;
    }

    public String getDebugArgs() {
        return this.debugArgs;
    }

    public void setDebugArgs(String debugArgs) {
        this.debugArgs = debugArgs == null ? "" : debugArgs;
    }

    public ArtifactRetriever getArtifactRetriever() {
        return this.artifactRetriever;
    }

    public void setArtifactRetriever(ArtifactRetriever artifactRetriever) {
        this.artifactRetriever = artifactRetriever;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDataVersion() {
        return this.productDataVersion;
    }

    public void setDataVersion(String productDataVersion) {
        this.productDataVersion = productDataVersion;
    }

    public String getProductDataVersion() {
        return this.productDataVersion;
    }

    public void setProductDataVersion(String productDataVersion) {
        this.productDataVersion = productDataVersion;
    }

    public String getDataPath() {
        return this.productDataPath;
    }

    public void setDataPath(String productDataPath) {
        this.productDataPath = productDataPath;
    }

    public String getProductDataPath() {
        return this.productDataPath;
    }

    public void setProductDataPath(String productDataPath) {
        this.productDataPath = productDataPath;
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    public List<ProductArtifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List<ProductArtifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public List<ProductArtifact> getLibArtifacts() {
        return this.libArtifacts;
    }

    public void setLibArtifacts(List<ProductArtifact> libArtifacts) {
        this.libArtifacts = libArtifacts;
    }

    public List<ProductArtifact> getBundledArtifacts() {
        return this.bundledArtifacts;
    }

    public void setBundledArtifacts(List<ProductArtifact> bundledArtifacts) {
        this.bundledArtifacts = bundledArtifacts;
    }

    public File getLog4jProperties() {
        return this.log4jProperties;
    }

    public void setLog4jProperties(File log4jProperties) {
        this.log4jProperties = log4jProperties;
    }

    public String getRestVersion() {
        return this.restVersion;
    }

    public void setRestVersion(String restVersion) {
        this.restVersion = restVersion;
    }

    public String getSalVersion() {
        return this.salVersion;
    }

    public void setSalVersion(String salVersion) {
        this.salVersion = salVersion;
    }

    public String getPdkVersion() {
        return this.pdkVersion;
    }

    public void setPdkVersion(String pdkVersion) {
        this.pdkVersion = pdkVersion;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Boolean isInstallPlugin() {
        return this.installPlugin;
    }

    public void setInstallPlugin(Boolean installPlugin) {
        this.installPlugin = installPlugin;
    }

    public String getWebConsoleVersion() {
        return this.webConsoleVersion;
    }

    public Boolean isEnableFastdev() {
        return this.enableFastdev;
    }

    public void setEnableFastdev(Boolean enableFastdev) {
        this.enableFastdev = enableFastdev;
    }

    public String getFastdevVersion() {
        return this.fastdevVersion;
    }

    public void setFastdevVersion(String fastdevVersion) {
        this.fastdevVersion = fastdevVersion;
    }

    public Boolean isEnableDevToolbox() {
        return this.enableDevToolbox;
    }

    public void setEnableDevToolbox(Boolean enableDevToolbox) {
        this.enableDevToolbox = enableDevToolbox;
    }

    public String getQuickReloadVersion() {
        return this.quickReloadVersion;
    }

    public void setQuickReloadVersion(String quickReloadVersion) {
        this.quickReloadVersion = quickReloadVersion;
    }

    public Boolean isEnableQuickReload() {
        return this.enableQuickReload;
    }

    public void setEnableQuickReload(Boolean enableQuickReload) {
        this.enableQuickReload = enableQuickReload;
    }

    public String getDevToolboxVersion() {
        return this.devToolboxVersion;
    }

    public void setDevToolboxVersion(String devToolboxVersion) {
        this.devToolboxVersion = devToolboxVersion;
    }

    public Boolean isEnablePde() {
        return this.enablePde;
    }

    public void setEnablePde(Boolean enablePde) {
        this.enablePde = enablePde;
    }

    public String getPdeVersion() {
        return this.pdeVersion;
    }

    public void setPdeVersion(String pdeVersion) {
        this.pdeVersion = pdeVersion;
    }

    public void setWebConsoleVersion(String webConsoleVersion) {
        this.webConsoleVersion = webConsoleVersion;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties.putAll(systemProperties);
    }

    public Properties getSystemProperties() {
        Properties props = new Properties();
        props.putAll(this.systemProperties);
        return props;
    }

    public void setSystemPropertyVariables(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, Object> getSystemPropertyVariables() {
        return this.systemProperties;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public int getJvmDebugPort() {
        return this.jvmDebugPort;
    }

    public void setJvmDebugPort(int jvmDebugPort) {
        this.jvmDebugPort = jvmDebugPort;
    }

    public int getStartupTimeout() {
        return this.startupTimeout;
    }

    public void setStartupTimeout(int startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setSystemProperties(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Boolean getSynchronousStartup() {
        return this.synchronousStartup;
    }

    public void setSynchronousStartup(Boolean synchronousStartup) {
        this.synchronousStartup = synchronousStartup;
    }

    public String getDataHome() {
        return this.dataHome;
    }

    public void setDataHome(String dataHome) {
        this.dataHome = dataHome;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public String getSharedHome() {
        return this.sharedHome;
    }

    public void setSharedHome(String sharedHome) {
        this.sharedHome = sharedHome;
    }

    public int getAjpPort() {
        return this.ajpPort;
    }

    public void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    public String toString() {
        return "Product " + this.id + " [instanceId=" + this.instanceId + ", " + this.getProtocol() + "://" + this.server + ":" + this.httpPort + this.contextPath + "]";
    }

    public String getProtocol() {
        return this.useHttps != null && this.useHttps != false ? "https" : "http";
    }
}

