/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractWebappProductHandler
extends AbstractProductHandler {
    public AbstractWebappProductHandler(MavenContext context, MavenGoals goals, PluginProvider pluginProvider, ArtifactFactory artifactFactory) {
        super(context, goals, pluginProvider, artifactFactory);
    }

    @Override
    public final void stop(Product ctx) throws MojoExecutionException {
        this.goals.stopWebapp(ctx.getInstanceId(), ctx.getContainerId(), ctx);
    }

    @Override
    protected final File extractApplication(Product ctx, File homeDir) throws MojoExecutionException {
        ProductArtifact defaults = this.getArtifact();
        ProductArtifact artifact = new ProductArtifact(ProjectUtils.firstNotNull(ctx.getGroupId(), defaults.getGroupId()), ProjectUtils.firstNotNull(ctx.getArtifactId(), defaults.getArtifactId()), ProjectUtils.firstNotNull(ctx.getVersion(), defaults.getVersion()));
        if ("RELEASE".equals(artifact.getVersion()) || "LATEST".equals(artifact.getVersion())) {
            this.log.info((CharSequence)"determining latest stable product version...");
            Artifact warArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            String stableVersion = ctx.getArtifactRetriever().getLatestStableVersion(warArtifact);
            this.log.info((CharSequence)("using latest stable product version: " + stableVersion));
            artifact.setVersion(stableVersion);
            ctx.setVersion(stableVersion);
        }
        return this.goals.copyWebappWar(ctx.getId(), this.getBaseDirectory(ctx), artifact);
    }

    @Override
    protected final int startApplication(Product ctx, File app, File homeDir, Map<String, String> properties) throws MojoExecutionException {
        return this.goals.startWebapp(ctx.getInstanceId(), app, properties, this.getExtraContainerDependencies(), ctx);
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return true;
    }

    @Override
    protected String getLog4jPropertiesPath() {
        return "WEB-INF/classes/log4j.properties";
    }

    protected abstract List<ProductArtifact> getExtraContainerDependencies();

    @Override
    protected Map<String, String> getSystemProperties(Product ctx) {
        return this.generateDataSourceSystemProperties(ctx);
    }

    protected Map<String, String> generateDataSourceSystemProperties(Product context) {
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        List<DataSource> dataSources = context.getDataSources();
        DataSource defaultValues = this.getDefaultDataSource(context);
        if (defaultValues != null) {
            if (dataSources.isEmpty()) {
                dataSources.add(defaultValues);
            } else {
                dataSources.get(0).useForUnsetValues(defaultValues);
            }
        }
        if (dataSources.size() == 1) {
            systemProperties.put((Object)"cargo.datasource.datasource", (Object)dataSources.get(0).getCargoString());
        } else {
            for (int i = 0; i < dataSources.size(); ++i) {
                systemProperties.put((Object)("cargo.datasource.datasource." + i), (Object)dataSources.get(i).getCargoString());
            }
        }
        return systemProperties.build();
    }

    protected DataSource getDefaultDataSource(Product ctx) {
        return null;
    }
}

