/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="integration-test", requiresDependencyResolution=ResolutionScope.TEST)
public class IntegrationTestMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="functional.test.pattern")
    private String functionalTestPattern = "it/**";
    @Parameter(property="project.build.testOutputDirectory", required=true)
    private File testClassesDirectory;
    @Parameter(property="testGroups")
    private String configuredTestGroupsToRun;
    @Parameter(property="no.webapp", defaultValue="false")
    private boolean noWebapp = false;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip = false;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests = false;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs = false;
    @Parameter(property="jvm.debug.port", defaultValue="0")
    protected int jvmDebugPort;
    @Parameter(property="jvm.debug.suspend")
    protected boolean jvmDebugSuspend = false;
    @Parameter
    protected String category;
    @Parameter(property="skip.IT.verification")
    protected boolean skipITVerification = false;

    @Override
    protected void doExecute() throws MojoExecutionException {
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip || this.skipITs) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        Set<String> configuredTestGroupIds = this.getTestGroupIds();
        if (configuredTestGroupIds.isEmpty()) {
            this.runTestsForTestGroup("__no_test_group__", goals, pluginJar, this.copy(this.systemPropertyVariables));
        } else if (this.configuredTestGroupsToRun != null) {
            String[] testGroupIdsToRun;
            for (String testGroupId : testGroupIdsToRun = this.configuredTestGroupsToRun.split(",")) {
                if (!configuredTestGroupIds.contains(testGroupId)) {
                    this.getLog().warn((CharSequence)("Test group " + testGroupId + " does not exist"));
                    continue;
                }
                this.runTestsForTestGroup(testGroupId, goals, pluginJar, this.copy(this.systemPropertyVariables));
            }
        } else {
            for (String testGroupId : configuredTestGroupIds) {
                this.runTestsForTestGroup(testGroupId, goals, pluginJar, this.copy(this.systemPropertyVariables));
            }
        }
    }

    private Map<String, Object> copy(Map<String, Object> systemPropertyVariables) {
        return new HashMap<String, Object>(systemPropertyVariables);
    }

    protected Map<String, String> getProductFunctionalTestProperties(Product product) {
        return Collections.emptyMap();
    }

    private Set<String> getTestGroupIds() throws MojoExecutionException {
        HashSet<String> ids = new HashSet<String>();
        for (TestGroup group : this.getTestGroups()) {
            ids.add(group.getId());
        }
        return ids;
    }

    private void runTestsForTestGroup(String testGroupId, MavenGoals goals, String pluginJar, Map<String, Object> systemProperties) throws MojoExecutionException {
        List<String> includes = this.getIncludesForTestGroup(testGroupId);
        List<String> excludes = this.getExcludesForTestGroup(testGroupId);
        List<ProductExecution> executionsDeclaredInPom = this.getTestGroupProductExecutions(testGroupId);
        List<ProductExecution> productExecutions = this.includeStudioDependentProducts(executionsDeclaredInPom, goals);
        this.setParallelMode(productExecutions);
        int counter = 0;
        for (ProductExecution productExecution : productExecutions) {
            ProductHandler productHandler = productExecution.getProductHandler();
            Product product = productExecution.getProduct();
            if (product.isInstallPlugin() == null) {
                product.setInstallPlugin(this.installPlugin);
            }
            if (this.shouldBuildTestPlugin()) {
                List<ProductArtifact> plugins = product.getBundledArtifacts();
                plugins.addAll(this.getTestFrameworkPlugins());
            }
            int actualHttpPort = 0;
            if (!this.noWebapp) {
                if (this.jvmDebugPort > 0) {
                    if (product.getJvmDebugPort() == 0) {
                        product.setJvmDebugPort(this.jvmDebugPort + counter++);
                    }
                    int debugPort = product.getJvmDebugPort();
                    String debugArgs = " -Xdebug -Xrunjdwp:transport=dt_socket,address=" + String.valueOf(debugPort) + ",suspend=" + (this.jvmDebugSuspend ? "y" : "n") + ",server=y ";
                    if (StringUtils.stripToNull((String)product.getJvmArgs()) == null) {
                        product.setJvmArgs(StringUtils.defaultString((String)this.jvmArgs));
                    }
                    product.setDebugArgs(debugArgs);
                }
                actualHttpPort = productHandler.start(product);
            }
            if (productExecutions.size() == 1) {
                this.putIfNotOverridden(systemProperties, "http.port", String.valueOf(actualHttpPort));
                this.putIfNotOverridden(systemProperties, "context.path", product.getContextPath());
            }
            String baseUrl = MavenGoals.getBaseUrl(product, actualHttpPort);
            this.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".port", String.valueOf(actualHttpPort));
            this.putIfNotOverridden(systemProperties, "context." + product.getInstanceId() + ".path", product.getContextPath());
            this.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".url", MavenGoals.getBaseUrl(product, actualHttpPort));
            this.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".protocol", product.getProtocol());
            this.putIfNotOverridden(systemProperties, "baseurl." + product.getInstanceId(), baseUrl);
            this.putIfNotOverridden(systemProperties, "plugin.jar", pluginJar);
            this.putIfNotOverridden(systemProperties, "baseurl", baseUrl);
            this.putIfNotOverridden(systemProperties, "homedir." + product.getInstanceId(), productHandler.getHomeDirectory(product).getAbsolutePath());
            this.putIfNotOverridden(systemProperties, "homedir", productHandler.getHomeDirectory(product).getAbsolutePath());
            this.putIfNotOverridden(systemProperties, "product." + product.getInstanceId() + ".id", product.getId());
            this.putIfNotOverridden(systemProperties, "product." + product.getVersion() + ".version", product.getVersion());
            systemProperties.putAll(this.getProductFunctionalTestProperties(product));
        }
        this.putIfNotOverridden(systemProperties, "testGroup", testGroupId);
        systemProperties.putAll(this.getTestGroupSystemProperties(testGroupId));
        if (!this.noWebapp) {
            this.waitForProducts(productExecutions, true);
        }
        goals.runIntegrationTests("group-" + testGroupId, this.getClassifier(testGroupId), includes, excludes, systemProperties, this.targetDirectory, this.category, this.skipITVerification);
        if (!this.noWebapp) {
            this.stopProducts(productExecutions);
        }
    }

    private void putIfNotOverridden(Map<String, Object> map, String key, Object value) {
        if (!map.containsKey(key)) {
            if (System.getProperties().containsKey(key)) {
                map.put(key, System.getProperty(key));
            } else {
                map.put(key, value);
            }
        }
    }

    private String getClassifier(String testGroupId) {
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            if (group.getClassifier() != null) {
                return group.getClassifier();
            }
            return "tomcat6x";
        }
        return "tomcat6x";
    }

    private Map<String, String> getTestGroupSystemProperties(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyMap();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getSystemProperties();
        }
        return Collections.emptyMap();
    }

    private List<String> getIncludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.singletonList(this.functionalTestPattern);
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            List<String> groupIncludes = group.getIncludes();
            if (groupIncludes.isEmpty()) {
                return Collections.singletonList(this.functionalTestPattern);
            }
            return groupIncludes;
        }
        return Collections.singletonList(this.functionalTestPattern);
    }

    private List<String> getExcludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyList();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getExcludes();
        }
        return Collections.emptyList();
    }
}

