/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.RunMojo;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class DebugMojo
extends RunMojo {
    @Parameter(property="jvm.debug.port", defaultValue="5005")
    protected int jvmDebugPort;
    @Parameter(property="jvm.debug.suspend")
    protected boolean jvmDebugSuspend = false;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.shouldExecute()) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.getUpdateChecker().check();
        this.getAmpsPluginVersionChecker().checkAmpsVersionInPom(this.getAmpsPluginVersion(), this.getMavenContext().getProject());
        this.promptForEmailSubscriptionIfNeeded();
        this.trackFirstRunIfNeeded();
        this.getGoogleTracker().track("Debug");
        List<ProductExecution> productExecutions = this.getProductExecutions();
        this.setParallelMode(productExecutions);
        int counter = 0;
        for (ProductExecution productExecution : productExecutions) {
            Product product = productExecution.getProduct();
            if (product.getJvmDebugPort() == 0) {
                product.setJvmDebugPort(this.jvmDebugPort + counter++);
            }
            int port = product.getJvmDebugPort();
            String debugArgs = " -Xdebug -Xrunjdwp:transport=dt_socket,address=" + String.valueOf(port) + ",suspend=" + (this.jvmDebugSuspend ? "y" : "n") + ",server=y ";
            if (StringUtils.stripToNull((String)product.getJvmArgs()) == null) {
                product.setJvmArgs(StringUtils.defaultString((String)this.jvmArgs));
            }
            product.setDebugArgs(debugArgs);
            if (!this.writePropertiesToFile) continue;
            if (productExecutions.size() == 1) {
                this.properties.put("debug.port", String.valueOf(port));
            }
            this.properties.put("debug." + product.getInstanceId() + ".port", String.valueOf(port));
        }
        this.startProducts(productExecutions);
    }
}

