/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.updater;

import com.atlassian.maven.plugins.updater.SdkPackageType;
import com.atlassian.maven.plugins.updater.SdkResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class MarketplaceSdkResource
implements SdkResource {
    private static final String SDK_DOWNLOAD_URL_ROOT = "https://marketplace.atlassian.com/rest/1.0/plugins/atlassian-plugin-sdk-";
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int READ_TIMEOUT = 15000;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public File downloadLatestSdk(SdkPackageType packageType) {
        return this.downloadSdk(packageType, this.getLatestSdkVersion(packageType));
    }

    @Override
    public File downloadSdk(SdkPackageType packageType, String version) {
        File sdkDownloadTempFile;
        Map<?, ?> rootAsMap = this.getPluginJsonAsMap(packageType);
        String versionDownloadPath = null;
        Map versionsElement = (Map)rootAsMap.get("versions");
        ArrayList versions = (ArrayList)versionsElement.get("versions");
        block7: for (Map versionData : versions) {
            if (!versionData.get("version").equals(version)) continue;
            ArrayList links = (ArrayList)versionData.get("links");
            for (Map link : links) {
                if (!link.get("rel").equals("binary")) continue;
                versionDownloadPath = (String)link.get("href");
                continue block7;
            }
        }
        if (versionDownloadPath == null) {
            throw new RuntimeException("Couldn't find SDK version for " + packageType.key() + " on marketplace with version " + version);
        }
        HttpURLConnection conn = null;
        try {
            URL url;
            String tempFileSuffix = packageType == SdkPackageType.WINDOWS ? ".exe" : (packageType == SdkPackageType.MAC ? ".pkg" : (packageType == SdkPackageType.RPM ? ".rpm" : (packageType == SdkPackageType.DEB ? ".deb" : ".tar.gz")));
            sdkDownloadTempFile = File.createTempFile("atlassian-plugin-sdk-" + version, tempFileSuffix);
            try {
                url = new URL(versionDownloadPath);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            conn = (HttpURLConnection)url.openConnection();
            this.copyResponseStreamToFile(conn.getInputStream(), sdkDownloadTempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return sdkDownloadTempFile;
    }

    @Override
    public String getLatestSdkVersion(SdkPackageType packageType) {
        Map<?, ?> rootAsMap = this.getPluginJsonAsMap(packageType);
        Map version = (Map)rootAsMap.get("version");
        return (String)version.get("version");
    }

    private void copyResponseStreamToFile(InputStream stream, File file) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private Map<?, ?> getPluginJsonAsMap(SdkPackageType packageType) {
        String json;
        URL url;
        try {
            url = new URL(SDK_DOWNLOAD_URL_ROOT + packageType.key());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        HttpURLConnection conn = null;
        BufferedInputStream jsonStream = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            jsonStream = new BufferedInputStream(conn.getInputStream());
            json = IOUtils.toString((InputStream)jsonStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jsonStream);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)jsonStream);
        if (conn != null) {
            conn.disconnect();
        }
        try {
            Map rootAsMap = (Map)this.mapper.readValue(json, Map.class);
            return rootAsMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

