/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AmpsProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.product.studio.StudioProperties;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class StudioProductHandler
extends AmpsProductHandler {
    private static final String STUDIO_PROPERTIES = "home/studio.properties";
    private static final String STUDIO_TEST_PROPERTIES = "studiotest.properties";
    private static final String STUDIO_INITIAL_DATA_PROPERTIES = "home/studio-initial-data.properties";
    private static final String DEVMODE_HAL_LICENSES_XML = "home/devmode-hal-licenses.xml";
    private static final String STUDIO_INITIAL_DATA_XML = "home/studio-initial-data.xml";
    private static final String ONDEMAND_VERSION_TOKEN = "STUDIO-VERSION";
    private static final String ONDEMAND_GROUP_ID = "com.atlassian.studio";
    private static final String JIRA_VERSION_KEY = "jira.version";
    private static final String CONFLUENCE_VERSION_KEY = "confluence.version";
    private static final Map<String, String> defaultContextPaths = new HashMap<String, String>(){
        {
            this.put("studio-bamboo", "/builds");
            this.put("studio-confluence", "/wiki");
            this.put("studio-crowd", "/crowd");
            this.put("studio-fecru", "/");
            this.put("studio-jira", "/jira");
        }
    };
    private static final Map<String, Integer> defaultDebugPorts = new HashMap<String, Integer>(){
        {
            this.put("studio-bamboo", 5011);
            this.put("studio-confluence", 5007);
            this.put("studio-crowd", 5003);
            this.put("studio-fecru", 5005);
            this.put("studio-jira", 5009);
        }
    };

    public StudioProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, artifactFactory);
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact(ONDEMAND_GROUP_ID, "studio-test-resources");
    }

    @Override
    public String getId() {
        return "studio";
    }

    public static List<String> getDependantInstances(Product studioContext) throws MojoExecutionException {
        if (!"studio".equals(studioContext.getId())) {
            return Collections.emptyList();
        }
        StudioProperties studioProperties = StudioProductHandler.getStudioProperties(studioContext);
        studioProperties.setStudioProduct(studioContext);
        List<String> instanceIds = studioContext.getInstanceIds();
        if (instanceIds.isEmpty()) {
            instanceIds.add("studio-crowd");
            instanceIds.add("studio-jira");
            instanceIds.add("studio-confluence");
            instanceIds.add("studio-bamboo");
            instanceIds.add("studio-fecru");
        }
        return instanceIds;
    }

    @Override
    public int start(Product ctx) throws MojoExecutionException {
        this.sanityCheck(ctx);
        this.createStudioHome(ctx);
        File symlink = new File(this.context.getProject().getBuild().getDirectory(), "svn");
        if (!symlink.exists()) {
            this.createSymlink(ctx.getStudioProperties().getSvnRoot(), symlink);
        }
        return 0;
    }

    private void sanityCheck(Product studioProduct) throws MojoExecutionException {
        StudioProperties properties = studioProduct.getStudioProperties();
        if (properties == null) {
            throw new MojoExecutionException(String.format("Something went wrong when starting %s. The 'studio' handler was not initialised propertly.", studioProduct.getInstanceId()));
        }
        if (properties.getCrowd() == null || properties.getCrowd().getStudioProperties() == null) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Crowd was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isJiraEnabled() && (properties.getJira() == null || properties.getJira().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-JIRA was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isConfluenceEnabled() && (properties.getConfluence() == null || properties.getConfluence().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Confluence was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isFisheyeEnabled() && (properties.getFisheye() == null || properties.getFisheye().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Fisheye was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isBambooEnabled() && (properties.getBamboo() == null || properties.getBamboo().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Bamboo was not configured properly.", studioProduct.getInstanceId()));
        }
    }

    @Override
    public void stop(Product ctx) throws MojoExecutionException {
        File symlink = new File(this.context.getProject().getBuild().getDirectory(), "svn");
        symlink.deleteOnExit();
    }

    @Override
    public int getDefaultHttpPort() {
        return 0;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 0;
    }

    public static boolean setDefaultValues(MavenContext context, Product product) {
        String defaultContextPath = defaultContextPaths.get(product.getId());
        if (defaultContextPath != null) {
            if (product.getOutput() == null) {
                product.setOutput(new File(context.getProject().getBuild().getDirectory(), product.getInstanceId() + ".log").getAbsolutePath());
            }
            if (product.getContextPath() == null) {
                product.setContextPath(defaultContextPath);
            }
            if (product.getVersion() == null) {
                product.setVersion(ONDEMAND_VERSION_TOKEN);
            }
            if (product.getJvmDebugPort() == 0) {
                product.setJvmDebugPort(defaultDebugPorts.get(product.getId()));
            }
            if (product.getShutdownEnabled() == null) {
                product.setShutdownEnabled(Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    public void configureStudioProducts(Map<String, Product> productMap) throws MojoExecutionException {
        for (Product studioContext : productMap.values()) {
            String svnPublicUrl;
            if (!"studio".equals(studioContext.getId())) continue;
            StudioProperties studioProperties = StudioProductHandler.getStudioProperties(studioContext);
            boolean confluenceStandalone = true;
            OnDemandProductVersions versions = new OnDemandProductVersions(studioContext, studioProperties);
            for (String instanceId : StudioProductHandler.getDependantInstances(studioContext)) {
                Product product = productMap.get(instanceId);
                if ("studio-crowd".equals(product.getId())) {
                    studioProperties.setCrowd(product);
                    if (product.getSynchronousStartup() == null) {
                        product.setSynchronousStartup(Boolean.TRUE);
                    }
                } else if ("studio-confluence".equals(product.getId())) {
                    studioProperties.setConfluence(product);
                    if (product.getSynchronousStartup() == null) {
                        product.setSynchronousStartup(studioContext.getSynchronousStartup());
                    }
                } else if ("studio-jira".equals(product.getId())) {
                    studioProperties.setJira(product);
                    confluenceStandalone = false;
                    if (product.getSynchronousStartup() == null) {
                        product.setSynchronousStartup(studioContext.getSynchronousStartup());
                    }
                } else if ("studio-fecru".equals(product.getId())) {
                    studioProperties.setFisheye(product);
                    confluenceStandalone = false;
                } else if ("studio-bamboo".equals(product.getId())) {
                    studioProperties.setBamboo(product);
                    confluenceStandalone = false;
                    if (product.getSynchronousStartup() == null) {
                        product.setSynchronousStartup(studioContext.getSynchronousStartup());
                    }
                } else {
                    throw new MojoExecutionException("A non-studio product was listed in a Studio instance: " + product.getInstanceId());
                }
                studioProperties.setModeConfluenceStandalone(confluenceStandalone);
                product.setStudioProperties(studioProperties);
                if (!ONDEMAND_VERSION_TOKEN.equals(product.getVersion())) continue;
                product.setVersion(versions.getVersion(product));
            }
            File studioHomeDir = this.getHomeDirectory(studioContext);
            File studioCommonsDir = studioHomeDir.getParentFile();
            File svnHomeDir = new File(studioCommonsDir, "svn-home");
            File webDavDir = new File(studioCommonsDir, "webdav-home");
            if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
                svnPublicUrl = "file:///" + svnHomeDir.getAbsolutePath();
                this.log.warn((CharSequence)"Studio is only designed to run on Linux systems.");
            } else {
                svnPublicUrl = "file://" + svnHomeDir.getAbsolutePath();
            }
            studioProperties.setStudioHome(studioHomeDir.getAbsolutePath());
            studioProperties.setSvnRoot(svnHomeDir.getAbsolutePath());
            studioProperties.setSvnPublicUrl(svnPublicUrl);
            studioProperties.setWebDavHome(webDavDir.getAbsolutePath());
        }
    }

    private static StudioProperties getStudioProperties(Product studioContext) {
        StudioProperties properties = studioContext.getStudioProperties();
        if (properties == null) {
            properties = new StudioProperties(studioContext);
            studioContext.setStudioProperties(properties);
        }
        return properties;
    }

    @Override
    public File getSnapshotDirectory(Product studio) {
        return this.getHomeDirectory(studio).getParentFile();
    }

    public void createStudioHome(Product studio) throws MojoExecutionException {
        Product fecru;
        Product bamboo;
        Product jira;
        Product confluence;
        File svnHomeDir;
        StudioProperties properties = StudioProductHandler.getStudioProperties(studio);
        File studioHomeDir = new File(properties.getStudioHome());
        File studioCommonsDir = studioHomeDir.getParentFile();
        if (!studioHomeDir.exists()) {
            this.extractHome(studioCommonsDir, studio);
            if (!studioHomeDir.exists()) {
                throw new MojoExecutionException("The Studio home zip must contain a '*/*/home' folder");
            }
        }
        if (!(svnHomeDir = new File(properties.getSvnRoot())).exists()) {
            throw new MojoExecutionException("The Studio home zip must contain a '*/*/svn-home' folder");
        }
        File webDavDir = new File(properties.getWebDavHome());
        if (!webDavDir.exists()) {
            throw new MojoExecutionException("The Studio home zip must contain a '*/*/webdav-home' folder");
        }
        this.parameteriseFiles(studioCommonsDir, studio);
        properties.overrideSystemProperty("studio.home", studioHomeDir.getAbsolutePath());
        properties.overrideSystemProperty("studio.initial.data.xml", new File(studioCommonsDir, STUDIO_INITIAL_DATA_XML).getAbsolutePath());
        properties.overrideSystemProperty("studio.initial.data.properties", new File(studioCommonsDir, STUDIO_INITIAL_DATA_PROPERTIES).getAbsolutePath());
        properties.overrideSystemProperty("studio.hal.instance.uri", new File(studioCommonsDir, DEVMODE_HAL_LICENSES_XML).getAbsolutePath());
        Product crowd = properties.getCrowd();
        if (crowd.getDataPath() == null) {
            crowd.setDataPath(new File(studioCommonsDir, "crowd-home").getAbsolutePath());
        }
        if ((confluence = properties.getConfluence()) != null && confluence.getDataPath() == null) {
            confluence.setDataPath(new File(studioCommonsDir, "confluence-home").getAbsolutePath());
        }
        if ((jira = properties.getJira()) != null && jira.getDataPath() == null) {
            jira.setDataPath(new File(studioCommonsDir, "jira-home").getAbsolutePath());
        }
        if ((bamboo = properties.getBamboo()) != null && bamboo.getDataPath() == null) {
            bamboo.setDataPath(new File(studioCommonsDir, "bamboo-home").getAbsolutePath());
        }
        if ((fecru = properties.getFisheye()) != null && fecru.getDataPath() == null) {
            fecru.setDataPath(new File(studioCommonsDir, "fecru-home").getAbsolutePath());
        }
        this.overrideAndPatchHomeDir(studioCommonsDir, studio);
    }

    private void parameteriseFiles(File studioSnapshotCopyDir, Product studio) throws MojoExecutionException {
        ConfigFileUtils.replace(this.getConfigFiles(studio, studioSnapshotCopyDir), this.getReplacements(studio), false, this.log);
    }

    @Override
    public List<File> getConfigFiles(Product studio, File studioSnapshotDir) {
        ArrayList list = Lists.newArrayList();
        list.add(new File(studioSnapshotDir, STUDIO_PROPERTIES));
        list.add(new File(studioSnapshotDir, STUDIO_INITIAL_DATA_PROPERTIES));
        list.add(new File(studioSnapshotDir, STUDIO_INITIAL_DATA_XML));
        list.add(new File(studioSnapshotDir, DEVMODE_HAL_LICENSES_XML));
        list.add(new File(this.project.getBuild().getTestOutputDirectory(), STUDIO_TEST_PROPERTIES));
        list.add(new File(studioSnapshotDir, "fecru-home/config.xml"));
        list.add(new File(studioSnapshotDir, "confluence-home/database/confluencedb.log"));
        list.add(new File(studioSnapshotDir, "confluence-home/database/confluencedb.script"));
        list.add(new File(studioSnapshotDir, "jira-home/database.log"));
        list.add(new File(studioSnapshotDir, "jira-home/database.script"));
        list.add(new File(studioSnapshotDir, "bamboo-home/database.log"));
        list.add(new File(studioSnapshotDir, "bamboo-home/database.script"));
        return list;
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(final Product studio) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(studio);
        replacements.addAll((Collection<ConfigFileUtils.Replacement>)new ArrayList<ConfigFileUtils.Replacement>(){
            {
                StudioProperties properties = studio.getStudioProperties();
                this.putIfNotNull("%GREENHOPPER-LICENSE%", "test-classes/greenhopper.license");
                if (properties.isJiraEnabled()) {
                    File attachmentsFolder = new File(StudioProductHandler.this.getHomeDirectory(properties.getJira()), "attachments");
                    this.putIfNotNull("%JIRA-ATTACHMENTS%", attachmentsFolder.getAbsolutePath());
                    this.putIfNotNull("%JIRA-BASE-URL%", properties.getJiraUrl());
                    this.putIfNotNull("%JIRA-HOST-URL%", properties.getJiraHostUrl());
                    this.putIfNotNull("%JIRA-CONTEXT%", properties.getJiraContextPath(), false);
                }
                if (properties.isConfluenceEnabled()) {
                    this.putIfNotNull("%CONFLUENCE-BASE-URL%", properties.getConfluenceUrl());
                    this.putIfNotNull("%CONFLUENCE-HOST-URL%", properties.getConfluenceHostUrl());
                    this.putIfNotNull("%CONFLUENCE-CONTEXT%", properties.getConfluenceContextPath(), false);
                }
                if (properties.isFisheyeEnabled()) {
                    this.putIfNotNull("%FISHEYE-BASE-URL%", properties.getFisheyeUrl());
                    this.putIfNotNull("%FISHEYE-HOST-URL%", properties.getFisheyeHostUrl());
                    this.putIfNotNull("%FISHEYE-CONTROL-PORT%", properties.getFisheyeControlPort());
                    this.putIfNotNull("%FISHEYE-CONTEXT%", properties.getFisheyeContextPath(), false);
                    this.putIfNotNull("%FISHEYE-SHUTDOWN-ENABLED%", String.valueOf(StudioProductHandler.firstNotNull(properties.getFisheyeShutdownEnabled(), Boolean.TRUE)));
                }
                if (properties.isBambooEnabled()) {
                    this.putIfNotNull("%BAMBOO-BASE-URL%", properties.getBambooUrl());
                    this.putIfNotNull("%BAMBOO-HOST-URL%", properties.getBambooHostUrl());
                    this.putIfNotNull("%BAMBOO-CONTEXT%", properties.getBambooContextPath(), false);
                    this.putIfNotNull("%BAMBOO-ENABLED%", "true", false);
                } else {
                    this.putIfNotNull("%BAMBOO-ENABLED%", "false", false);
                }
                this.putIfNotNull("%CROWD-BASE-URL%", properties.getCrowdUrl());
                this.putIfNotNull("%CROWD-HOST-URL%", properties.getCrowdHostUrl());
                this.putIfNotNull("%CROWD-CONTEXT%", properties.getCrowdContextPath(), false);
                this.putIfNotNull("%SVN-BASE-URL%", properties.getSvnRoot());
                this.putIfNotNull("%SVN-PUBLIC-URL%", properties.getSvnPublicUrl());
                this.putIfNotNull("%SVN-HOOKS%", properties.getSvnHooks());
                this.putIfNotNull("%STUDIO-DATA-LOCATION%", "", false);
                this.putIfNotNull("%STUDIO-HOME%", properties.getStudioHome());
                this.putIfNotNull("%GAPPS-ENABLED%", Boolean.toString(properties.isGappsEnabled()), false);
                if (properties.isGappsEnabled()) {
                    this.putIfNotNull("%GAPPS-ENABLED%", Boolean.toString(true), false);
                    this.putIfNotNull("%STUDIO-GAPPS-DOMAIN%", properties.getGappsDomain());
                } else {
                    this.putIfNotNull("%GAPPS-ENABLED%", Boolean.toString(false), false);
                }
                this.putIfNotNull("%STUDIO-WEBDAV-DIRECTORY%", properties.getWebDavHome());
                this.putIfNotNull("%STUDIO-SVN-IMPORT-STAGING-DIRECTORY%", properties.getSvnImportStagingDirectory());
                try {
                    this.putIfNotNull("%SVN_HOME_URL_ENCODED%", URLEncoder.encode(StudioProductHandler.this.propertiesEncode(properties.getSvnRoot()), "UTF-8"));
                }
                catch (UnsupportedEncodingException badJvm) {
                    throw new RuntimeException("UTF-8 should be supported on any JVM", badJvm);
                }
            }

            private void putIfNotNull(String key, String value) {
                this.putIfNotNull(key, value, true);
            }

            private void putIfNotNull(String key, String value, boolean reversible) {
                if (reversible && StringUtils.isNotBlank((String)value)) {
                    this.add(new ConfigFileUtils.Replacement(key, value));
                } else if (value != null) {
                    this.add(new ConfigFileUtils.Replacement(key, value, false));
                }
            }
        });
        return replacements;
    }

    private void createSymlink(String source, File target) throws MojoExecutionException {
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
            this.log.error((CharSequence)"Studio is designed to run on Linux systems. As you can't create a symbolic link for SVN, you will have problems using SVN, FishEye and Bamboo, and possibly the other products.");
            return;
        }
        String[] systemCommand = new String[]{"ln", "-s", source, target.getAbsolutePath()};
        try {
            Process symlinkCreation = Runtime.getRuntime().exec(systemCommand);
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(symlinkCreation.getErrorStream()));
            String errorLine = null;
            boolean hasErrors = false;
            while ((errorLine = errorStream.readLine()) != null) {
                if (!hasErrors) {
                    System.err.println("Error while executing " + systemCommand + ": ");
                    hasErrors = true;
                }
                System.err.println(errorLine);
            }
            if (hasErrors) {
                System.out.println("Please execute this command in your command line and press a key to continue");
                System.in.read();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create the symlink: " + systemCommand, (Exception)e);
        }
    }

    private void extractHome(File target, Product studio) throws MojoExecutionException {
        File testResourcesZip = this.getProductHomeData(studio);
        try {
            if (!testResourcesZip.exists()) {
                throw new MojoExecutionException(String.format("This source doesn't exist: %s", testResourcesZip.getAbsoluteFile()));
            }
            if (testResourcesZip.isDirectory()) {
                FileUtils.copyDirectory((File)testResourcesZip, (File)target);
            } else {
                ZipUtils.unzip(testResourcesZip, target.getAbsolutePath(), 2);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(String.format("Unable to copy/unzip the studio home from %s to %s", testResourcesZip.getAbsolutePath(), target.getAbsolutePath()), (Exception)ioe);
        }
    }

    static void processProductsHomeDirectory(Log log, Product ctx, File homeDir) throws MojoExecutionException {
        if (ctx.getStudioProperties() == null) {
            throw new MojoExecutionException(String.format("%s product is dependant on Studio. You must include the Studio product in your execution.", ctx.getInstanceId()));
        }
    }

    static void addProductHandlerOverrides(Log log, Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        StudioProductHandler.addProductHandlerOverrides(log, ctx, homeDir, explodedWarDir, "WEB-INF/classes/crowd.properties");
    }

    static void addProductHandlerOverrides(Log log, Product ctx, File homeDir, File explodedWarDir, String crowdPropertiesPath) throws MojoExecutionException {
        File crowdProperties = new File(explodedWarDir, crowdPropertiesPath);
        if (StudioProductHandler.checkFileExists(crowdProperties, log)) {
            StudioProductHandler.parametriseCrowdFile(crowdProperties, ctx.getStudioProperties().getCrowdUrl(), log);
        }
    }

    private static void parametriseCrowdFile(File crowdProperties, String crowdUrl, Log log) throws MojoExecutionException {
        ArrayList replacements = Lists.newArrayList();
        replacements.add(new ConfigFileUtils.Replacement("%CROWD-INTERNAL-URL%", crowdUrl));
        replacements.add(new ConfigFileUtils.Replacement("%CROWD-URL%", crowdUrl));
        ConfigFileUtils.replace(crowdProperties, (List<ConfigFileUtils.Replacement>)replacements, false, log);
    }

    @Override
    public void cleanupProductHomeForZip(Product studioProduct, File studioHome) throws MojoExecutionException {
        try {
            File productDestinationDirectory;
            Product product;
            StudioProperties studioProperties = studioProduct.getStudioProperties();
            HashMap products = Maps.newHashMap();
            products.put("crowd-home", studioProperties.getCrowd());
            products.put("confluence-home", studioProperties.getConfluence());
            products.put("jira-home", studioProperties.getJira());
            products.put("fecru-home", studioProperties.getFisheye());
            products.put("bamboo-home", studioProperties.getBamboo());
            for (String productHomeName : products.keySet()) {
                product = (Product)products.get(productHomeName);
                if (product == null) continue;
                productDestinationDirectory = new File(studioHome, productHomeName);
                File productHomeDirectory = this.getHomeDirectory(product);
                if (productDestinationDirectory.exists()) {
                    FileUtils.deleteDirectory((File)productDestinationDirectory);
                }
                ProjectUtils.createDirectory(productDestinationDirectory);
                FileUtils.copyDirectory((File)productHomeDirectory, (File)productDestinationDirectory);
            }
            super.cleanupProductHomeForZip(studioProduct, studioHome);
            for (String productHomeName : products.keySet()) {
                product = (Product)products.get(productHomeName);
                if (product == null) continue;
                productDestinationDirectory = new File(studioHome, productHomeName);
                ProductHandler handler = ProductHandlerFactory.create(product.getId(), this.context, this.goals, this.artifactFactory);
                handler.cleanupProductHomeForZip(product, productDestinationDirectory);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not copy a product home directory.", (Exception)ioe);
        }
    }

    static boolean checkFileExists(File file, Log log) {
        if (!file.exists()) {
            log.warn((CharSequence)String.format("%s does not exist. Will skip customisation", file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static <T> T firstNotNull(T ... values) {
        for (T t : values) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @VisibleForTesting
    protected Model getOnDemandPomModel(Product ondemand, StudioProperties properties) throws MojoExecutionException {
        File pomFile = this.getOnDemandPom(ondemand, properties);
        return this.readModel(pomFile);
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        BufferedReader filePomReader = null;
        try {
            filePomReader = new BufferedReader(new FileReader(pomFile));
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            model = pomReader.read((Reader)filePomReader);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Failed to read ondemand-fireball pom", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(filePomReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)filePomReader);
        return model;
    }

    private File getOnDemandPom(Product ondemand, StudioProperties properties) throws MojoExecutionException {
        File baseDir = this.getBaseDirectory(ondemand);
        File ondemandPom = new File(baseDir, "ondemand.pom");
        if (!ondemandPom.exists()) {
            ondemandPom = this.goals.copyArtifact("ondemand.pom", baseDir, this.getPomArtifact(properties), "pom");
        }
        return ondemandPom;
    }

    private ProductArtifact getPomArtifact(StudioProperties properties) {
        String version = properties.getVersion();
        if (this.isPostOnDemandSplit(version)) {
            return new ProductArtifact(ONDEMAND_GROUP_ID, "ondemand-fireball", version);
        }
        return new ProductArtifact(ONDEMAND_GROUP_ID, "studio-parent", version);
    }

    private boolean isPostOnDemandSplit(String version) {
        return this.getVersionNumber(version) >= 133 && !version.equals("133-partial-1");
    }

    private int getVersionNumber(String version) {
        int digitsCount = this.getDigitsCount(version);
        if (digitsCount == 0) {
            return 0;
        }
        return Integer.parseInt(version.substring(0, digitsCount));
    }

    private int getDigitsCount(String version) {
        for (int i = 0; i < version.length(); ++i) {
            if (Character.isDigit(version.charAt(i))) continue;
            return i;
        }
        return version.length();
    }

    private class OnDemandProductVersions {
        private final Map<String, String> productVersionMappings;
        private final StudioProperties properties;

        OnDemandProductVersions(Product ondemand, StudioProperties properties) throws MojoExecutionException {
            this.properties = properties;
            this.productVersionMappings = this.initMappings(ondemand);
        }

        String getVersion(Product product) {
            if (this.productVersionMappings.containsKey(product.getId())) {
                return this.productVersionMappings.get(product.getId());
            }
            return this.properties.getVersion();
        }

        private Map<String, String> initMappings(Product ondemand) throws MojoExecutionException {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            return builder.build();
        }

        private void validate(Model model) throws MojoExecutionException {
            Properties props = model.getProperties();
            this.validatePropertyExists(StudioProductHandler.JIRA_VERSION_KEY, props);
            this.validatePropertyExists(StudioProductHandler.CONFLUENCE_VERSION_KEY, props);
        }

        private String getVersionProperty(String key, Properties props) {
            if (props.containsKey(key)) {
                return props.getProperty(key);
            }
            return this.properties.getVersion();
        }

        private void validatePropertyExists(String key, Properties props) {
            if (!props.containsKey(key)) {
                StudioProductHandler.this.context.getLog().warn((CharSequence)("Expected property '" + key + "' in the OnDemand fireball POM (version " + this.properties.getVersion() + ") not found. OnDemand version will be used instead"));
            }
        }
    }
}

