/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

public enum JiraDatabaseType {
    HSQL("hsql", true, "jdbc:hsqldb", "org.hsqldb.jdbcDriver"),
    MYSQL("mysql", false, "jdbc:mysql", "com.mysql.jdbc.Driver"),
    POSTGRESQL("postgres72", true, "jdbc:postgresql", "org.postgresql.Driver"),
    ORACLE("oracle10g", false, "jdbc:oracle", "oracle.jdbc.OracleDriver"),
    MSSQL("mssql", true, "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"),
    MSSQL_JTDS("mssql", true, "jdbc:jtds:sqlserver", "net.sourceforge.jtds.jdbc.Driver");

    private final String dbType;
    private final boolean hasSchema;
    private final String uriPrefix;
    private final String driverClassName;

    public static JiraDatabaseType getDatabaseType(String uriPrefix, String driverClassName) {
        for (JiraDatabaseType databaseType : JiraDatabaseType.values()) {
            if (!databaseType.accept(uriPrefix) || !databaseType.driverClassName.equals(driverClassName)) continue;
            return databaseType;
        }
        return null;
    }

    private JiraDatabaseType(String dbType, boolean hasSchema, String uriPrefix, String driverClassName) {
        this.dbType = dbType;
        this.hasSchema = hasSchema;
        this.uriPrefix = uriPrefix;
        this.driverClassName = driverClassName;
    }

    private boolean accept(String uri) {
        return null != uri && uri.trim().startsWith(this.uriPrefix);
    }

    public String getDbType() {
        return this.dbType;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }
}

