/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenContext {
    private final MavenProject project;
    private final List<MavenProject> reactor;
    private final MavenSession session;
    private final BuildPluginManager buildPluginManager;
    private final Log log;
    private String versionOverridesPath;
    private Properties versionOverrides;

    public MavenContext(MavenProject project, List<MavenProject> reactor, MavenSession session, BuildPluginManager buildPluginManager, Log log) {
        this.project = project;
        this.reactor = reactor;
        this.session = session;
        this.buildPluginManager = buildPluginManager;
        this.log = log;
    }

    public MavenProject getProject() {
        return this.project;
    }

    MavenSession getSession() {
        return this.session;
    }

    public Log getLog() {
        return this.log;
    }

    public Properties getVersionOverrides() {
        if (null == this.versionOverrides) {
            File overridesFile;
            this.versionOverrides = new Properties();
            if (null != this.versionOverridesPath && (overridesFile = new File(this.versionOverridesPath)).exists() && overridesFile.canRead()) {
                try {
                    this.versionOverrides.load(FileUtils.openInputStream((File)overridesFile));
                }
                catch (IOException e) {
                    this.log.error((CharSequence)("unable to load version overrides file as Properties: " + overridesFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return this.versionOverrides;
    }

    public List<MavenProject> getReactor() {
        return this.reactor;
    }

    public MavenContext with(MavenProject project, List<MavenProject> reactor, MavenSession session) {
        return new MavenContext(project, reactor, session, this.buildPluginManager, this.log);
    }

    public MojoExecutor.ExecutionEnvironment getExecutionEnvironment() {
        return MojoExecutor.executionEnvironment(this.project, this.session, this.buildPluginManager);
    }

    public void setVersionOverridesPath(String versionOverridesPath) {
        this.versionOverridesPath = versionOverridesPath;
    }
}

