/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.FeCruProductHandler;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.apache.maven.surefire.shade.org.apache.commons.lang.StringUtils;

public class StudioProperties {
    protected String version;
    private String studioHome;
    private String studioDataLocation;
    private Product studioProduct;
    private boolean modeConfluenceStandalone = false;
    private String svnRoot;
    private String svnPublicUrl;
    private String svnImportStagingDirectory;
    private String webDavHome;
    private Product jira;
    private String greenHopperLicense;
    private Product confluence;
    private Product fisheye;
    private Product bamboo;
    private Product crowd;
    private boolean gappsEnabled;
    private String gappsDomain;
    private Map<String, String> systemProperties = Maps.newHashMap();

    public StudioProperties(Product studioContext) {
        if (!"studio".equals(studioContext.getId())) {
            throw new IllegalArgumentException("The Studio Properties should be based on the Studio product");
        }
        this.version = ProjectUtils.firstNotNull(studioContext.getVersion(), "RELEASE");
        this.studioProduct = studioContext;
        this.gappsEnabled = Boolean.getBoolean(studioContext.getGappsEnabled());
        this.gappsDomain = ProjectUtils.firstNotNull(studioContext.getGappsDomain(), "");
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setStudioHome(String studioHome) {
        this.studioHome = studioHome;
    }

    public void setStudioDataLocation(String studioDataLocation) {
        this.studioDataLocation = studioDataLocation;
    }

    public void setModeConfluenceStandalone(boolean modeConfluenceStandalone) {
        this.modeConfluenceStandalone = modeConfluenceStandalone;
    }

    public void setSvnRoot(String svnRoot) {
        this.svnRoot = svnRoot;
    }

    public void setSvnPublicUrl(String svnPublicUrl) {
        this.svnPublicUrl = svnPublicUrl;
    }

    public void setSvnImportStagingDirectory(String svnImportStagingDirectory) {
        this.svnImportStagingDirectory = svnImportStagingDirectory;
    }

    public void setWebDavHome(String webDavHome) {
        this.webDavHome = webDavHome;
    }

    public void setJira(Product jira) {
        this.jira = jira;
    }

    public void setGreenHopperLicense(String greenHopperLicense) {
        this.greenHopperLicense = greenHopperLicense;
    }

    public void setConfluence(Product confluence) {
        this.confluence = confluence;
    }

    public void setFisheye(Product fisheye) {
        this.fisheye = fisheye;
    }

    public void setBamboo(Product bamboo) {
        this.bamboo = bamboo;
    }

    public void setCrowd(Product crowd) {
        this.crowd = crowd;
    }

    public void setGappsEnabled(boolean gappsEnabled) {
        this.gappsEnabled = gappsEnabled;
    }

    public void setGappsDomain(String gappsDomain) {
        this.gappsDomain = gappsDomain;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStudioHome() {
        return this.studioHome;
    }

    public String getStudioDataLocation() {
        return this.studioDataLocation;
    }

    public Product getStudioProduct() {
        return this.studioProduct;
    }

    public void setStudioProduct(Product studioProduct) {
        this.studioProduct = studioProduct;
    }

    public Map<String, String> getSystemProperties() {
        return ImmutableMap.copyOf(this.systemProperties);
    }

    public void overrideSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    public boolean isModeConfluenceStandalone() {
        return this.modeConfluenceStandalone;
    }

    public String getSvnRoot() {
        return this.svnRoot;
    }

    public String getSvnPublicUrl() {
        return this.svnPublicUrl;
    }

    public String getSvnHooks() {
        if (this.svnRoot != null) {
            return new File(this.svnRoot, "hooks").getAbsolutePath();
        }
        return null;
    }

    public String getSvnImportStagingDirectory() {
        return this.svnImportStagingDirectory;
    }

    public String getWebDavHome() {
        return this.webDavHome;
    }

    public String getGreenHopperLicense() {
        return this.greenHopperLicense;
    }

    public Product getConfluence() {
        return this.confluence;
    }

    public Product getJira() {
        return this.jira;
    }

    public Product getFisheye() {
        return this.fisheye;
    }

    public boolean getFisheyeShutdownEnabled() {
        return this.fisheye.getShutdownEnabled();
    }

    public String getFisheyeControlPort() {
        return String.valueOf(FeCruProductHandler.controlPort(this.fisheye.getHttpPort()));
    }

    public Product getBamboo() {
        return this.bamboo;
    }

    public Product getCrowd() {
        return this.crowd;
    }

    public boolean isGappsEnabled() {
        return this.gappsEnabled;
    }

    public String getGappsDomain() {
        return ProjectUtils.firstNotNull(this.gappsDomain, "");
    }

    public int getJiraPort() {
        return this.jira != null ? this.jira.getHttpPort() : 0;
    }

    public String getJiraContextPath() {
        if (this.jira == null || StringUtils.isBlank((String)this.jira.getContextPath())) {
            return "";
        }
        return this.jira.getContextPath().replaceAll("/", "");
    }

    public String getJiraUrl() {
        if (this.jira == null) {
            return "";
        }
        return String.format("http://localhost:%d%s", this.jira.getHttpPort(), this.jira.getContextPath());
    }

    public String getJiraHostUrl() {
        if (this.jira == null) {
            return "";
        }
        return String.format("http://localhost:%d", this.jira.getHttpPort());
    }

    public boolean isJiraEnabled() {
        return !this.modeConfluenceStandalone;
    }

    public int getConfluencePort() {
        return this.confluence != null ? this.confluence.getHttpPort() : 0;
    }

    public String getConfluenceContextPath() {
        if (this.confluence == null || StringUtils.isBlank((String)this.confluence.getContextPath())) {
            return "";
        }
        return this.confluence.getContextPath().replaceAll("/", "");
    }

    public String getConfluenceUrl() {
        if (this.confluence == null) {
            return "";
        }
        return String.format("http://localhost:%d%s", this.confluence.getHttpPort(), this.confluence.getContextPath());
    }

    public String getConfluenceHostUrl() {
        if (this.confluence == null) {
            return "";
        }
        return String.format("http://localhost:%d", this.confluence.getHttpPort());
    }

    public boolean isConfluenceEnabled() {
        return this.confluence != null;
    }

    public int getFisheyePort() {
        return this.fisheye != null ? this.fisheye.getHttpPort() : 0;
    }

    public String getFisheyeContextPath() {
        if (this.fisheye == null || StringUtils.isBlank((String)this.fisheye.getContextPath())) {
            return "";
        }
        return this.fisheye.getContextPath().replaceAll("/", "");
    }

    public String getFisheyeUrl() {
        if (this.fisheye == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)this.fisheye.getContextPath()) && !"/".equals(this.fisheye.getContextPath())) {
            return String.format("http://localhost:%d%s", this.fisheye.getHttpPort(), this.fisheye.getContextPath());
        }
        return String.format("http://localhost:%d", this.fisheye.getHttpPort());
    }

    public String getFisheyeHostUrl() {
        return this.getFisheyeUrl();
    }

    public boolean isFisheyeEnabled() {
        return this.fisheye != null;
    }

    public String getBambooContextPath() {
        if (this.bamboo == null || StringUtils.isBlank((String)this.bamboo.getContextPath())) {
            return "";
        }
        return this.bamboo.getContextPath().replaceAll("/", "");
    }

    public int getBambooPort() {
        return this.bamboo != null ? this.bamboo.getHttpPort() : 0;
    }

    public String getBambooUrl() {
        if (this.bamboo == null) {
            return "";
        }
        return String.format("http://localhost:%d%s", this.bamboo.getHttpPort(), this.bamboo.getContextPath());
    }

    public String getBambooHostUrl() {
        if (this.bamboo == null) {
            return "";
        }
        return String.format("http://localhost:%d", this.bamboo.getHttpPort());
    }

    public boolean isBambooEnabled() {
        return this.bamboo != null;
    }

    public String getCrowdUrl() {
        if (this.crowd == null) {
            return "";
        }
        return String.format("http://localhost:%d%s", this.crowd.getHttpPort(), this.crowd.getContextPath());
    }

    public String getCrowdHostUrl() {
        if (this.crowd == null) {
            return "";
        }
        return String.format("http://localhost:%d", this.crowd.getHttpPort());
    }

    public String getCrowdContextPath() {
        if (this.crowd == null || StringUtils.isBlank((String)this.crowd.getContextPath())) {
            return "";
        }
        return this.crowd.getContextPath().replaceAll("/", "");
    }

    public int getCrowdPort() {
        return this.crowd != null ? this.crowd.getHttpPort() : 0;
    }
}

