/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class CrowdProductHandler
extends AbstractWebappProductHandler {
    public CrowdProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals, new CrowdPluginProvider());
    }

    @Override
    public String getId() {
        return "crowd";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.crowd", "crowd-web-app", "RELEASE");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.crowd.distribution", "crowd-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 4990;
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        systemProperties.putAll(super.getSystemProperties(ctx));
        systemProperties.put((Object)"crowd.home", (Object)this.getHomeDirectory(ctx).getPath());
        return systemProperties.build();
    }

    @Override
    public File getUserInstalledPluginsDirectory(File webappDir, File homeDir) {
        return new File(homeDir, "plugins");
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.7"), new ProductArtifact("jta", "jta", "1.0.1B"), new ProductArtifact("javax.mail", "mail", "1.4"), new ProductArtifact("javax.activation", "activation", "1.0.2"));
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        return new File(appDir, "WEB-INF/classes/atlassian-bundled-plugins.zip");
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        String baseUrl = MavenGoals.getBaseUrl(ctx, ctx.getHttpPort());
        try {
            baseUrl = CrowdProductHandler.withLocalhostAsHostname(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Unable to process Crowd service URL", (Exception)e);
        }
        try {
            ConfigFileUtils.replaceAll(new File(homeDir, "crowd.cfg.xml"), "jdbc:hsqldb:.*/(crowd-)?home/database/defaultdb", "jdbc:hsqldb:" + this.getHomeDirectory(ctx).getCanonicalPath().replace("\\", "/") + "/database/defaultdb");
            ImmutableMap newProperties = ImmutableMap.of((Object)"crowd.server.url", (Object)(baseUrl + "/services"), (Object)"application.login.url", (Object)baseUrl);
            ConfigFileUtils.setProperties(new File(homeDir, "crowd.properties"), (Map<String, String>)newProperties);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    static String withLocalhostAsHostname(String uri) throws URISyntaxException {
        URI base = new URI(uri);
        URI baseWithLocalhost = new URI(base.getScheme(), base.getUserInfo(), "localhost", base.getPort(), base.getPath(), base.getQuery(), base.getFragment());
        return baseWithLocalhost.toString();
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File homeDirectory) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, homeDirectory);
        FileUtils.deleteQuietly((File)new File(homeDirectory, "caches/transformed-plugins"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "caches/felix/felix-cache"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "logs"));
    }

    @Override
    public List<File> getConfigFiles(Product product, File snapshotDir) {
        List<File> configFiles = super.getConfigFiles(product, snapshotDir);
        configFiles.add(new File(snapshotDir, "database.log"));
        configFiles.add(new File(snapshotDir, "crowd.cfg.xml"));
        configFiles.add(new File(snapshotDir, "crowd.properties"));
        return configFiles;
    }

    private static class CrowdPluginProvider
    extends AbstractPluginProvider {
        private CrowdPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-crowd-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>();
            plugins.addAll(super.getPdkInstallArtifacts(pdkInstallVersion));
            plugins.add(new ProductArtifact("commons-fileupload", "commons-fileupload", "1.2.1"));
            return plugins;
        }
    }
}

