/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerAwareMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProductHandlerMojo
extends AbstractProductHandlerAwareMojo {
    protected static final String DEFAULT_CONTAINER = "tomcat6x";
    protected static final String JUNIT_VERSION = "4.10_1";
    protected static final String ATLASSIAN_TEST_RUNNER_VERSION = "1.1";
    protected static final String NO_TEST_GROUP = "__no_test_group__";
    protected static final String DEFAULT_SERVER;
    protected static final String DEFAULT_PDK_VERSION = "0.4";
    protected static final String DEFAULT_WEB_CONSOLE_VERSION = "1.2.8";
    protected static final String DEFAULT_FASTDEV_VERSION = "2.0";
    protected static final String DEFAULT_DEV_TOOLBOX_VERSION = "2.0.5";
    protected static final String DEFAULT_PDE_VERSION = "1.2";
    protected final List<ProductArtifact> testFrameworkPlugins = new ArrayList<ProductArtifact>(){
        {
            this.add(new ProductArtifact("org.apache.servicemix.bundles", "org.apache.servicemix.bundles.junit", AbstractProductHandlerMojo.JUNIT_VERSION));
            this.add(new ProductArtifact("com.atlassian.plugins", "atlassian-plugins-osgi-testrunner-bundle", AbstractProductHandlerMojo.ATLASSIAN_TEST_RUNNER_VERSION));
        }
    };
    private static final int DEFAULT_PRODUCT_STARTUP_TIMEOUT = 600000;
    private static final int DEFAULT_PRODUCT_SHUTDOWN_TIMEOUT = 600000;
    @Parameter(property="container", defaultValue="tomcat6x")
    protected String containerId;
    @Parameter(property="http.port", defaultValue="0")
    private int httpPort;
    @Parameter(property="use.https", defaultValue="false")
    protected boolean useHttps;
    @Parameter(property="context.path")
    protected String contextPath;
    @Parameter(property="server")
    protected String server;
    @Parameter(property="product.version")
    private String productVersion;
    @Parameter(property="jvmargs")
    protected String jvmArgs;
    @Parameter(property="product.start.timeout")
    private int startupTimeout;
    @Parameter(property="product.stop.timeout")
    private int shutdownTimeout;
    @Deprecated
    @Parameter
    protected Properties systemProperties = new Properties();
    @Parameter
    protected Map<String, Object> systemPropertyVariables = new HashMap<String, Object>();
    @Parameter
    protected File log4jProperties;
    @Deprecated
    @Parameter(property="test.resources.version")
    private String testResourcesVersion;
    @Parameter(property="product.data.version")
    private String productDataVersion;
    @Parameter(property="product.data.path")
    private String productDataPath;
    @Parameter(property="fastdev.enable", defaultValue="true")
    protected boolean enableFastdev;
    @Parameter(property="fastdev.version", defaultValue="2.0")
    protected String fastdevVersion;
    @Parameter(property="devtoolbox.enable", defaultValue="true")
    protected boolean enableDevToolbox;
    @Parameter(property="devtoolbox.version", defaultValue="2.0.5")
    protected String devToolboxVersion;
    @Parameter(property="pde.enable", defaultValue="true")
    protected boolean enablePde;
    @Parameter(property="pde.version", defaultValue="1.2")
    protected String pdeVersion;
    @Parameter
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    @Deprecated
    @Parameter
    private String salVersion;
    @Deprecated
    @Parameter(defaultValue="0.4")
    private String pdkVersion;
    @Deprecated
    @Parameter
    private String restVersion;
    @Deprecated
    @Parameter(defaultValue="1.2.8")
    private String webConsoleVersion;
    @Parameter(property="plugins")
    private String pluginArtifactsString;
    @Parameter(property="lib.plugins")
    private String libArtifactsString;
    @Parameter(property="bundled.plugins")
    private String bundledArtifactsString;
    @Parameter(property="project.build.directory", required=true)
    protected File targetDirectory;
    @Parameter(property="project.build.finalName", required=true)
    protected String finalName;
    @Parameter(property="install.plugin", defaultValue="true")
    protected boolean installPlugin;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(property="localRepository")
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List repositories;
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter
    protected List<Product> products = new ArrayList<Product>();
    private Map<String, Product> productMap;
    @Parameter
    private String output;
    @Parameter(property="additional.resource.folders")
    private String additionalResourceFolders;
    @Parameter(property="parallel", defaultValue="false")
    protected boolean parallel;

    protected Product createDefaultProductContext() throws MojoExecutionException {
        Product ctx = new Product();
        ctx.setId(this.getProductId());
        ctx.setContainerId(this.containerId);
        ctx.setServer(this.server);
        ctx.setContextPath(this.contextPath);
        ctx.setJvmArgs(this.jvmArgs);
        ctx.setStartupTimeout(this.startupTimeout);
        ctx.setShutdownTimeout(this.shutdownTimeout);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.systemPropertyVariables);
        properties.put("atlassian.sdk.version", this.getSdkVersion());
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "atlassian.dev.mode", "true");
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "java.awt.headless", "true");
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "plugin.resource.directories", this.buildResourcesList());
        AbstractProductHandlerMojo.setDefaultSystemProperty(properties, "plugin.root.directories", this.buildRootProperty());
        ctx.setSystemPropertyVariables(properties);
        ctx.setBundledArtifacts(this.bundledArtifacts);
        ctx.setLibArtifacts(this.libArtifacts);
        ctx.setPluginArtifacts(this.pluginArtifacts);
        ctx.setLog4jProperties(this.log4jProperties);
        ctx.setHttpPort(this.httpPort);
        ctx.setUseHttps(this.useHttps);
        ctx.setVersion(this.productVersion);
        ctx.setDataVersion(this.productDataVersion);
        ctx.setDataPath(this.productDataPath);
        ctx.setRestVersion(this.restVersion);
        ctx.setSalVersion(this.salVersion);
        ctx.setPdkVersion(this.pdkVersion);
        ctx.setWebConsoleVersion(this.webConsoleVersion);
        ctx.setEnableFastdev(this.enableFastdev);
        ctx.setFastdevVersion(this.fastdevVersion);
        ctx.setEnableDevToolbox(this.enableDevToolbox);
        ctx.setDevToolboxVersion(this.devToolboxVersion);
        ctx.setEnablePde(this.enablePde);
        ctx.setPdeVersion(this.pdeVersion);
        ctx.setHttpPort(this.httpPort);
        return ctx;
    }

    private String buildResourcesList() {
        StringBuilder resourceProp = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.additionalResourceFolders)) {
            String[] dirs;
            for (String rDir : dirs = StringUtils.split((String)this.additionalResourceFolders, (String)",")) {
                resourceProp.append(StringUtils.trim((String)rDir)).append(",");
            }
        }
        MavenProject mavenProject = this.getMavenContext().getProject();
        List resList = mavenProject.getResources();
        for (int i = 0; i < resList.size(); ++i) {
            resourceProp.append(((Resource)resList.get(i)).getDirectory());
            if (i + 1 == resList.size()) continue;
            resourceProp.append(",");
        }
        if (ProjectUtils.shouldDeployTestJar(this.getMavenContext())) {
            List testResList = mavenProject.getTestResources();
            for (int i = 0; i < testResList.size(); ++i) {
                if (i == 0 && resourceProp.length() > 0) {
                    resourceProp.append(",");
                }
                resourceProp.append(((Resource)testResList.get(i)).getDirectory());
                if (i + 1 == testResList.size()) continue;
                resourceProp.append(",");
            }
        }
        return resourceProp.toString();
    }

    private String buildRootProperty() {
        MavenProject mavenProject = this.getMavenContext().getProject();
        return mavenProject.getBasedir().getPath();
    }

    private static void setDefaultSystemProperty(Map<String, Object> props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, System.getProperty(key, value));
        }
    }

    protected void setDefaultValues(Product product, ProductHandler handler) {
        product.setInstanceId(this.getProductInstanceId(product));
        String dversion = System.getProperty("product.data.version", product.getDataVersion());
        String pversion = System.getProperty("product.version", product.getVersion());
        String dpath = System.getProperty("product.data.path", product.getDataPath());
        if (!(StudioProductHandler.setDefaultValues(this.getMavenContext(), product) || "studio".equals(product.getId()) && !"studio".equals(System.getProperty("product")))) {
            product.setVersion(pversion);
            product.setDataVersion(dversion);
            product.setDataPath(dpath);
        }
        product.setArtifactRetriever(new ArtifactRetriever(this.artifactResolver, this.artifactFactory, this.localRepository, this.repositories));
        if (product.getContainerId() == null) {
            product.setContainerId(DEFAULT_CONTAINER);
        }
        if (product.getServer() == null) {
            product.setServer(DEFAULT_SERVER);
        }
        if (product.getPdkVersion() == null) {
            product.setPdkVersion(DEFAULT_PDK_VERSION);
        }
        if (product.getWebConsoleVersion() == null) {
            product.setWebConsoleVersion(DEFAULT_WEB_CONSOLE_VERSION);
        }
        if (product.isEnableFastdev() == null) {
            product.setEnableFastdev(true);
        }
        if (product.getFastdevVersion() == null) {
            product.setFastdevVersion(DEFAULT_FASTDEV_VERSION);
        }
        if (product.isEnableDevToolbox() == null) {
            product.setEnableDevToolbox(true);
        }
        if (product.getDevToolboxVersion() == null) {
            product.setDevToolboxVersion(DEFAULT_DEV_TOOLBOX_VERSION);
        }
        if (product.getPdeVersion() == null) {
            product.setPdeVersion(DEFAULT_PDE_VERSION);
        }
        if (product.getOutput() == null) {
            product.setOutput(this.output);
        }
        if (product.getStartupTimeout() <= 0) {
            product.setStartupTimeout(600000);
        }
        if (product.getShutdownTimeout() <= 0) {
            product.setShutdownTimeout(600000);
        }
        if (product.getHttpPort() == 0) {
            product.setHttpPort(handler.getDefaultHttpPort());
        }
        if (product.getUseHttps() == null) {
            product.setUseHttps(false);
        }
        if (product.getVersion() == null) {
            product.setVersion("RELEASE");
        }
        if (product.getDataVersion() == null) {
            product.setDataVersion(product.getVersion());
        }
        if (product.getContextPath() == null) {
            product.setContextPath("/" + handler.getId());
        }
        if (product.getDataSources() == null) {
            product.setDataSources(Lists.newArrayList());
        }
    }

    private List<ProductArtifact> stringToArtifactList(String val, List<ProductArtifact> artifacts) {
        if (val == null || val.trim().length() == 0) {
            return artifacts;
        }
        for (String ptn : val.split(",")) {
            String[] items = ptn.split(":");
            if (items.length < 2 || items.length > 3) {
                throw new IllegalArgumentException("Invalid artifact pattern: " + ptn);
            }
            String groupId = items[0];
            String artifactId = items[1];
            String version = items.length == 3 ? items[2] : "LATEST";
            artifacts.add(new ProductArtifact(groupId, artifactId, version));
        }
        return artifacts;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.stringToArtifactList(this.pluginArtifactsString, this.pluginArtifacts);
        this.stringToArtifactList(this.libArtifactsString, this.libArtifacts);
        this.stringToArtifactList(this.bundledArtifactsString, this.bundledArtifacts);
        this.systemPropertyVariables.putAll(this.systemProperties);
        this.detectDeprecatedVersionOverrides();
        this.doExecute();
    }

    private void detectDeprecatedVersionOverrides() {
        Properties props = this.getMavenContext().getProject().getProperties();
        for (String deprecatedProperty : new String[]{"sal.version", "rest.version", "web.console.version", "pdk.version"}) {
            if (!props.containsKey(deprecatedProperty)) continue;
            this.getLog().warn((CharSequence)("The property '" + deprecatedProperty + "' is no longer usable to override the related bundled plugin." + "  Use <pluginArtifacts> or <libArtifacts> to explicitly override bundled plugins and libraries, respectively."));
        }
    }

    Map<String, Product> createProductContexts() throws MojoExecutionException {
        HashMap productMap = Maps.newHashMap();
        MavenContext mavenContext = this.getMavenContext();
        MavenGoals goals = this.getMavenGoals();
        this.makeProductsInheritDefaultConfiguration(this.products, productMap);
        for (Product ctx : Lists.newArrayList(productMap.values())) {
            ProductHandler handler = ProductHandlerFactory.create(ctx.getId(), mavenContext, goals);
            this.setDefaultValues(ctx, handler);
            for (String instanceId : StudioProductHandler.getDependantInstances(ctx)) {
                if (productMap.containsKey(instanceId)) continue;
                ProductHandler dependantHandler = this.createProductHandler(instanceId);
                productMap.put(instanceId, this.createProductContext(instanceId, instanceId, dependantHandler));
            }
        }
        StudioProductHandler studioProductHandler = (StudioProductHandler)ProductHandlerFactory.create("studio", mavenContext, goals);
        studioProductHandler.configureStudioProducts(productMap);
        return productMap;
    }

    protected Map<String, Product> getProductContexts() throws MojoExecutionException {
        if (this.productMap == null) {
            this.productMap = this.createProductContexts();
        }
        return this.productMap;
    }

    void makeProductsInheritDefaultConfiguration(List<Product> products, Map<String, Product> productMap) throws MojoExecutionException {
        Product defaultProduct = this.createDefaultProductContext();
        productMap.put(this.getProductId(), defaultProduct);
        if (!products.isEmpty()) {
            for (Product product : products) {
                Product processedProduct = product.merge(defaultProduct);
                if ("studio-crowd".equals(processedProduct.getId())) {
                    processedProduct.getSystemPropertyVariables().put("atlassian.dev.mode", "false");
                }
                String instanceId = this.getProductInstanceId(processedProduct);
                productMap.put(instanceId, processedProduct);
            }
        }
    }

    private String getProductInstanceId(Product processedProduct) {
        return processedProduct.getInstanceId() == null ? processedProduct.getId() : processedProduct.getInstanceId();
    }

    private Product createProductContext(String productNickname, String instanceId, ProductHandler handler) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Studio (instanceId=%s): No product with name %s is defined in the pom. Using a default product.", instanceId, productNickname));
        Product product = this.createDefaultProductContext();
        product.setId(productNickname);
        product.setInstanceId(instanceId);
        this.setDefaultValues(product, handler);
        if ("studio-crowd".equals(product.getId())) {
            product.getSystemPropertyVariables().put("atlassian.dev.mode", "false");
        }
        return product;
    }

    protected void stopProducts(List<ProductExecution> productExecutions) throws MojoExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(productExecutions.size());
        try {
            long before = System.nanoTime();
            for (ProductExecution execution : Iterables.reverse(productExecutions)) {
                final Product product = execution.getProduct();
                final ProductHandler productHandler = execution.getProductHandler();
                Future<?> task = executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        AbstractProductHandlerMojo.this.getLog().info((CharSequence)(product.getInstanceId() + ": Shutting down"));
                        try {
                            productHandler.stop(product);
                        }
                        catch (MojoExecutionException e) {
                            AbstractProductHandlerMojo.this.getLog().error((CharSequence)("Exception while trying to stop " + product.getInstanceId()), (Throwable)e);
                        }
                    }
                });
                try {
                    task.get(product.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    this.getLog().info((CharSequence)(product.getInstanceId() + " shutdown: Didn't return in time"));
                    task.cancel(true);
                }
            }
            long after = System.nanoTime();
            this.getLog().info((CharSequence)("amps:stop in " + TimeUnit.NANOSECONDS.toSeconds(after - before) + "s"));
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Exception while stopping the products", (Exception)e);
        }
        if (this.parallel) {
            this.waitForProducts(productExecutions, false);
        }
    }

    protected void waitForProducts(List<ProductExecution> productExecutions, boolean startingUp) throws MojoExecutionException {
        for (ProductExecution productExecution : productExecutions) {
            this.pingRepeatedly(productExecution.getProduct(), startingUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingRepeatedly(Product product, boolean startingUp) throws MojoExecutionException {
        if (product.getHttpPort() != 0) {
            String url = "http://" + product.getServer() + ":" + product.getHttpPort();
            if (StringUtils.isNotBlank((String)product.getContextPath())) {
                url = url + product.getContextPath();
            }
            int timeout = startingUp ? product.getStartupTimeout() : product.getShutdownTimeout();
            long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
            boolean interrupted = false;
            boolean success = false;
            String lastMessage = "";
            while (!success && !interrupted && System.nanoTime() < end) {
                URLConnection connection = null;
                try {
                    URL urlToPing = new URL(url);
                    connection = (HttpURLConnection)urlToPing.openConnection();
                    int response = ((HttpURLConnection)connection).getResponseCode();
                    lastMessage = "Last response code is " + response;
                    success = startingUp ? response < 400 : response >= 400;
                }
                catch (IOException e) {
                    lastMessage = e.getMessage();
                    success = !startingUp;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.getInputStream().close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (success) continue;
                this.getLog().info((CharSequence)("Waiting for " + url + (startingUp ? "" : " to stop")));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                    break;
                }
            }
            if (!success) {
                throw new MojoExecutionException(String.format("The product %s didn't %s after %ds at %s. %s", product.getInstanceId(), startingUp ? "start" : "stop", TimeUnit.MILLISECONDS.toSeconds(timeout), url, lastMessage));
            }
        }
    }

    private Iterable<ProductExecution> getStudioExecutions(List<ProductExecution> productExecutions) {
        return Iterables.filter(productExecutions, (Predicate)new Predicate<ProductExecution>(){

            public boolean apply(ProductExecution input) {
                return input.getProductHandler() instanceof StudioProductHandler;
            }
        });
    }

    protected List<ProductExecution> includeStudioDependentProducts(List<ProductExecution> productExecutions, MavenGoals goals) throws MojoExecutionException {
        Iterable<ProductExecution> studioExecutions = this.getStudioExecutions(productExecutions);
        if (Iterables.isEmpty(studioExecutions)) {
            return productExecutions;
        }
        ArrayList productExecutionsIncludingStudio = Lists.newArrayList(productExecutions);
        Map<String, Product> allContexts = this.getProductContexts();
        for (ProductExecution execution : studioExecutions) {
            for (String dependantProduct : StudioProductHandler.getDependantInstances(execution.getProduct())) {
                Product product = allContexts.get(dependantProduct);
                productExecutionsIncludingStudio.add(this.toProductExecution(product));
            }
        }
        return productExecutionsIncludingStudio;
    }

    protected ProductExecution toProductExecution(Product product) {
        return new ProductExecution(product, this.createProductHandler(product.getId()));
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected void setParallelMode(List<ProductExecution> executions) {
        for (ProductExecution execution : executions) {
            Product product = execution.getProduct();
            if (this.parallel) {
                if (product.getSynchronousStartup() != null) continue;
                product.setSynchronousStartup(Boolean.FALSE);
                continue;
            }
            product.setSynchronousStartup(Boolean.TRUE);
        }
    }

    static {
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            localHostName = "localhost";
        }
        DEFAULT_SERVER = localHostName;
    }
}

