/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.CrowdProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioComponentProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class StudioCrowdProductHandler
extends CrowdProductHandler
implements StudioComponentProductHandler {
    public StudioCrowdProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals);
    }

    @Override
    public String getId() {
        return "studio-crowd";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.studio", "studio-crowd", "RELEASE");
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(ctx, homeDir);
        StudioProductHandler.processProductsHomeDirectory(this.log, ctx, homeDir);
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        StudioProductHandler.addProductHandlerOverrides(this.log, ctx, homeDir, explodedWarDir);
    }

    @Override
    public Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(super.getSystemProperties(product));
        String dbUrl = String.format("jdbc:hsqldb:%s/database", this.getHomeDirectory(product).getPath());
        String driverClass = "org.hsqldb.jdbcDriver";
        String username = "sa";
        String password = "";
        String datasourceTypeClass = "javax.sql.DataSource";
        String datasource = String.format("cargo.datasource.url=%s", dbUrl);
        String driver = String.format("cargo.datasource.driver=%s", "org.hsqldb.jdbcDriver");
        String datasourceUsername = String.format("cargo.datasource.username=%s", "sa");
        String datasourcePassword = String.format("cargo.datasource.password=%s", "");
        String datasourceType = String.format("cargo.datasource.type=%s", "javax.sql.DataSource");
        String jndi = "cargo.datasource.jndi=jdbc/DefaultDS";
        systemProperties.put("cargo.datasource.datasource", String.format("%s|%s|%s|%s|%s|%s", datasource, driver, datasourceUsername, datasourcePassword, datasourceType, "cargo.datasource.jndi=jdbc/DefaultDS"));
        systemProperties.putAll(product.getStudioProperties().getSystemProperties());
        return systemProperties;
    }
}

