/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.AmpsProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.product.studio.StudioProperties;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class StudioProductHandler
extends AmpsProductHandler {
    private static final String STUDIO_PROPERTIES = "home/studio.properties";
    private static final String STUDIO_INITIAL_DATA_PROPERTIES = "home/studio-initial-data.properties";
    private static final String DEVMODE_HAL_LICENSES_XML = "home/devmode-hal-licenses.xml";
    private static final String STUDIO_INITIAL_DATA_XML = "home/studio-initial-data.xml";
    private static final String STUDIO_VERSION_TOKEN = "STUDIO-VERSION";
    private static final String LAUNCH_INSTANCES_SYSTEM_PROPERTY = "studio.instanceIds";
    private static final Map<String, String> defaultContextPaths = new HashMap<String, String>();

    public StudioProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals);
    }

    @Override
    protected ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.studio", "studio-test-resources");
    }

    @Override
    public String getId() {
        return "studio";
    }

    public List<String> getDependantInstances(Product studioContext) throws MojoExecutionException {
        StudioProperties studioProperties = StudioProductHandler.getStudioProperties(studioContext);
        studioProperties.setStudioProduct(studioContext);
        List<String> instanceIds = studioContext.getInstanceIds();
        if (instanceIds.isEmpty()) {
            instanceIds.add("studio-crowd");
            instanceIds.add("studio-jira");
            instanceIds.add("studio-confluence");
            instanceIds.add("studio-fecru");
            instanceIds.add("studio-bamboo");
        }
        return instanceIds;
    }

    public Set<String> getExcludedInstances(Product studioContext) {
        String restriction = System.getProperty(LAUNCH_INSTANCES_SYSTEM_PROPERTY);
        if (restriction == null) {
            return null;
        }
        Object[] restrictionList = restriction.split(",");
        this.log.info((CharSequence)String.format("Excluding %s from the %s instance.", Arrays.toString(restrictionList), studioContext.getInstanceId()));
        return Sets.newHashSet((Object[])restrictionList);
    }

    @Override
    public int start(Product ctx) throws MojoExecutionException {
        this.sanityCheck(ctx);
        this.createStudioHome(ctx);
        File symlink = new File(this.context.getProject().getBuild().getDirectory(), "svn");
        if (!symlink.exists()) {
            this.createSymlink(ctx.getStudioProperties().getSvnRoot(), symlink);
        }
        return 0;
    }

    private void sanityCheck(Product studioProduct) throws MojoExecutionException {
        StudioProperties properties = studioProduct.getStudioProperties();
        if (properties == null) {
            throw new MojoExecutionException(String.format("Something went wrong when starting %s. The 'studio' handler was not initialised propertly.", studioProduct.getInstanceId()));
        }
        if (properties.getCrowd() == null || properties.getCrowd().getStudioProperties() == null) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Crowd was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isJiraEnabled() && (properties.getJira() == null || properties.getJira().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-JIRA was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isConfluenceEnabled() && (properties.getConfluence() == null || properties.getConfluence().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Confluence was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isFisheyeEnabled() && (properties.getFisheye() == null || properties.getFisheye().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Fisheye was not configured properly.", studioProduct.getInstanceId()));
        }
        if (properties.isBambooEnabled() && (properties.getBamboo() == null || properties.getBamboo().getStudioProperties() == null)) {
            this.log.error((CharSequence)String.format("You won't be able to run %s, Studio-Bamboo was not configured properly.", studioProduct.getInstanceId()));
        }
    }

    @Override
    public void stop(Product ctx) throws MojoExecutionException {
        File symlink = new File(this.context.getProject().getBuild().getDirectory(), "svn");
        symlink.deleteOnExit();
    }

    @Override
    public int getDefaultHttpPort() {
        return 0;
    }

    public static void setDefaultValues(MavenContext context, Product product) {
        String defaultContextPath = defaultContextPaths.get(product.getId());
        if (defaultContextPath != null) {
            if (product.getOutput() == null) {
                product.setOutput(new File(context.getProject().getBuild().getDirectory(), product.getInstanceId() + ".log").getAbsolutePath());
            }
            if (product.getContextPath() == null) {
                product.setContextPath(defaultContextPath);
            }
            if (product.getVersion() == null) {
                product.setVersion(STUDIO_VERSION_TOKEN);
            }
        }
    }

    public void configure(Product studioContext, List<ProductExecution> dependantProducts) throws MojoExecutionException {
        StudioProperties studioProperties = StudioProductHandler.getStudioProperties(studioContext);
        boolean confluenceStandalone = true;
        for (ProductExecution execution : dependantProducts) {
            Product product = execution.getProduct();
            if ("studio-crowd".equals(product.getId())) {
                studioProperties.setCrowd(product);
            } else if ("studio-confluence".equals(product.getId())) {
                studioProperties.setConfluence(product);
            } else if ("studio-jira".equals(product.getId())) {
                studioProperties.setJira(product);
                confluenceStandalone = false;
            } else if ("studio-fecru".equals(product.getId())) {
                studioProperties.setFisheye(product);
                confluenceStandalone = false;
            } else if ("studio-bamboo".equals(product.getId())) {
                studioProperties.setBamboo(product);
                confluenceStandalone = false;
            } else {
                throw new MojoExecutionException("A non-studio product was listed in a Studio instance: " + product.getInstanceId());
            }
            studioProperties.setModeConfluenceStandalone(confluenceStandalone);
            product.setStudioProperties(studioProperties);
            if (!STUDIO_VERSION_TOKEN.equals(product.getVersion())) continue;
            product.setVersion(studioProperties.getVersion());
        }
    }

    private static StudioProperties getStudioProperties(Product studioContext) {
        StudioProperties properties = studioContext.getStudioProperties();
        if (properties == null) {
            properties = new StudioProperties(studioContext);
            studioContext.setStudioProperties(properties);
        }
        return properties;
    }

    @Override
    public File getSnapshotDirectory(Product studio) {
        return this.getHomeDirectory(studio).getParentFile();
    }

    public void createStudioHome(Product studio) throws MojoExecutionException {
        Product fecru;
        Product bamboo;
        Product jira;
        Product confluence;
        String svnPublicUrl;
        File svnHomeDir;
        StudioProperties properties = StudioProductHandler.getStudioProperties(studio);
        File studioHomeDir = this.getHomeDirectory(studio);
        File studioCommonsDir = studioHomeDir.getParentFile();
        if (!studioHomeDir.exists()) {
            this.extractHome(studioCommonsDir, studio);
            if (!studioHomeDir.exists()) {
                throw new MojoExecutionException("The Studio home zip must contain a '*/*/home' folder");
            }
        }
        if (!(svnHomeDir = new File(studioCommonsDir, "svn-home")).exists()) {
            throw new MojoExecutionException("The Studio home zip must contain a '*/*/svn-home' folder");
        }
        File webDavDir = new File(studioCommonsDir, "webdav-home");
        if (!webDavDir.exists()) {
            throw new MojoExecutionException("The Studio home zip must contain a '*/*/webdav-home' folder");
        }
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
            svnPublicUrl = "file:///" + svnHomeDir.getAbsolutePath();
            this.log.warn((CharSequence)"Studio is only designed to run on Linux systems.");
        } else {
            svnPublicUrl = "file://" + svnHomeDir.getAbsolutePath();
        }
        properties.setStudioHome(studioHomeDir.getAbsolutePath());
        properties.setSvnRoot(svnHomeDir.getAbsolutePath());
        properties.setSvnPublicUrl(svnPublicUrl);
        properties.setWebDavHome(webDavDir.getAbsolutePath());
        this.parameteriseFiles(studioCommonsDir, studio);
        properties.overrideSystemProperty("studio.home", studioHomeDir.getAbsolutePath());
        properties.overrideSystemProperty("studio.initial.data.xml", new File(studioCommonsDir, STUDIO_INITIAL_DATA_XML).getAbsolutePath());
        properties.overrideSystemProperty("studio.initial.data.properties", new File(studioCommonsDir, STUDIO_INITIAL_DATA_PROPERTIES).getAbsolutePath());
        properties.overrideSystemProperty("studio.hal.instance.uri", new File(studioCommonsDir, DEVMODE_HAL_LICENSES_XML).getAbsolutePath());
        Product crowd = properties.getCrowd();
        if (crowd.getDataPath() == null) {
            crowd.setDataPath(new File(studioCommonsDir, "crowd-home").getAbsolutePath());
        }
        if ((confluence = properties.getConfluence()) != null && confluence.getDataPath() == null) {
            confluence.setDataPath(new File(studioCommonsDir, "confluence-home").getAbsolutePath());
        }
        if ((jira = properties.getJira()) != null && jira.getDataPath() == null) {
            jira.setDataPath(new File(studioCommonsDir, "jira-home").getAbsolutePath());
        }
        if ((bamboo = properties.getBamboo()) != null && bamboo.getDataPath() == null) {
            bamboo.setDataPath(new File(studioCommonsDir, "bamboo-home").getAbsolutePath());
        }
        if ((fecru = properties.getFisheye()) != null && fecru.getDataPath() == null) {
            fecru.setDataPath(new File(studioCommonsDir, "fecru-home").getAbsolutePath());
        }
    }

    private void parameteriseFiles(File studioSnapshotCopyDir, Product studio) throws MojoExecutionException {
        ConfigFileUtils.replace(this.getConfigFiles(studio, studioSnapshotCopyDir), this.getReplacements(studio), false, this.log);
    }

    @Override
    public List<File> getConfigFiles(Product studio, File studioSnapshotDir) {
        ArrayList list = Lists.newArrayList();
        list.add(new File(studioSnapshotDir, STUDIO_PROPERTIES));
        list.add(new File(studioSnapshotDir, STUDIO_INITIAL_DATA_PROPERTIES));
        list.add(new File(studioSnapshotDir, STUDIO_INITIAL_DATA_XML));
        list.add(new File(studioSnapshotDir, DEVMODE_HAL_LICENSES_XML));
        return list;
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(final Product studio) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(studio);
        replacements.addAll((Collection<ConfigFileUtils.Replacement>)new ArrayList<ConfigFileUtils.Replacement>(){
            {
                StudioProperties properties = studio.getStudioProperties();
                this.putIfNotNull("%GREENHOPPER-LICENSE%", "test-classes/greenhopper.license");
                if (properties.isJiraEnabled()) {
                    File attachmentsFolder = new File(StudioProductHandler.this.getHomeDirectory(properties.getJira()), "attachments");
                    this.putIfNotNull("%JIRA-ATTACHMENTS%", attachmentsFolder.getAbsolutePath());
                    this.putIfNotNull("%JIRA-BASE-URL%", properties.getJiraUrl());
                    this.putIfNotNull("%JIRA-HOST-URL%", properties.getJiraHostUrl());
                    this.putIfNotNull("%JIRA-CONTEXT%", properties.getJiraContextPath());
                }
                if (properties.isConfluenceEnabled()) {
                    this.putIfNotNull("%CONFLUENCE-BASE-URL%", properties.getConfluenceUrl());
                    this.putIfNotNull("%CONFLUENCE-HOST-URL%", properties.getConfluenceHostUrl());
                    this.putIfNotNull("%CONFLUENCE-CONTEXT%", properties.getConfluenceContextPath());
                }
                if (properties.isFisheyeEnabled()) {
                    this.putIfNotNull("%FISHEYE-BASE-URL%", properties.getFisheyeUrl());
                    this.putIfNotNull("%FISHEYE-HOST-URL%", properties.getFisheyeHostUrl());
                    this.putIfNotNull("%FISHEYE-CONTROL-PORT%", properties.getFisheyeControlPort());
                    this.putNonReversibleIfNotNull("%FISHEYE-CONTEXT%", properties.getFisheyeContextPath());
                    this.putIfNotNull("%FISHEYE-SHUTDOWN-ENABLED%", properties.getFisheyeShutdownEnabled());
                }
                if (properties.isBambooEnabled()) {
                    this.putIfNotNull("%BAMBOO-BASE-URL%", properties.getBambooUrl());
                    this.putIfNotNull("%BAMBOO-HOST-URL%", properties.getBambooHostUrl());
                    this.putIfNotNull("%BAMBOO-CONTEXT%", properties.getBambooContextPath());
                    this.putNonReversibleIfNotNull("%BAMBOO-ENABLED%", "true");
                } else {
                    this.putNonReversibleIfNotNull("%BAMBOO-ENABLED%", "false");
                }
                this.putIfNotNull("%CROWD-BASE-URL%", properties.getCrowdUrl());
                this.putIfNotNull("%CROWD-HOST-URL%", properties.getCrowdHostUrl());
                this.putIfNotNull("%CROWD-CONTEXT%", properties.getCrowdContextPath());
                this.putIfNotNull("%SVN-BASE-URL%", properties.getSvnRoot());
                this.putIfNotNull("%SVN-PUBLIC-URL%", properties.getSvnPublicUrl());
                this.putIfNotNull("%SVN-HOOKS%", properties.getSvnHooks());
                this.putNonReversibleIfNotNull("%STUDIO-DATA-LOCATION%", "");
                this.putIfNotNull("%STUDIO-HOME%", properties.getStudioHome());
                this.putNonReversibleIfNotNull("%GAPPS-ENABLED%", Boolean.toString(properties.isGappsEnabled()));
                if (properties.isGappsEnabled()) {
                    this.putNonReversibleIfNotNull("%GAPPS-ENABLED%", Boolean.toString(true));
                    this.putIfNotNull("%STUDIO-GAPPS-DOMAIN%", properties.getGappsDomain());
                } else {
                    this.putNonReversibleIfNotNull("%GAPPS-ENABLED%", Boolean.toString(false));
                }
                this.putIfNotNull("%STUDIO-WEBDAV-DIRECTORY%", properties.getWebDavHome());
                this.putIfNotNull("%STUDIO-SVN-IMPORT-STAGING-DIRECTORY%", properties.getSvnImportStagingDirectory());
            }

            private void putNonReversibleIfNotNull(String key, String value) {
                if (value != null) {
                    this.add(new ConfigFileUtils.Replacement(key, value, false));
                }
            }

            private void putIfNotNull(String key, String value) {
                if (value != null) {
                    this.add(new ConfigFileUtils.Replacement(key, value));
                }
            }
        });
        return replacements;
    }

    private void createSymlink(String source, File target) throws MojoExecutionException {
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
            this.log.error((CharSequence)"Studio is designed to run on Linux systems. As you can't create a symbolic link for SVN, you will have problems using SVN, FishEye and Bamboo, and possibly the other products.");
            return;
        }
        String[] systemCommand = new String[]{"ln", "-s", source, target.getAbsolutePath()};
        try {
            Process symlinkCreation = Runtime.getRuntime().exec(systemCommand);
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(symlinkCreation.getErrorStream()));
            String errorLine = null;
            boolean hasErrors = false;
            while ((errorLine = errorStream.readLine()) != null) {
                if (!hasErrors) {
                    System.err.println("Error while executing " + systemCommand + ": ");
                    hasErrors = true;
                }
                System.err.println(errorLine);
            }
            if (hasErrors) {
                System.out.println("Please execute this command in your command line and press a key to continue");
                System.in.read();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create the symlink: " + systemCommand, (Exception)e);
        }
    }

    private void extractHome(File target, Product studio) throws MojoExecutionException {
        File testResourcesZip = this.getProductHomeData(studio);
        try {
            if (!testResourcesZip.exists()) {
                throw new MojoExecutionException(String.format("This source doesn't exist: %s", testResourcesZip.getAbsoluteFile()));
            }
            if (testResourcesZip.isDirectory()) {
                FileUtils.copyDirectory((File)testResourcesZip, (File)target);
            } else {
                ZipUtils.unzip(testResourcesZip, target.getAbsolutePath(), 2);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(String.format("Unable to copy/unzip the studio home from %s to %s", testResourcesZip.getAbsolutePath(), target.getAbsolutePath()), (Exception)ioe);
        }
    }

    static void processProductsHomeDirectory(Log log, Product ctx, File homeDir) throws MojoExecutionException {
        if (ctx.getStudioProperties() == null) {
            throw new MojoExecutionException(String.format("%s product is dependant on Studio. You must include the Studio product in your execution.", ctx.getInstanceId()));
        }
    }

    static void addProductHandlerOverrides(Log log, Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        StudioProductHandler.addProductHandlerOverrides(log, ctx, homeDir, explodedWarDir, "WEB-INF/classes/crowd.properties");
    }

    static void addProductHandlerOverrides(Log log, Product ctx, File homeDir, File explodedWarDir, String crowdPropertiesPath) throws MojoExecutionException {
        File crowdProperties = new File(explodedWarDir, crowdPropertiesPath);
        if (StudioProductHandler.checkFileExists(crowdProperties, log)) {
            StudioProductHandler.parametriseCrowdFile(crowdProperties, ctx.getStudioProperties().getCrowdUrl(), log);
        }
    }

    private static void parametriseCrowdFile(File crowdProperties, String crowdUrl, Log log) throws MojoExecutionException {
        ArrayList replacements = Lists.newArrayList();
        replacements.add(new ConfigFileUtils.Replacement("%CROWD-INTERNAL-URL%", crowdUrl));
        replacements.add(new ConfigFileUtils.Replacement("%CROWD-URL%", crowdUrl));
        ConfigFileUtils.replace(crowdProperties, (List<ConfigFileUtils.Replacement>)replacements, false, log);
    }

    @Override
    public void cleanupProductHomeForZip(Product studioProduct, File studioHome) throws MojoExecutionException {
        try {
            StudioProperties studioProperties = studioProduct.getStudioProperties();
            HashMap products = Maps.newHashMap();
            products.put("crowd-home", studioProperties.getCrowd());
            products.put("confluence-home", studioProperties.getConfluence());
            products.put("jira-home", studioProperties.getJira());
            products.put("fecru-home", studioProperties.getFisheye());
            products.put("bamboo-home", studioProperties.getBamboo());
            for (String productHomeName : products.keySet()) {
                Product product = (Product)products.get(productHomeName);
                if (product == null) continue;
                File productDestinationDirectory = new File(studioHome, productHomeName);
                this.copyAndCleanProductHome(product, productDestinationDirectory);
            }
            super.cleanupProductHomeForZip(studioProduct, studioHome);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not copy a product home directory.", (Exception)ioe);
        }
    }

    private void copyAndCleanProductHome(Product product, File productDestinationDirectory) throws IOException, MojoExecutionException {
        ProductHandler handler = ProductHandlerFactory.create(product.getId(), this.context, this.goals);
        File productHomeDirectory = this.getHomeDirectory(product);
        if (productDestinationDirectory.exists()) {
            FileUtils.deleteDirectory((File)productDestinationDirectory);
        }
        ProjectUtils.createDirectory(productDestinationDirectory);
        FileUtils.copyDirectory((File)productHomeDirectory, (File)productDestinationDirectory);
        handler.cleanupProductHomeForZip(product, productDestinationDirectory);
    }

    static String fixWindowsSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    static boolean checkFileExists(File file, Log log) {
        if (!file.exists()) {
            log.warn((CharSequence)String.format("%s does not exist. Will skip customisation", file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static <T> T firstNotNull(T ... values) {
        for (T t : values) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    static {
        defaultContextPaths.put("studio-bamboo", "/builds");
        defaultContextPaths.put("studio-confluence", "/wiki");
        defaultContextPaths.put("studio-crowd", "/crowd");
        defaultContextPaths.put("studio-fecru", "/");
        defaultContextPaths.put("studio-jira", "/jira");
    }
}

