/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.FeCruProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioComponentProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;

public class StudioFeCruProductHandler
extends FeCruProductHandler
implements StudioComponentProductHandler {
    public StudioFeCruProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals);
    }

    @Override
    public String getId() {
        return "studio-fecru";
    }

    @Override
    protected ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.studio", "studio-fisheye", "RELEASE");
    }

    @Override
    public Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> properties = new HashMap<String, String>(super.getSystemProperties(product));
        properties.put("fisheye.dev.mode", "true");
        properties.putAll(product.getStudioProperties().getSystemProperties());
        return properties;
    }

    @Override
    protected void extractProductHomeData(File productHomeData, File homeDir, Product ctx) throws MojoExecutionException {
        try {
            FileUtils.copyDirectory((File)productHomeData, (File)homeDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Can't copy Fisheye's home directory from %s to %s", productHomeData.getAbsolutePath(), homeDir.getAbsolutePath()));
        }
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        replacements.add(new ConfigFileUtils.Replacement("%TEST-CONTROL-BIND%", String.valueOf(this.controlPort(ctx.getHttpPort()))));
        replacements.add(new ConfigFileUtils.Replacement("%TEST-HTTP-BIND%", String.valueOf(this.getDefaultHttpPort())));
        return replacements;
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        StudioProductHandler.addProductHandlerOverrides(this.log, ctx, homeDir, explodedWarDir, "config.xml");
    }

    @Override
    protected void addOverridesToJavaTask(Product ctx, Java java) {
        java.setFork(true);
        java.setDir(this.getAppDirectory(ctx));
    }
}

