/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RefappProductHandler
extends AbstractWebappProductHandler {
    public RefappProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals, new RefappPluginProvider());
    }

    @Override
    public String getId() {
        return "refapp";
    }

    @Override
    public int getDefaultHttpPort() {
        return 5990;
    }

    @Override
    protected File getUserInstalledPluginsDirectory(File webappDir, File homeDir) {
        return null;
    }

    @Override
    protected List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    protected String getBundledPluginPath(Product ctx) {
        return "WEB-INF/classes/atlassian-bundled-plugins.zip";
    }

    protected List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    protected List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    protected Map<String, String> getSystemProperties(Product ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refapp.home", this.getHomeDirectory(ctx).getPath());
        map.put("osgi.cache", this.getHomeDirectory(ctx).getPath() + "/osgi-cache");
        map.put("bundledplugins.cache", this.getHomeDirectory(ctx).getPath() + "/bundled-plugins");
        return map;
    }

    @Override
    protected ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.refapp", "atlassian-refapp", VersionUtils.getVersion());
    }

    @Override
    protected ProductArtifact getTestResourcesArtifact() {
        return null;
    }

    private static class RefappPluginProvider
    extends AbstractPluginProvider {
        private RefappPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-appproperties-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-component-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-executor-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-lifecycle-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-message-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-net-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-pluginsettings-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-project-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-search-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-transaction-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-upgrade-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-user-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            return Collections.emptyList();
        }
    }
}

