/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.studio.StudioProperties;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Product {
    protected String containerId;
    private int httpPort = 0;
    protected String contextPath;
    protected String server;
    protected String version;
    protected String jvmArgs = null;
    protected File log4jProperties;
    protected String productDataVersion;
    protected String productDataPath = "";
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    private String salVersion;
    private String pdkVersion;
    private String restVersion;
    private String webConsoleVersion;
    private Boolean enableFastdev;
    private String fastdevVersion;
    private String id;
    private String instanceId;
    private ArtifactRetriever artifactRetriever;
    private Boolean installPlugin;
    private Map<String, Object> systemProperties = new HashMap<String, Object>();
    private String output;
    private int jvmDebugPort;
    private int startupTimeout = 0;
    private int shutdownTimeout = 0;
    private String groupId;
    private String artifactId;
    protected StudioProperties studioProperties;
    protected List<String> instanceIds = new ArrayList<String>();
    protected String gappsEnabled;
    protected String gappsDomain;

    public Product merge(Product product) {
        Product prod = new Product();
        prod.setOutput(this.output == null ? product.getOutput() : this.output);
        HashMap<String, Object> sysProps = new HashMap<String, Object>();
        sysProps.putAll(product.getSystemPropertyVariables());
        sysProps.putAll(this.systemProperties);
        prod.setSystemPropertyVariables(sysProps);
        prod.setInstallPlugin(this.installPlugin == null ? product.isInstallPlugin() : this.installPlugin);
        prod.setArtifactRetriever(this.artifactRetriever == null ? product.getArtifactRetriever() : this.artifactRetriever);
        prod.setId(this.id == null ? product.getId() : this.id);
        prod.setInstanceId(this.instanceId == null ? product.getInstanceId() : this.instanceId);
        prod.setWebConsoleVersion(this.webConsoleVersion == null ? product.getWebConsoleVersion() : this.webConsoleVersion);
        prod.setEnableFastdev(this.enableFastdev == null ? product.isEnableFastdev() : this.enableFastdev);
        prod.setFastdevVersion(this.fastdevVersion == null ? product.getFastdevVersion() : this.fastdevVersion);
        prod.setRestVersion(this.restVersion == null ? product.getRestVersion() : this.restVersion);
        prod.setPdkVersion(this.pdkVersion == null ? product.getPdkVersion() : this.pdkVersion);
        prod.setSalVersion(this.salVersion == null ? product.getSalVersion() : this.salVersion);
        prod.setBundledArtifacts(this.bundledArtifacts.isEmpty() ? product.getBundledArtifacts() : this.bundledArtifacts);
        prod.setPluginArtifacts(this.pluginArtifacts.isEmpty() ? product.getPluginArtifacts() : this.pluginArtifacts);
        prod.setLibArtifacts(this.libArtifacts.isEmpty() ? product.getLibArtifacts() : this.libArtifacts);
        prod.setDataPath(this.productDataPath.length() == 0 ? product.getDataPath() : this.productDataPath);
        prod.setDataVersion(this.productDataVersion == null ? product.getDataVersion() : this.productDataVersion);
        prod.setLog4jProperties(this.log4jProperties == null ? product.getLog4jProperties() : this.log4jProperties);
        prod.setJvmArgs(this.jvmArgs == null ? product.getJvmArgs() : this.jvmArgs);
        prod.setVersion(this.groupId == null ? product.getGroupId() : this.groupId);
        prod.setVersion(this.artifactId == null ? product.getArtifactId() : this.artifactId);
        prod.setVersion(this.version == null ? product.getVersion() : this.version);
        prod.setServer(this.server == null ? product.getServer() : this.server);
        prod.setContextPath(this.contextPath == null ? product.getContextPath() : this.contextPath);
        prod.setContainerId(this.containerId == null ? product.getContainerId() : this.containerId);
        prod.setHttpPort(this.httpPort == 0 ? product.getHttpPort() : this.httpPort);
        prod.setJvmDebugPort(this.jvmDebugPort == 0 ? product.getJvmDebugPort() : this.jvmDebugPort);
        prod.setStartupTimeout(this.startupTimeout == 0 ? product.getStartupTimeout() : this.startupTimeout);
        prod.setShutdownTimeout(this.shutdownTimeout == 0 ? product.getShutdownTimeout() : this.shutdownTimeout);
        prod.setStudioProperties(this.studioProperties == null ? product.getStudioProperties() : this.studioProperties);
        prod.setInstanceIds(this.instanceIds == null ? product.getInstanceIds() : this.instanceIds);
        return prod;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public ArtifactRetriever getArtifactRetriever() {
        return this.artifactRetriever;
    }

    public void setArtifactRetriever(ArtifactRetriever artifactRetriever) {
        this.artifactRetriever = artifactRetriever;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDataVersion() {
        return this.productDataVersion;
    }

    public void setDataVersion(String productDataVersion) {
        this.productDataVersion = productDataVersion;
    }

    public String getProductDataVersion() {
        return this.productDataVersion;
    }

    public void setProductDataVersion(String productDataVersion) {
        this.productDataVersion = productDataVersion;
    }

    public String getDataPath() {
        return this.productDataPath;
    }

    public void setDataPath(String productDataPath) {
        this.productDataPath = productDataPath;
    }

    public String getProductDataPath() {
        return this.productDataPath;
    }

    public void setProductDataPath(String productDataPath) {
        this.productDataPath = productDataPath;
    }

    public List<ProductArtifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List<ProductArtifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public List<ProductArtifact> getLibArtifacts() {
        return this.libArtifacts;
    }

    public void setLibArtifacts(List<ProductArtifact> libArtifacts) {
        this.libArtifacts = libArtifacts;
    }

    public List<ProductArtifact> getBundledArtifacts() {
        return this.bundledArtifacts;
    }

    public void setBundledArtifacts(List<ProductArtifact> bundledArtifacts) {
        this.bundledArtifacts = bundledArtifacts;
    }

    public File getLog4jProperties() {
        return this.log4jProperties;
    }

    public void setLog4jProperties(File log4jProperties) {
        this.log4jProperties = log4jProperties;
    }

    public String getRestVersion() {
        return this.restVersion;
    }

    public void setRestVersion(String restVersion) {
        this.restVersion = restVersion;
    }

    public String getSalVersion() {
        return this.salVersion;
    }

    public void setSalVersion(String salVersion) {
        this.salVersion = salVersion;
    }

    public String getPdkVersion() {
        return this.pdkVersion;
    }

    public void setPdkVersion(String pdkVersion) {
        this.pdkVersion = pdkVersion;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Boolean isInstallPlugin() {
        return this.installPlugin;
    }

    public void setInstallPlugin(Boolean installPlugin) {
        this.installPlugin = installPlugin;
    }

    public String getWebConsoleVersion() {
        return this.webConsoleVersion;
    }

    public Boolean isEnableFastdev() {
        return this.enableFastdev;
    }

    public void setEnableFastdev(Boolean enableFastdev) {
        this.enableFastdev = enableFastdev;
    }

    public String getFastdevVersion() {
        return this.fastdevVersion;
    }

    public void setFastdevVersion(String fastdevVersion) {
        this.fastdevVersion = fastdevVersion;
    }

    public void setWebConsoleVersion(String webConsoleVersion) {
        this.webConsoleVersion = webConsoleVersion;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties.putAll(systemProperties);
    }

    public Properties getSystemProperties() {
        Properties props = new Properties();
        props.putAll(this.systemProperties);
        return props;
    }

    public void setSystemPropertyVariables(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, Object> getSystemPropertyVariables() {
        return this.systemProperties;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public int getJvmDebugPort() {
        return this.jvmDebugPort;
    }

    public void setJvmDebugPort(int jvmDebugPort) {
        this.jvmDebugPort = jvmDebugPort;
    }

    public int getStartupTimeout() {
        return this.startupTimeout;
    }

    public void setStartupTimeout(int startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public StudioProperties getStudioProperties() {
        return this.studioProperties;
    }

    public void setStudioProperties(StudioProperties studioProperties) {
        this.studioProperties = studioProperties;
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public String getGappsEnabled() {
        return this.gappsEnabled;
    }

    public void setGappsEnabled(String gappsEnabled) {
        this.gappsEnabled = gappsEnabled;
    }

    public String getGappsDomain() {
        return this.gappsDomain;
    }

    public void setGappsDomain(String gappsDomain) {
        this.gappsDomain = gappsDomain;
    }

    public void setSystemProperties(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String toString() {
        return "Product " + this.id + " [instanceId=" + this.instanceId + ", localhost:" + this.httpPort + this.contextPath + "]";
    }
}

