/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.core.util.FileUtils;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.PluginInformation;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.util.PluginXmlUtils;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.sun.jersey.wadl.resourcedoc.ResourceDocletJSON;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenGoals {
    private final MavenContext ctx;
    private final Log log;
    private final Map<String, String> pluginArtifactIdToVersionMap;
    private final Map<String, Container> idToContainerMap = new HashMap<String, Container>(){
        {
            this.put("tomcat5x", new Container("tomcat5x", "org.apache.tomcat", "apache-tomcat", "5.5.26"));
            this.put("tomcat6x", new Container("tomcat6x", "org.apache.tomcat", "apache-tomcat", "6.0.20"));
            this.put("resin3x", new Container("resin3x", "com.caucho", "resin", "3.0.26"));
            this.put("jboss42x", new Container("jboss42x", "org.jboss.jbossas", "jbossas", "4.2.3.GA"));
            this.put("jetty6x", new Container("jetty6x"));
        }
    };
    private final Map<String, String> defaultArtifactIdToVersionMap = new HashMap<String, String>(){
        {
            this.put("maven-cli-plugin", "0.7");
            this.put("cargo-maven2-plugin", "1.0-beta-2-db2");
            this.put("atlassian-pdk", "2.1.8");
            this.put("maven-archetype-plugin", "2.0-alpha-4");
            this.put("maven-bundle-plugin", "2.0.0");
            this.put("yuicompressor-maven-plugin", "0.7.1");
            this.put("build-helper-maven-plugin", "1.7");
            this.put("maven-dependency-plugin", "2.0");
            this.put("maven-resources-plugin", "2.3");
            this.put("maven-jar-plugin", "2.2");
            this.put("maven-surefire-plugin", "2.4.3");
        }
    };

    public MavenGoals(MavenContext ctx) {
        this(ctx, Collections.emptyMap());
    }

    public MavenGoals(MavenContext ctx, Map<String, String> pluginToVersionMap) {
        this.ctx = ctx;
        this.log = ctx.getLog();
        HashMap<String, String> map = new HashMap<String, String>(this.defaultArtifactIdToVersionMap);
        map.putAll(pluginToVersionMap);
        this.pluginArtifactIdToVersionMap = Collections.unmodifiableMap(map);
    }

    private MojoExecutor.ExecutionEnvironment executionEnvironment() {
        return this.ctx.getExecutionEnvironment();
    }

    public MavenProject getContextProject() {
        return this.ctx.getProject();
    }

    public void executeAmpsRecursively(String ampsVersion, String ampsGoal, Xpp3Dom cfg) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("maven-amps-plugin"), MojoExecutor.version(ampsVersion)), MojoExecutor.goal(ampsGoal), cfg, this.executionEnvironment());
    }

    public void startCli(PluginInformation pluginInformation, int port) throws MojoExecutionException {
        String pluginId = pluginInformation.getId();
        ArrayList<MojoExecutor.Element> configs = new ArrayList<MojoExecutor.Element>();
        configs.add(MojoExecutor.element(MojoExecutor.name("commands"), MojoExecutor.element(MojoExecutor.name("pi"), "resources com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:filter-plugin-descriptor" + " " + "compile" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:copy-bundled-dependencies" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:compress-resources" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:generate-manifest" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:validate-manifest" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:jar" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:install"), MojoExecutor.element(MojoExecutor.name("tpi"), "testResources testCompile com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:test-jar" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:test-install"), MojoExecutor.element(MojoExecutor.name("package"), "resources com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:filter-plugin-descriptor" + " " + "compile" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:copy-bundled-dependencies" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:generate-manifest" + " " + "com.atlassian.maven.plugins:maven-" + pluginId + "-plugin:jar" + " ")));
        if (port > 0) {
            configs.add(MojoExecutor.element(MojoExecutor.name("port"), String.valueOf(port)));
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("maven-cli-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("maven-cli-plugin"))), MojoExecutor.goal("execute"), MojoExecutor.configuration(configs.toArray(new MojoExecutor.Element[0])), this.executionEnvironment());
    }

    public void createPlugin(String productId) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-archetype-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-archetype-plugin"))), MojoExecutor.goal("generate"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archetypeGroupId"), "com.atlassian.maven.archetypes"), MojoExecutor.element(MojoExecutor.name("archetypeArtifactId"), productId + "-plugin-archetype"), MojoExecutor.element(MojoExecutor.name("archetypeVersion"), VersionUtils.getVersion())), this.executionEnvironment());
    }

    public void copyBundledDependencies() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    public void extractBundledDependencies() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludes"), "META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")), this.executionEnvironment());
    }

    public void compressResources() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("net.sf.alchim"), MojoExecutor.artifactId("yuicompressor-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("yuicompressor-maven-plugin"))), MojoExecutor.goal("compress"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("suffix"), "-min"), MojoExecutor.element(MojoExecutor.name("jswarn"), "false")), this.executionEnvironment());
    }

    public void filterPluginDescriptor() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-resources-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-resources-plugin"))), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/main/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")), this.executionEnvironment());
    }

    public void runUnitTests(Map<String, Object> systemProperties) throws MojoExecutionException {
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-surefire-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-surefire-plugin"))), MojoExecutor.goal("test"), MojoExecutor.configuration(systemProps, MojoExecutor.element(MojoExecutor.name("excludes"), MojoExecutor.element(MojoExecutor.name("exclude"), "it/**"), MojoExecutor.element(MojoExecutor.name("exclude"), "**/*$*"))), this.executionEnvironment());
    }

    public File copyWebappWar(String productId, File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        File webappWarFile = new File(targetDirectory, productId + "-original.war");
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), webappWarFile.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath())), this.executionEnvironment());
        return webappWarFile;
    }

    public void copyPlugins(File outputDirectory, List<ProductArtifact> artifacts) throws MojoExecutionException {
        for (ProductArtifact artifact : artifacts) {
            MavenProject artifactReactorProject = this.getReactorProjectForArtifact(artifact);
            if (artifactReactorProject != null) {
                this.log.debug((CharSequence)(artifact + " will be copied from reactor project " + artifactReactorProject));
                File artifactFile = artifactReactorProject.getArtifact().getFile();
                if (artifactFile == null) {
                    this.log.warn((CharSequence)("The plugin " + artifact + " is in the reactor but not the file hasn't been attached.  Skipping."));
                    continue;
                }
                this.log.debug((CharSequence)("Copying " + artifactFile + " to " + outputDirectory));
                try {
                    FileUtils.copyFile((File)artifactFile, (File)new File(outputDirectory, artifactFile.getName()));
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy " + artifact + " to " + outputDirectory, (Exception)e);
                }
            }
            MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), outputDirectory.getPath())), this.executionEnvironment());
        }
    }

    private MavenProject getReactorProjectForArtifact(ProductArtifact artifact) {
        for (MavenProject project : this.ctx.getReactor()) {
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId()) || !project.getVersion().equals(artifact.getVersion())) continue;
            return project;
        }
        return null;
    }

    private void unpackContainer(Container container) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), container.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), container.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), container.getVersion()), MojoExecutor.element(MojoExecutor.name("type"), "zip"))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), container.getRootDirectory(this.getBuildDirectory()))), this.executionEnvironment());
    }

    private String getBuildDirectory() {
        return this.ctx.getProject().getBuild().getDirectory();
    }

    public int startWebapp(String productInstanceId, File war, Map<String, String> systemProperties, List<ProductArtifact> extraContainerDependencies, Product webappContext) throws MojoExecutionException {
        Container container = this.findContainer(webappContext.getContainerId());
        File containerDir = new File(container.getRootDirectory(this.getBuildDirectory()));
        if (!container.isEmbedded()) {
            if (containerDir.exists()) {
                this.log.info((CharSequence)("Reusing unpacked container '" + container.getId() + "' from " + containerDir.getPath()));
            } else {
                this.log.info((CharSequence)("Unpacking container '" + container.getId() + "' from container artifact: " + container.toString()));
                this.unpackContainer(container);
            }
        }
        int rmiPort = this.pickFreePort(0);
        int actualHttpPort = this.pickFreePort(webappContext.getHttpPort());
        ArrayList<MojoExecutor.Element> sysProps = new ArrayList<MojoExecutor.Element>();
        if (webappContext.getJvmArgs() == null) {
            webappContext.setJvmArgs("-Xmx512m -XX:MaxPermSize=160m");
        }
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            webappContext.setJvmArgs(webappContext.getJvmArgs() + " -D" + entry.getKey() + "=\"" + entry.getValue() + "\"");
            sysProps.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue()));
        }
        this.log.info((CharSequence)("Starting " + productInstanceId + " on the " + container.getId() + " container on ports " + actualHttpPort + " (http) and " + rmiPort + " (rmi)"));
        String baseUrl = MavenGoals.getBaseUrl(webappContext.getServer(), actualHttpPort, webappContext.getContextPath());
        sysProps.add(MojoExecutor.element(MojoExecutor.name("baseurl"), baseUrl));
        ArrayList<MojoExecutor.Element> deps = new ArrayList<MojoExecutor.Element>();
        for (ProductArtifact dep : extraContainerDependencies) {
            deps.add(MojoExecutor.element(MojoExecutor.name("dependency"), MojoExecutor.element(MojoExecutor.name("location"), webappContext.getArtifactRetriever().resolve(dep))));
        }
        ArrayList<MojoExecutor.Element> props = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            props.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), String.valueOf(actualHttpPort)));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.rmi.port"), String.valueOf(rmiPort)));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.jvmargs"), webappContext.getJvmArgs()));
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("cargo-maven2-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("cargo-maven2-plugin"))), MojoExecutor.goal("start"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("wait"), "false"), MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("home"), container.getInstallDirectory(this.getBuildDirectory())), MojoExecutor.element(MojoExecutor.name("output"), webappContext.getOutput()), MojoExecutor.element(MojoExecutor.name("systemProperties"), sysProps.toArray(new MojoExecutor.Element[sysProps.size()])), MojoExecutor.element(MojoExecutor.name("dependencies"), deps.toArray(new MojoExecutor.Element[deps.size()])), MojoExecutor.element(MojoExecutor.name("timeout"), String.valueOf(webappContext.getStartupTimeout()))), MojoExecutor.element(MojoExecutor.name("configuration"), MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(this.getBuildDirectory(), productInstanceId)), MojoExecutor.element(MojoExecutor.name("type"), "standalone"), MojoExecutor.element(MojoExecutor.name("properties"), props.toArray(new MojoExecutor.Element[props.size()])), MojoExecutor.element(MojoExecutor.name("deployables"), MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), "foo"), MojoExecutor.element(MojoExecutor.name("artifactId"), "bar"), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("location"), war.getPath()), MojoExecutor.element(MojoExecutor.name("properties"), MojoExecutor.element(MojoExecutor.name("context"), webappContext.getContextPath())))))), this.executionEnvironment());
        return actualHttpPort;
    }

    public static String getBaseUrl(String server, int actualHttpPort, String contextPath) {
        if (server.startsWith("http")) {
            return server + ":" + actualHttpPort + contextPath;
        }
        return "http://" + server + ":" + actualHttpPort + contextPath;
    }

    public void runTests(String productId, String containerId, List<String> includes, List<String> excludes, Map<String, Object> systemProperties, File targetDirectory) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> includeElements = new ArrayList<MojoExecutor.Element>(includes.size());
        for (String include : includes) {
            includeElements.add(MojoExecutor.element(MojoExecutor.name("include"), include));
        }
        ArrayList<MojoExecutor.Element> excludeElements = new ArrayList<MojoExecutor.Element>(excludes.size() + 2);
        excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), "**/*$*"));
        excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), "**/Abstract*"));
        for (String exclude : excludes) {
            excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), exclude));
        }
        String testOutputDir = targetDirectory.getAbsolutePath() + "/" + productId + "/" + containerId + "/surefire-reports";
        String reportsDirectory = "reportsDirectory";
        systemProperties.put("reportsDirectory", testOutputDir);
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-surefire-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-surefire-plugin"))), MojoExecutor.goal("test"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includes"), includeElements.toArray(new MojoExecutor.Element[includeElements.size()])), MojoExecutor.element(MojoExecutor.name("excludes"), excludeElements.toArray(new MojoExecutor.Element[excludeElements.size()])), systemProps, MojoExecutor.element(MojoExecutor.name("reportsDirectory"), testOutputDir)), this.executionEnvironment());
    }

    private MojoExecutor.Element convertPropsToElements(Map<String, Object> systemProperties) {
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, Object> entry : systemProperties.entrySet()) {
            properties.add(MojoExecutor.element(MojoExecutor.name("property"), MojoExecutor.element(MojoExecutor.name("name"), entry.getKey()), MojoExecutor.element(MojoExecutor.name("value"), entry.getValue().toString())));
        }
        return MojoExecutor.element(MojoExecutor.name("systemProperties"), properties.toArray(new MojoExecutor.Element[properties.size()]));
    }

    private Container findContainer(String containerId) {
        Container container = this.idToContainerMap.get(containerId);
        if (container == null) {
            throw new IllegalArgumentException("Container " + containerId + " not supported");
        }
        return container;
    }

    int pickFreePort(int requestedPort) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(requestedPort);
            int n = requestedPort > 0 ? requestedPort : socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            ServerSocket zeroSocket = null;
            try {
                zeroSocket = new ServerSocket(0);
                int n = zeroSocket.getLocalPort();
                return n;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error opening socket", ex);
            }
            finally {
                this.closeSocket(zeroSocket);
            }
        }
        finally {
            this.closeSocket(socket);
        }
    }

    private void closeSocket(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing socket", e);
            }
        }
    }

    public void stopWebapp(String productId, String containerId, Product webappContext) throws MojoExecutionException {
        Container container = this.findContainer(containerId);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("cargo-maven2-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("cargo-maven2-plugin"))), MojoExecutor.goal("stop"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("timeout"), String.valueOf(webappContext.getShutdownTimeout()))), MojoExecutor.element(MojoExecutor.name("configuration"), MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(this.getBuildDirectory(), productId)))), this.executionEnvironment());
    }

    public void installPlugin(PdkParams pdkParams) throws MojoExecutionException {
        String baseUrl = MavenGoals.getBaseUrl(pdkParams.getServer(), pdkParams.getPort(), pdkParams.getContextPath());
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("atlassian-pdk"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("atlassian-pdk"))), MojoExecutor.goal("install"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("pluginFile"), pdkParams.getPluginFile()), MojoExecutor.element(MojoExecutor.name("username"), pdkParams.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), pdkParams.getPassword()), MojoExecutor.element(MojoExecutor.name("serverUrl"), baseUrl), MojoExecutor.element(MojoExecutor.name("pluginKey"), pdkParams.getPluginKey())), this.executionEnvironment());
    }

    public void uninstallPlugin(String pluginKey, String server, int port, String contextPath) throws MojoExecutionException {
        String baseUrl = MavenGoals.getBaseUrl(server, port, contextPath);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("atlassian-pdk"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("atlassian-pdk"))), MojoExecutor.goal("uninstall"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("username"), "admin"), MojoExecutor.element(MojoExecutor.name("password"), "admin"), MojoExecutor.element(MojoExecutor.name("serverUrl"), baseUrl), MojoExecutor.element(MojoExecutor.name("pluginKey"), pluginKey)), this.executionEnvironment());
    }

    public void installIdeaPlugin() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("maven-cli-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("maven-cli-plugin"))), MojoExecutor.goal("idea"), MojoExecutor.configuration(new MojoExecutor.Element[0]), this.executionEnvironment());
    }

    public File copyDist(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        return this.copyZip(targetDirectory, artifact, "test-dist.zip");
    }

    public File copyHome(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        return this.copyZip(targetDirectory, artifact, artifact.getArtifactId() + ".zip");
    }

    public File copyZip(File targetDirectory, ProductArtifact artifact, String localName) throws MojoExecutionException {
        File artifactZip = new File(targetDirectory, localName);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "zip"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), artifactZip.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), artifactZip.getParent())), this.executionEnvironment());
        return artifactZip;
    }

    public void generateManifest(Map<String, String> instructions) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.felix"), MojoExecutor.artifactId("maven-bundle-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-bundle-plugin"))), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[instlist.size()]))), this.executionEnvironment());
    }

    public void jarWithOptionalManifest(boolean manifestExists) throws MojoExecutionException {
        MojoExecutor.Element[] archive = new MojoExecutor.Element[]{};
        if (manifestExists) {
            archive = new MojoExecutor.Element[]{MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.outputDirectory}/META-INF/MANIFEST.MF")};
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-jar-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-jar-plugin"))), MojoExecutor.goal("jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archive"), archive)), this.executionEnvironment());
    }

    public void jarTests(String finalName) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-jar-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-jar-plugin"))), MojoExecutor.goal("test-jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("finalName"), finalName), MojoExecutor.element(MojoExecutor.name("archive"), MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.testOutputDirectory}/META-INF/MANIFEST.MF"))), this.executionEnvironment());
    }

    public void generateObrXml(File dep, File obrXml) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.felix"), MojoExecutor.artifactId("maven-bundle-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-bundle-plugin"))), MojoExecutor.goal("install-file"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("obrRepository"), obrXml.getPath()), MojoExecutor.element(MojoExecutor.name("groupId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("artifactId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("version"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("packaging"), "jar"), MojoExecutor.element(MojoExecutor.name("file"), dep.getPath())), this.executionEnvironment());
    }

    public void attachArtifact(File file, String type) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("build-helper-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("build-helper-maven-plugin"))), MojoExecutor.goal("attach-artifact"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifacts"), MojoExecutor.element(MojoExecutor.name("artifact"), MojoExecutor.element(MojoExecutor.name("file"), file.getAbsolutePath()), MojoExecutor.element(MojoExecutor.name("type"), type)))), this.executionEnvironment());
    }

    public void release() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-release-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-release-plugin"))), MojoExecutor.goal("prepare"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), "")), this.executionEnvironment());
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-release-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-release-plugin"))), MojoExecutor.goal("perform"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), "")), this.executionEnvironment());
    }

    public void generateRestDocs() throws MojoExecutionException {
        MavenProject prj = this.ctx.getProject();
        ArrayList docletPaths = new ArrayList();
        StringBuffer docletPath = new StringBuffer(":" + prj.getBuild().getOutputDirectory());
        String resourcedocPath = prj.getBuild().getOutputDirectory() + File.separator + "resourcedoc.xml";
        StringBuffer packagesPath = new StringBuffer();
        PluginXmlUtils.PluginInfo pluginInfo = PluginXmlUtils.getPluginInfo(this.ctx);
        try {
            docletPaths.addAll(prj.getCompileClasspathElements());
            docletPaths.addAll(prj.getRuntimeClasspathElements());
            docletPaths.addAll(prj.getSystemClasspathElements());
            for (String path : docletPaths) {
                docletPath.append(File.pathSeparator);
                docletPath.append(path);
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependencies must be resolved", (Exception)((Object)e));
        }
        List<PluginXmlUtils.RESTModuleInfo> restModules = PluginXmlUtils.getRestModules(this.ctx);
        for (PluginXmlUtils.RESTModuleInfo moduleInfo : restModules) {
            List<String> packageList = moduleInfo.getPackagesToScan();
            for (String packageToScan : packageList) {
                if (packagesPath.length() > 0) {
                    packagesPath.append(File.pathSeparator);
                }
                String filePath = prj.getBuild().getSourceDirectory() + File.separator + packageToScan.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                packagesPath.append(filePath);
            }
        }
        if (!restModules.isEmpty() && packagesPath.length() > 0) {
            MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-javadoc-plugin"), MojoExecutor.version("2.4")), MojoExecutor.goal("javadoc"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("maxmemory"), "1024m"), MojoExecutor.element(MojoExecutor.name("sourcepath"), packagesPath.toString()), MojoExecutor.element(MojoExecutor.name("doclet"), ResourceDocletJSON.class.getName()), MojoExecutor.element(MojoExecutor.name("docletPath"), docletPath.toString()), MojoExecutor.element(MojoExecutor.name("docletArtifacts"), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "xerces"), MojoExecutor.element(MojoExecutor.name("artifactId"), "xercesImpl"), MojoExecutor.element(MojoExecutor.name("version"), "2.9.1")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("artifactId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("version"), "2.6"))), MojoExecutor.element(MojoExecutor.name("additionalparam"), "-output \"" + resourcedocPath + "\""), MojoExecutor.element(MojoExecutor.name("useStandarDocletOptions"), "false")), this.executionEnvironment());
            try {
                File userGrammars;
                File userAppDocs = new File(prj.getBuild().getOutputDirectory(), "application-doc.xml");
                if (!userAppDocs.exists()) {
                    String appDocText = FileUtils.getResourceContent((String)"application-doc.xml");
                    appDocText = StringUtils.replace((String)appDocText, (String)"${rest.doc.title}", (String)pluginInfo.getName());
                    appDocText = StringUtils.replace((String)appDocText, (String)"${rest.doc.description}", (String)pluginInfo.getDescription());
                    File appDocFile = new File(prj.getBuild().getOutputDirectory(), "application-doc.xml");
                    FileUtils.saveTextFile((String)appDocText, (File)appDocFile);
                    this.log.info((CharSequence)("Wrote " + appDocFile.getAbsolutePath()));
                }
                if (!(userGrammars = new File(prj.getBuild().getOutputDirectory(), "application-grammars.xml")).exists()) {
                    String grammarText = FileUtils.getResourceContent((String)"application-grammars.xml");
                    File grammarFile = new File(prj.getBuild().getOutputDirectory(), "application-grammars.xml");
                    FileUtils.saveTextFile((String)grammarText, (File)grammarFile);
                    this.log.info((CharSequence)("Wrote " + grammarFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error writing REST application xml files", e);
            }
        }
    }

    private static class Container
    extends ProductArtifact {
        private final String id;
        private final String type;

        public Container(String id, String groupId, String artifactId, String version) {
            super(groupId, artifactId, version);
            this.id = id;
            this.type = "installed";
        }

        public Container(String id) {
            this.id = id;
            this.type = "embedded";
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public boolean isEmbedded() {
            return "embedded".equals(this.type);
        }

        public String getRootDirectory(String buildDir) {
            return buildDir + File.separator + "container" + File.separator + this.getId();
        }

        public String getInstallDirectory(String buildDir) {
            return this.getRootDirectory(buildDir) + File.separator + this.getArtifactId() + "-" + this.getVersion();
        }

        public String getConfigDirectory(String buildDir, String productId) {
            return this.getRootDirectory(buildDir) + File.separator + "cargo-" + productId + "-home";
        }
    }
}

