/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerAwareMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

public abstract class AbstractProductHandlerMojo
extends AbstractProductHandlerAwareMojo {
    private static final String DEFAULT_CONTAINER = "tomcat6x";
    private static final String DEFAULT_SERVER = "localhost";
    private static final String DEFAULT_PRODUCT_DATA_VERSION = "LATEST";
    private static final String DEFAULT_PDK_VERSION = "0.4";
    private static final String DEFAULT_WEB_CONSOLE_VERSION = "1.2.8";
    private static final String DEFAULT_FASTDEV_VERSION = "1.8";
    private static final int DEFAULT_PRODUCT_STARTUP_TIMEOUT = 180000;
    private static final int DEFAULT_PRODUCT_SHUTDOWN_TIMEOUT = 180000;
    @MojoParameter(expression="${container}", defaultValue="tomcat6x")
    protected String containerId;
    @MojoParameter(expression="${http.port}", defaultValue="0")
    private int httpPort;
    @MojoParameter(expression="${context.path}")
    protected String contextPath;
    @MojoParameter(expression="${server}", defaultValue="localhost")
    protected String server;
    @MojoParameter(expression="${product.version}")
    private String productVersion;
    @MojoParameter(expression="${jvmargs}")
    protected String jvmArgs;
    @MojoParameter(expression="${product.start.timeout}")
    private int startupTimeout;
    @MojoParameter(expression="${product.stop.timeout}")
    private int shutdownTimeout;
    @MojoParameter
    @Deprecated
    protected Properties systemProperties = new Properties();
    @MojoParameter
    protected Map<String, Object> systemPropertyVariables = new HashMap<String, Object>();
    @MojoParameter
    protected File log4jProperties;
    @MojoParameter(expression="${test.resources.version}")
    private String testResourcesVersion;
    @MojoParameter(expression="${product.data.version}", defaultValue="LATEST")
    private String productDataVersion;
    @MojoParameter(expression="${product.data.path}")
    private String productDataPath;
    @MojoParameter(expression="${fastdev.enable}", defaultValue="true")
    protected boolean enableFastdev;
    @MojoParameter(expression="${fastdev.version}", defaultValue="1.8")
    protected String fastdevVersion;
    @MojoParameter
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private String salVersion;
    @MojoParameter(defaultValue="0.4")
    private String pdkVersion;
    @MojoParameter
    private String restVersion;
    @MojoParameter(defaultValue="1.2.8")
    private String webConsoleVersion;
    @MojoParameter(expression="${plugins}")
    private String pluginArtifactsString;
    @MojoParameter(expression="${lib.plugins}")
    private String libArtifactsString;
    @MojoParameter(expression="${bundled.plugins}")
    private String bundledArtifactsString;
    @MojoParameter(expression="${project.build.directory}", required=true)
    protected File targetDirectory;
    @MojoParameter(expression="${project.build.finalName}", required=true)
    protected String finalName;
    @MojoParameter(expression="${install.plugin}", defaultValue="true")
    protected boolean installPlugin;
    @MojoComponent
    protected ArtifactResolver artifactResolver;
    @MojoParameter(expression="${localRepository}")
    protected ArtifactRepository localRepository;
    @MojoParameter(expression="${project.remoteArtifactRepositories}")
    protected List repositories;
    @MojoComponent
    protected ArtifactFactory artifactFactory;
    @MojoParameter
    protected List<Product> products = new ArrayList<Product>();
    @MojoParameter
    private String output;

    protected Product createDefaultProductContext() throws MojoExecutionException {
        Product ctx = new Product();
        ctx.setId(this.getProductId());
        ctx.setContainerId(this.containerId);
        ctx.setServer(this.server);
        ctx.setContextPath(this.contextPath);
        ctx.setJvmArgs(this.jvmArgs);
        ctx.setStartupTimeout(this.startupTimeout);
        ctx.setShutdownTimeout(this.shutdownTimeout);
        AbstractProductHandlerMojo.setDefaultSystemProperty(this.systemPropertyVariables, "atlassian.dev.mode", "true");
        AbstractProductHandlerMojo.setDefaultSystemProperty(this.systemPropertyVariables, "java.awt.headless", "true");
        AbstractProductHandlerMojo.setDefaultSystemProperty(this.systemPropertyVariables, "plugin.resource.directories", this.buildResourcesList());
        AbstractProductHandlerMojo.setDefaultSystemProperty(this.systemPropertyVariables, "plugin.root.directories", this.buildRootProperty());
        ctx.setSystemPropertyVariables(this.systemPropertyVariables);
        ctx.setBundledArtifacts(this.bundledArtifacts);
        ctx.setLibArtifacts(this.libArtifacts);
        ctx.setPluginArtifacts(this.pluginArtifacts);
        ctx.setLog4jProperties(this.log4jProperties);
        ctx.setHttpPort(this.httpPort);
        ctx.setVersion(this.productVersion);
        ctx.setDataVersion(this.productDataVersion);
        ctx.setDataPath(this.productDataPath);
        ctx.setRestVersion(this.restVersion);
        ctx.setSalVersion(this.salVersion);
        ctx.setPdkVersion(this.pdkVersion);
        ctx.setWebConsoleVersion(this.webConsoleVersion);
        ctx.setEnableFastdev(this.enableFastdev);
        ctx.setFastdevVersion(this.fastdevVersion);
        ctx.setHttpPort(this.httpPort);
        return ctx;
    }

    private String buildResourcesList() {
        StringBuilder resourceProp = new StringBuilder();
        MavenProject mavenProject = this.getMavenContext().getProject();
        List resList = mavenProject.getResources();
        for (int i = 0; i < resList.size(); ++i) {
            resourceProp.append(((Resource)resList.get(i)).getDirectory());
            if (i + 1 == resList.size()) continue;
            resourceProp.append(",");
        }
        if (ProjectUtils.shouldDeployTestJar(this.getMavenContext())) {
            List testResList = mavenProject.getTestResources();
            for (int i = 0; i < testResList.size(); ++i) {
                if (i == 0 && resourceProp.length() > 0) {
                    resourceProp.append(",");
                }
                resourceProp.append(((Resource)testResList.get(i)).getDirectory());
                if (i + 1 == testResList.size()) continue;
                resourceProp.append(",");
            }
        }
        return resourceProp.toString();
    }

    private String buildRootProperty() {
        MavenProject mavenProject = this.getMavenContext().getProject();
        return mavenProject.getBasedir().getPath();
    }

    private static void setDefaultSystemProperty(Map<String, Object> props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, System.getProperty(key, value));
        }
    }

    protected void setDefaultValues(Product product, ProductHandler handler) {
        product.setInstanceId(this.getProductInstanceId(product));
        StudioProductHandler.setDefaultValues(this.getMavenContext(), product);
        String dversion = System.getProperty("product.data.version", product.getDataVersion());
        String pversion = System.getProperty("product.version", product.getVersion());
        String dpath = System.getProperty("product.data.path", product.getDataPath());
        product.setDataPath(dpath);
        product.setDataVersion(dversion);
        product.setVersion(pversion);
        product.setArtifactRetriever(new ArtifactRetriever(this.artifactResolver, this.artifactFactory, this.localRepository, this.repositories));
        if (product.getContainerId() == null) {
            product.setContainerId(DEFAULT_CONTAINER);
        }
        if (product.getServer() == null) {
            product.setServer(DEFAULT_SERVER);
        }
        if (product.getDataVersion() == null) {
            product.setDataVersion(DEFAULT_PRODUCT_DATA_VERSION);
        }
        if (product.getPdkVersion() == null) {
            product.setPdkVersion(DEFAULT_PDK_VERSION);
        }
        if (product.getWebConsoleVersion() == null) {
            product.setWebConsoleVersion(DEFAULT_WEB_CONSOLE_VERSION);
        }
        if (product.isEnableFastdev() == null) {
            product.setEnableFastdev(true);
        }
        if (product.getFastdevVersion() == null) {
            product.setFastdevVersion(DEFAULT_FASTDEV_VERSION);
        }
        if (product.getOutput() == null) {
            product.setOutput(this.output);
        }
        if (product.getStartupTimeout() <= 0) {
            product.setStartupTimeout(180000);
        }
        if (product.getShutdownTimeout() <= 0) {
            product.setShutdownTimeout(180000);
        }
        if (product.getHttpPort() == 0) {
            product.setHttpPort(handler.getDefaultHttpPort());
        }
        if (product.getVersion() == null) {
            product.setVersion("RELEASE");
        }
        if (product.getContextPath() == null) {
            product.setContextPath("/" + handler.getId());
        }
    }

    private List<ProductArtifact> stringToArtifactList(String val, List<ProductArtifact> artifacts) {
        if (val == null || val.trim().length() == 0) {
            return artifacts;
        }
        for (String ptn : val.split(",")) {
            String[] items = ptn.split(":");
            if (items.length < 2 || items.length > 3) {
                throw new IllegalArgumentException("Invalid artifact pattern: " + ptn);
            }
            String groupId = items[0];
            String artifactId = items[1];
            String version = items.length == 3 ? items[2] : DEFAULT_PRODUCT_DATA_VERSION;
            artifacts.add(new ProductArtifact(groupId, artifactId, version));
        }
        return artifacts;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.stringToArtifactList(this.pluginArtifactsString, this.pluginArtifacts);
        this.stringToArtifactList(this.libArtifactsString, this.libArtifacts);
        this.stringToArtifactList(this.bundledArtifactsString, this.bundledArtifacts);
        this.systemPropertyVariables.putAll(this.systemProperties);
        this.detectDeprecatedVersionOverrides();
        this.doExecute();
    }

    private void detectDeprecatedVersionOverrides() {
        Properties props = this.getMavenContext().getProject().getProperties();
        for (String deprecatedProperty : new String[]{"sal.version", "rest.version", "web.console.version", "pdk.version"}) {
            if (!props.containsKey(deprecatedProperty)) continue;
            this.getLog().warn((CharSequence)("The property '" + deprecatedProperty + "' is no longer usable to override the related bundled plugin." + "  Use <pluginArtifacts> or <libArtifacts> to explicitly override bundled plugins and libraries, respectively."));
        }
    }

    protected Map<String, Product> getProductContexts(MavenGoals goals) throws MojoExecutionException {
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        this.makeProductsInheritDefaultConfiguration(this.products, productMap);
        for (Product ctx : productMap.values()) {
            ProductHandler handler = ProductHandlerFactory.create(ctx.getId(), this.getMavenContext(), goals);
            this.setDefaultValues(ctx, handler);
        }
        return productMap;
    }

    void makeProductsInheritDefaultConfiguration(List<Product> products, Map<String, Product> productMap) throws MojoExecutionException {
        Product defaultProduct = this.createDefaultProductContext();
        productMap.put(this.getProductId(), defaultProduct);
        if (!products.isEmpty()) {
            for (Product product : products) {
                Product processedProduct = product.merge(defaultProduct);
                if ("studio-crowd".equals(processedProduct.getId())) {
                    processedProduct.getSystemPropertyVariables().put("atlassian.dev.mode", "false");
                }
                String instanceId = this.getProductInstanceId(processedProduct);
                productMap.put(instanceId, processedProduct);
            }
        }
    }

    private String getProductInstanceId(Product processedProduct) {
        return processedProduct.getInstanceId() == null ? processedProduct.getId() : processedProduct.getInstanceId();
    }

    private Product createProductContext(String productNickname, String instanceId, ProductHandler handler) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Studio (instanceId=%s): No product with name %s is defined in the pom. Using a default product.", instanceId, productNickname));
        Product product = this.createDefaultProductContext();
        product.setId(productNickname);
        product.setInstanceId(instanceId);
        this.setDefaultValues(product, handler);
        if ("studio-crowd".equals(product.getId())) {
            product.getSystemPropertyVariables().put("atlassian.dev.mode", "false");
        }
        return product;
    }

    protected void stopProducts(List<ProductExecution> productExecutions) throws MojoExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(productExecutions.size());
        try {
            for (ProductExecution execution : productExecutions) {
                final Product product = execution.getProduct();
                final ProductHandler productHandler = execution.getProductHandler();
                Future<?> task = executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        AbstractProductHandlerMojo.this.getLog().info((CharSequence)(product.getInstanceId() + ": Shutting down"));
                        try {
                            productHandler.stop(product);
                        }
                        catch (MojoExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                boolean successful = true;
                try {
                    task.get(product.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    this.getLog().info((CharSequence)(product.getInstanceId() + ": Didn't shut down in time"));
                    successful = false;
                    task.cancel(true);
                }
                if (!successful) continue;
                this.getLog().info((CharSequence)(product.getInstanceId() + ": Stopped"));
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Exception while stopping the products", (Exception)e);
        }
    }

    private Iterator<ProductExecution> getStudioExecutions(List<ProductExecution> productExecutions) {
        return Iterables.filter(productExecutions, (Predicate)new Predicate<ProductExecution>(){

            public boolean apply(ProductExecution input) {
                return input.getProductHandler() instanceof StudioProductHandler;
            }
        }).iterator();
    }

    protected List<ProductExecution> includeStudioDependentProducts(List<ProductExecution> productExecutions, MavenGoals goals) throws MojoExecutionException {
        Iterator<ProductExecution> studioExecutions = this.getStudioExecutions(productExecutions);
        if (!studioExecutions.hasNext()) {
            return productExecutions;
        }
        ArrayList productExecutionsIncludingStudio = Lists.newArrayList(productExecutions);
        while (studioExecutions.hasNext()) {
            ProductExecution studioExecution = studioExecutions.next();
            Product studioProduct = studioExecution.getProduct();
            StudioProductHandler studioProductHandler = (StudioProductHandler)studioExecution.getProductHandler();
            List<String> dependantProductIds = studioProductHandler.getDependantInstances(studioProduct);
            ArrayList dependantProducts = Lists.newArrayList();
            Map<String, Product> allContexts = this.getProductContexts(goals);
            for (String instanceId : dependantProductIds) {
                ProductHandler handler;
                Product product = allContexts.get(instanceId);
                if (product == null) {
                    handler = this.createProductHandler(instanceId);
                    product = this.createProductContext(instanceId, instanceId, handler);
                } else {
                    handler = this.createProductHandler(product.getId());
                }
                dependantProducts.add(new ProductExecution(product, handler));
            }
            studioProductHandler.configure(studioProduct, dependantProducts);
            Set<String> exclusions = studioProductHandler.getExcludedInstances(studioProduct);
            if (exclusions != null) {
                Iterator iterator = dependantProducts.iterator();
                while (iterator.hasNext()) {
                    String executedInstance = ((ProductExecution)iterator.next()).getProduct().getInstanceId();
                    if (!exclusions.contains(executedInstance)) continue;
                    iterator.remove();
                }
            }
            productExecutionsIncludingStudio.addAll(dependantProducts);
        }
        return productExecutionsIncludingStudio;
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

