/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class FeCruProductHandler
extends AbstractProductHandler {
    private static final int STARTUP_CHECK_DELAY = 1000;
    private static final String FISHEYE_INST = "fisheye.inst";
    private final JavaTaskFactory javaTaskFactory;

    public FeCruProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals, new FeCruPluginProvider());
        this.javaTaskFactory = new JavaTaskFactory(this.log);
    }

    @Override
    public String getId() {
        return "fecru";
    }

    @Override
    protected ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.crucible", "atlassian-crucible", "RELEASE");
    }

    @Override
    public int getDefaultHttpPort() {
        return 3990;
    }

    @Override
    public final void stop(Product ctx) throws MojoExecutionException {
        this.log.info((CharSequence)("Stopping " + ctx.getInstanceId() + " on ports " + ctx.getHttpPort() + " (http) and " + FeCruProductHandler.controlPort(ctx.getHttpPort()) + " (control)"));
        try {
            this.execFishEyeCmd("stop", ctx);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stop FishEye/Crucible instance at " + ctx.getServer() + ":" + ctx.getHttpPort());
        }
        this.waitForFishEyeToStop(ctx);
    }

    @Override
    protected void extractProductHomeData(File productHomeZip, File homeDir, Product ctx) throws MojoExecutionException {
        try {
            ZipUtils.unzip(productHomeZip, homeDir.getPath());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to copy home directory", (Exception)ex);
        }
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        File homeDirectory = this.getHomeDirectory(ctx);
        replacements.add(new ConfigFileUtils.Replacement("@CONTROL_BIND@", String.valueOf(FeCruProductHandler.controlPort(ctx.getHttpPort()))));
        replacements.add(new ConfigFileUtils.Replacement("@HTTP_BIND@", String.valueOf(ctx.getHttpPort())));
        replacements.add(new ConfigFileUtils.Replacement("@HTTP_CONTEXT@", String.valueOf(ctx.getContextPath()), false));
        replacements.add(new ConfigFileUtils.Replacement("@HOME_DIR@", String.valueOf(homeDirectory.getAbsolutePath())));
        replacements.add(new ConfigFileUtils.Replacement("@SITE_URL@", String.valueOf(this.siteUrl(ctx))));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "config.xml"));
        configFiles.add(new File(homeDir, "var/data/crudb/crucible.script"));
        return configFiles;
    }

    @Override
    protected File extractApplication(Product ctx, File homeDir) throws MojoExecutionException {
        File appDir = ProjectUtils.createDirectory(this.getAppDirectory(ctx));
        ProductArtifact defaults = this.getArtifact();
        ProductArtifact artifact = new ProductArtifact(ProjectUtils.firstNotNull(ctx.getGroupId(), defaults.getGroupId()), ProjectUtils.firstNotNull(ctx.getArtifactId(), defaults.getArtifactId()), ProjectUtils.firstNotNull(ctx.getVersion(), defaults.getVersion()));
        File cruDistZip = this.goals.copyDist(this.getBuildDirectory(), artifact);
        try {
            int nestingLevel = ZipUtils.countNestingLevel(cruDistZip);
            ZipUtils.unzip(cruDistZip, appDir.getPath(), nestingLevel > 0 ? 1 : 0);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to extract application ZIP artifact", (Exception)ex);
        }
        return appDir;
    }

    protected File getAppDirectory(Product ctx) {
        return new File(this.getBaseDirectory(ctx), ctx.getId() + "-" + ctx.getVersion());
    }

    @Override
    protected final ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.fecru", "amps-fecru");
    }

    @Override
    protected Map<String, String> getSystemProperties(final Product ctx) {
        return new HashMap<String, String>(){
            {
                this.put(FeCruProductHandler.FISHEYE_INST, FeCruProductHandler.this.getHomeDirectory(ctx).getAbsolutePath());
            }
        };
    }

    @Override
    protected String getBundledPluginPath(Product ctx) {
        return "plugins/bundled-plugins.zip";
    }

    @Override
    protected Collection<? extends ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptySet();
    }

    @Override
    protected Collection<? extends ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptySet();
    }

    @Override
    protected final File getUserInstalledPluginsDirectory(File appDir, File homeDir) {
        return new File(new File(new File(homeDir, "var"), "plugins"), "user");
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return false;
    }

    @Override
    protected final int startApplication(Product ctx, File app, File homeDir, Map<String, String> properties) throws MojoExecutionException {
        AntJavaExecutorThread thread;
        this.log.info((CharSequence)("Starting " + ctx.getInstanceId() + " on ports " + ctx.getHttpPort() + " (http) and " + FeCruProductHandler.controlPort(ctx.getHttpPort()) + " (control)"));
        try {
            thread = this.execFishEyeCmd("run", ctx);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting fisheye.", e);
        }
        this.waitForFishEyeToStart(ctx, thread);
        return ctx.getHttpPort();
    }

    private void waitForFishEyeToStart(Product ctx, AntJavaExecutorThread thread) throws MojoExecutionException {
        boolean connected = false;
        int waited = 0;
        while (!connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                new Socket("localhost", ctx.getHttpPort()).close();
                connected = true;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (thread.isFinished()) {
                throw new MojoExecutionException("Fisheye failed to start.", (Exception)((Object)thread.getBuildException()));
            }
            if (waited++ * 1000 <= ctx.getStartupTimeout()) continue;
            throw new MojoExecutionException("FishEye took longer than " + ctx.getStartupTimeout() + "ms to start!");
        }
    }

    private void waitForFishEyeToStop(Product ctx) throws MojoExecutionException {
        boolean connected = true;
        int waited = 0;
        while (connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                new Socket("localhost", ctx.getHttpPort()).close();
            }
            catch (IOException e) {
                connected = false;
            }
            if (waited++ * 1000 <= ctx.getShutdownTimeout()) continue;
            throw new MojoExecutionException("FishEye took longer than " + ctx.getShutdownTimeout() + "ms to stop!");
        }
    }

    private AntJavaExecutorThread execFishEyeCmd(String bootCommand, Product ctx) throws MojoExecutionException {
        Map<String, String> properties = this.mergeSystemProperties(ctx);
        Java java = this.javaTaskFactory.newJavaTask(JavaTaskFactory.output(ctx.getOutput()).systemProperties(properties).jvmArgs(ctx.getJvmArgs()));
        this.addOverridesToJavaTask(ctx, java);
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getAppDirectory(ctx), "fisheyeboot.jar"));
        java.setClassname("com.cenqua.fisheye.FishEyeCtl");
        java.createArg().setValue(bootCommand);
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
        return javaThread;
    }

    protected void addOverridesToJavaTask(Product ctx, Java java) {
    }

    protected File getBuildDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }

    private String siteUrl(Product ctx) {
        return "http://" + ctx.getServer() + ":" + ctx.getHttpPort() + ctx.getContextPath();
    }

    public static int controlPort(int httpPort) {
        return httpPort * 10 + 1;
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File homeDirectory) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, homeDirectory);
        FileUtils.deleteQuietly((File)new File(homeDirectory, "var/log"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "var/plugins"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "cache/plugins"));
    }

    @Override
    protected String getLibArtifactTargetDir() {
        return "lib";
    }

    private static class FeCruPluginProvider
    extends AbstractPluginProvider {
        private FeCruPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-fisheye-plugin", salVersion));
        }
    }
}

