/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ConfluenceProductHandler
extends AbstractWebappProductHandler {
    public ConfluenceProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals, new ConfluencePluginProvider());
    }

    @Override
    public String getId() {
        return "confluence";
    }

    @Override
    protected boolean isStaticPlugin() {
        return false;
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.confluence", "confluence-webapp", "RELEASE");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.confluence.plugins", "confluence-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 1990;
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        return Collections.singletonMap("confluence.home", this.getHomeDirectory(ctx).getPath());
    }

    @Override
    public File getUserInstalledPluginsDirectory(File webappDir, File homeDir) {
        return null;
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    public String getBundledPluginPath(Product ctx) {
        return "WEB-INF/classes/com/atlassian/confluence/setup/atlassian-bundled-plugins.zip";
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        File homeDir = this.getHomeDirectory(ctx);
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDir.getParent()));
        replacements.add(new ConfigFileUtils.Replacement("/confluence-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("<baseUrl>http://localhost:1990/confluence</baseUrl>", "<baseUrl>http://" + ctx.getServer() + ":" + ctx.getHttpPort() + "/" + ctx.getContextPath().replaceAll("^/|/$", "") + "</baseUrl>", false));
        replacements.add(new ConfigFileUtils.Replacement("<baseUrl>http://localhost:8080</baseUrl>", "<baseUrl>http://" + ctx.getServer() + ":" + ctx.getHttpPort() + "/" + ctx.getContextPath().replaceAll("^/|/$", "") + "</baseUrl>", false));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDirectory) {
        List<File> configFiles = super.getConfigFiles(product, homeDirectory);
        configFiles.add(new File(new File(homeDirectory, "database"), "confluencedb.script"));
        configFiles.add(new File(new File(homeDirectory, "database"), "confluencedb.log"));
        configFiles.add(new File(homeDirectory, "confluence.cfg.xml"));
        return configFiles;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins-osgi-cache"));
        FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins-temp"));
    }

    private static class ConfluencePluginProvider
    extends AbstractPluginProvider {
        private ConfluencePluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-confluence-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            return Collections.emptyList();
        }
    }
}

