/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.osgi.OsgiHelper;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-manifest")
public class GenerateManifestMojo
extends AbstractAmpsMojo {
    private static final String BUILD_DATE_ATTRIBUTE = "Atlassian-Build-Date";
    private static final DateFormat BUILD_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @Parameter
    private Map<String, String> instructions = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getMavenContext().getProject();
        String buildDateStr = String.valueOf(BUILD_DATE_FORMAT.format(new Date()));
        ImmutableMap basicAttributes = ImmutableMap.of((Object)BUILD_DATE_ATTRIBUTE, (Object)buildDateStr);
        if (!this.instructions.isEmpty()) {
            File metainfLib;
            this.getLog().info((CharSequence)"Generating a manifest for this plugin");
            if (!this.instructions.containsKey("Export-Package")) {
                this.instructions.put("Export-Package", "");
            }
            if ((metainfLib = FileUtils.file(project.getBuild().getOutputDirectory(), "META-INF", "lib")).exists()) {
                StringBuilder sb = new StringBuilder(".");
                for (File lib : metainfLib.listFiles()) {
                    sb.append(",").append("META-INF/lib/" + lib.getName());
                }
                this.instructions.put("Bundle-ClassPath", sb.toString());
            }
            this.getMavenGoals().generateBundleManifest(this.instructions, (Map<String, String>)basicAttributes);
        } else {
            if (OsgiHelper.isAtlassianPlugin(project)) {
                this.getLog().warn((CharSequence)("Atlassian plugin detected as the organisation name includes the string 'Atlassian'.  If this is meant for production, you should add bundle instructions specifically configuring what packages are imported and exported.  This helps catch manifest generation bugs during the build rather than upon install.  The bundle generation configuration can be specified via the <instructions> element in the maven-" + this.getPluginInformation().getId() + "-plugin configuration.  For example:\n" + "    <configuration>\n" + "        <Import-Package>\n" + "            com.atlassian.myplugin*,\n" + "            com.library.optional.*;resolution:=optional,\n" + "            *\n" + "        </Import-Package>\n" + "    </configuration>\n\n" + "See the Maven bundle plugin (which is used under the covers) for more info: " + "http://felix.apache.org/site/apache-felix-maven-bundle-plugin-bnd.html#ApacheFelixMavenBundlePlugin%28BND%29-Instructions"));
            } else {
                this.getLog().info((CharSequence)"No manifest instructions found, adding only non-OSGi manifest attributes");
            }
            this.getMavenGoals().generateMinimalManifest((Map<String, String>)basicAttributes);
        }
    }
}

