/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test-jar")
public class TestJarMojo
extends AbstractAmpsMojo {
    @Parameter
    private Boolean buildTestPlugin;
    @Parameter(property="project.build.finalName")
    private String finalName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean shouldBuild = false;
        if (this.buildTestPlugin != null) {
            if (this.buildTestPlugin.booleanValue()) {
                shouldBuild = true;
            }
        } else if (ProjectUtils.shouldDeployTestJar(this.getMavenContext())) {
            shouldBuild = true;
        }
        if (shouldBuild) {
            File mf = FileUtils.file(this.getMavenContext().getProject().getBuild().getTestOutputDirectory(), "META-INF", "MANIFEST.MF");
            if (!mf.exists()) {
                try {
                    org.apache.commons.io.FileUtils.writeStringToFile((File)mf, (String)("Manifest-Version: 1.0\nBundle-SymbolicName: plugin-tests\nBundle-Version: 1.0\nBundle-Name: " + this.finalName + "-tests\n" + "DynamicImport-Package: *\n"));
                }
                catch (IOException e) {
                    throw new MojoFailureException("Unable to write manifest");
                }
            }
            this.getMavenGoals().jarTests(this.finalName);
        }
    }
}

