/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class StashProductHandler
extends AbstractWebappProductHandler {
    public StashProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals, new StashPluginProvider());
    }

    @Override
    public String getId() {
        return "stash";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.stash", "stash-webapp");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.stash", "stash-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 7990;
    }

    @Override
    public Map<String, String> getSystemProperties(final Product ctx) {
        return new HashMap<String, String>(){
            {
                this.put("stash.home", StashProductHandler.fixSlashes(StashProductHandler.this.getHomeDirectory(ctx).getPath()));
                String baseUrl = MavenGoals.getBaseUrl(ctx, ctx.getHttpPort());
                this.put("baseurl", baseUrl);
                this.put("baseurl.display", baseUrl);
            }
        };
    }

    private static String fixSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    @Override
    public File getUserInstalledPluginsDirectory(File webappDir, File homeDir) {
        return new File(new File(homeDir, "plugins"), "installed-plugins");
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    public String getBundledPluginPath(Product ctx) {
        String bundledPluginPluginsPath = "WEB-INF/classes/stash-bundled-plugins.zip";
        return bundledPluginPluginsPath;
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "data/db.log"));
        configFiles.add(new File(homeDir, "data/db.script"));
        configFiles.add(new File(homeDir, "data/db.properties"));
        return configFiles;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-stash.log"));
        FileUtils.deleteQuietly((File)new File(snapshotDir, ".osgi-cache"));
    }

    private static class StashPluginProvider
    extends AbstractPluginProvider {
        private StashPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Collections.emptyList();
        }
    }
}

