/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="integration-test")
@MojoRequiresDependencyResolution(value="test")
public class IntegrationTestMojo
extends AbstractTestGroupsHandlerMojo {
    @MojoParameter(expression="${functional.test.pattern}")
    private String functionalTestPattern = "it/**";
    @MojoParameter(expression="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;
    @MojoParameter(expression="${testGroups}")
    private String configuredTestGroupsToRun;
    @MojoParameter(expression="${no.webapp}", defaultValue="false")
    private boolean noWebapp = false;
    @MojoComponent
    private ArtifactHandlerManager artifactHandlerManager;
    @MojoParameter(expression="${maven.test.skip}", defaultValue="false")
    private boolean testsSkip = false;
    @MojoParameter(expression="${skipTests}", defaultValue="false")
    private boolean skipTests = false;
    @MojoParameter(expression="${skipITs}", defaultValue="false")
    private boolean skipITs = false;

    @Override
    protected void doExecute() throws MojoExecutionException {
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip || this.skipITs) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        Set<String> configuredTestGroupIds = this.getTestGroupIds();
        if (configuredTestGroupIds.isEmpty()) {
            this.runTestsForTestGroup("__no_test_group__", goals, pluginJar, this.copy(this.systemPropertyVariables));
        } else if (this.configuredTestGroupsToRun != null) {
            String[] testGroupIdsToRun;
            for (String testGroupId : testGroupIdsToRun = this.configuredTestGroupsToRun.split(",")) {
                if (!configuredTestGroupIds.contains(testGroupId)) {
                    this.getLog().warn((CharSequence)("Test group " + testGroupId + " does not exist"));
                    continue;
                }
                this.runTestsForTestGroup(testGroupId, goals, pluginJar, this.copy(this.systemPropertyVariables));
            }
        } else {
            for (String testGroupId : configuredTestGroupIds) {
                this.runTestsForTestGroup(testGroupId, goals, pluginJar, this.copy(this.systemPropertyVariables));
            }
        }
    }

    private Map<String, Object> copy(Map<String, Object> systemPropertyVariables) {
        return new HashMap<String, Object>(systemPropertyVariables);
    }

    protected Map<String, String> getProductFunctionalTestProperties(Product product) {
        return Collections.emptyMap();
    }

    private Set<String> getTestGroupIds() throws MojoExecutionException {
        HashSet<String> ids = new HashSet<String>();
        for (TestGroup group : this.getTestGroups()) {
            ids.add(group.getId());
        }
        return ids;
    }

    private void runTestsForTestGroup(String testGroupId, MavenGoals goals, String pluginJar, Map<String, Object> systemProperties) throws MojoExecutionException {
        List<String> includes = this.getIncludesForTestGroup(testGroupId);
        List<String> excludes = this.getExcludesForTestGroup(testGroupId);
        List<ProductExecution> executionsDeclaredInPom = this.getTestGroupProductExecutions(testGroupId);
        List<ProductExecution> productExecutions = this.includeStudioDependentProducts(executionsDeclaredInPom, goals);
        this.setParallelMode(productExecutions);
        for (ProductExecution productExecution : productExecutions) {
            ProductHandler productHandler = productExecution.getProductHandler();
            Product product = productExecution.getProduct();
            if (product.isInstallPlugin() == null) {
                product.setInstallPlugin(this.installPlugin);
            }
            int actualHttpPort = 0;
            if (!this.noWebapp) {
                actualHttpPort = productHandler.start(product);
            }
            if (productExecutions.size() == 1) {
                systemProperties.put("http.port", String.valueOf(actualHttpPort));
                systemProperties.put("context.path", product.getContextPath());
            }
            String baseUrl = MavenGoals.getBaseUrl(product, actualHttpPort);
            systemProperties.put("http." + product.getInstanceId() + ".port", String.valueOf(actualHttpPort));
            systemProperties.put("context." + product.getInstanceId() + ".path", product.getContextPath());
            systemProperties.put("http." + product.getInstanceId() + ".url", MavenGoals.getBaseUrl(product, actualHttpPort));
            systemProperties.put("baseurl." + product.getInstanceId(), baseUrl);
            systemProperties.put("plugin.jar", pluginJar);
            if (!systemProperties.containsKey("baseurl")) {
                systemProperties.put("baseurl", baseUrl);
            }
            systemProperties.put("homedir." + product.getInstanceId(), productHandler.getHomeDirectory(product).getAbsolutePath());
            if (!systemProperties.containsKey("homedir")) {
                systemProperties.put("homedir", productHandler.getHomeDirectory(product).getAbsolutePath());
            }
            systemProperties.putAll(this.getProductFunctionalTestProperties(product));
        }
        systemProperties.put("testGroup", testGroupId);
        systemProperties.putAll(this.getTestGroupSystemProperties(testGroupId));
        if (this.parallel) {
            this.waitForProducts(productExecutions, true);
        }
        goals.runTests("group-" + testGroupId, this.getClassifier(testGroupId), includes, excludes, systemProperties, this.targetDirectory);
        if (!this.noWebapp) {
            this.stopProducts(productExecutions);
        }
    }

    private String getClassifier(String testGroupId) {
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            if (group.getClassifier() != null) {
                return group.getClassifier();
            }
            return "tomcat6x";
        }
        return "tomcat6x";
    }

    private Map<String, String> getTestGroupSystemProperties(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyMap();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getSystemProperties();
        }
        return Collections.emptyMap();
    }

    private List<String> getIncludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.singletonList(this.functionalTestPattern);
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getIncludes();
        }
        return Collections.singletonList(this.functionalTestPattern);
    }

    private List<String> getExcludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyList();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getExcludes();
        }
        return Collections.emptyList();
    }
}

