/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.GoogleAmpsTracker;
import org.apache.maven.plugin.MojoExecutionException;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

public abstract class AbstractProductAwareMojo
extends AbstractAmpsMojo {
    @MojoParameter(expression="${product}")
    private String product;
    @MojoParameter(expression="${instanceId}")
    protected String instanceId;
    @MojoParameter(expression="${allow.google.tracking}", defaultValue="true")
    protected boolean allowGoogleTracking;
    private GoogleAmpsTracker googleTracker;

    protected String getDefaultProductId() throws MojoExecutionException {
        String nameOfTheCurrentMavenPlugin = this.getPluginInformation().getId();
        if (ProductHandlerFactory.getIds().contains(nameOfTheCurrentMavenPlugin)) {
            return nameOfTheCurrentMavenPlugin;
        }
        return null;
    }

    protected final String getProductId() throws MojoExecutionException {
        if (this.product == null) {
            this.product = this.getDefaultProductId();
            if (this.product == null) {
                this.product = "refapp";
            }
        }
        return this.product;
    }

    protected GoogleAmpsTracker getGoogleTracker() throws MojoExecutionException {
        if (null == this.googleTracker) {
            this.googleTracker = new GoogleAmpsTracker(this.getProductId(), this.getLog());
            if (this.googleTrackingAllowed()) {
                this.getLog().info((CharSequence)"Google Analytics Tracking is enabled to collect AMPS usage statistics.");
                this.getLog().info((CharSequence)"Although no personal information is sent, you may disable tracking by adding <allowGoogleTracking>false</allowGoogleTracking> to the amps plugin configuration in your pom.xml");
            }
        }
        this.googleTracker.setEnabled(this.googleTrackingAllowed());
        return this.googleTracker;
    }

    protected boolean googleTrackingAllowed() {
        return this.allowGoogleTracking;
    }
}

