/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginProvider
implements PluginProvider {
    @Override
    public final List<ProductArtifact> provide(Product product) {
        ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
        artifacts.addAll(product.getPluginArtifacts());
        if (product.getSalVersion() != null) {
            artifacts.addAll(this.getSalArtifacts(product.getSalVersion()));
        }
        if (product.getPdkVersion() != null) {
            artifacts.addAll(this.getPdkInstallArtifacts(product.getPdkVersion()));
        }
        if (product.getRestVersion() != null) {
            artifacts.addAll(this.getRestArtifacts(product.getRestVersion()));
        }
        if (product.getWebConsoleVersion() != null) {
            artifacts.addAll(this.getWebConsoleArtifacts(product.getWebConsoleVersion()));
        }
        return artifacts;
    }

    protected abstract Collection<ProductArtifact> getSalArtifacts(String var1);

    protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.pdkinstall", "pdkinstall-plugin", pdkInstallVersion));
    }

    protected Collection<ProductArtifact> getWebConsoleArtifacts(String webConsoleVersion) {
        return Arrays.asList(new ProductArtifact("org.apache.felix", "org.apache.felix.webconsole", webConsoleVersion), new ProductArtifact("org.apache.felix", "org.osgi.compendium", "1.2.0"), new ProductArtifact("com.atlassian.labs.httpservice", "httpservice-bridge", "0.5.3"));
    }

    protected Collection<ProductArtifact> getRestArtifacts(String restVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.plugins.rest", "atlassian-rest-module", restVersion));
    }
}

