/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.osgi.OsgiHelper;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoGoal(value="generate-manifest")
public class GenerateManifestMojo
extends AbstractAmpsMojo {
    @MojoParameter
    private Map instructions = new HashMap();

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getMavenContext().getProject();
        if (!this.instructions.isEmpty()) {
            File metainfLib;
            this.getLog().info((CharSequence)"Generating a manifest for this plugin");
            if (!this.instructions.containsKey("Export-Package")) {
                this.instructions.put("Export-Package", "");
            }
            if ((metainfLib = FileUtils.file(project.getBuild().getOutputDirectory(), "META-INF", "lib")).exists()) {
                StringBuilder sb = new StringBuilder(".");
                for (File lib : metainfLib.listFiles()) {
                    sb.append(",").append("META-INF/lib/" + lib.getName());
                }
                this.instructions.put("Bundle-ClassPath", sb.toString());
            }
            this.getMavenGoals().generateManifest(this.instructions);
        } else if (OsgiHelper.isAtlassianPlugin(project)) {
            this.getLog().warn((CharSequence)("Atlassian plugin detected as the organisation name includes the string 'Atlassian'.  If this is meant for production, you should add bundle instructions specifically configuring what packages are imported and exported.  This helps catch manifest generation bugs during the build rather than upon install.  The bundle generation configuration can be specified via the <instructions> element in the maven-" + this.getPluginInformation().getId() + "-plugin configuration.  For example:\n" + "    <configuration>\n" + "        <Import-Package>\n" + "            com.atlassian.myplugin*,\n" + "            com.library.optional.*;resolution:=optional,\n" + "            *\n" + "        </Import-Package>\n" + "    </configuration>\n\n" + "See the Maven bundle plugin (which is used under the covers) for more info: " + "http://felix.apache.org/site/apache-felix-maven-bundle-plugin-bnd.html#ApacheFelixMavenBundlePlugin%28BND%29-Instructions"));
        } else {
            this.getLog().info((CharSequence)"No manifest instructions found, skipping manifest generation");
        }
    }
}

