/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="integration-test")
@MojoRequiresDependencyResolution(value="test")
public class IntegrationTestMojo
extends AbstractProductHandlerMojo {
    @MojoParameter(expression="${functional.test.pattern}")
    private String functionalTestPattern = "it/**";
    @MojoParameter(expression="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;
    @MojoParameter
    private List<TestGroup> testGroups = new ArrayList<TestGroup>();
    @MojoParameter(expression="${testGroups}")
    private String configuredTestGroupsToRun;
    @MojoParameter(expression="${no.webapp}", defaultValue="false")
    private boolean noWebapp = false;
    @MojoComponent
    private ArtifactHandlerManager artifactHandlerManager;
    @MojoParameter(expression="${maven.test.skip}", defaultValue="false")
    private boolean testsSkip = false;
    @MojoParameter(expression="${skipTests}", defaultValue="false")
    private boolean skipTests = false;
    private static final String NO_TEST_GROUP = "__no_test_group__";

    @Override
    protected void doExecute() throws MojoExecutionException {
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        Set<String> configuredTestGroupIds = this.getTestGroupIds();
        if (configuredTestGroupIds.isEmpty()) {
            this.runTestsForTestGroup(NO_TEST_GROUP, goals, pluginJar, this.copy(this.systemProperties));
        } else if (this.configuredTestGroupsToRun != null) {
            String[] testGroupIdsToRun;
            for (String testGroupId : testGroupIdsToRun = this.configuredTestGroupsToRun.split(",")) {
                if (configuredTestGroupIds.contains(testGroupId)) continue;
                throw new MojoExecutionException("Test group " + testGroupId + " does not exist");
            }
            for (String testGroupId : testGroupIdsToRun) {
                this.runTestsForTestGroup(testGroupId, goals, pluginJar, this.copy(this.systemProperties));
            }
        } else {
            for (String testGroupId : configuredTestGroupIds) {
                this.runTestsForTestGroup(testGroupId, goals, pluginJar, this.copy(this.systemProperties));
            }
        }
    }

    private Properties copy(Properties systemProperties) {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)systemProperties);
        return copy;
    }

    protected Map<String, String> getProductFunctionalTestProperties(Product product) {
        return Collections.emptyMap();
    }

    private Set<String> getTestGroupIds() throws MojoExecutionException {
        HashSet<String> ids = new HashSet<String>();
        for (TestGroup group : this.testGroups) {
            ids.add(group.getId());
        }
        return ids;
    }

    private Set<String> getProductIdsForTestGroup(String testGroupId) throws MojoExecutionException {
        HashSet<String> productIds = new HashSet<String>();
        if (NO_TEST_GROUP.equals(testGroupId)) {
            productIds.add(this.getProductId());
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            productIds.addAll(group.getProductIds());
        }
        if (ProductHandlerFactory.getIds().contains(testGroupId)) {
            productIds.add(testGroupId);
        }
        if (productIds.isEmpty()) {
            throw new MojoExecutionException("Unknown test group id");
        }
        return productIds;
    }

    private void runTestsForTestGroup(String testGroupId, MavenGoals goals, String pluginJar, Properties systemProperties) throws MojoExecutionException {
        Product product;
        ProductHandler productHandler;
        List<String> includes = this.getIncludesForTestGroup(testGroupId);
        List<String> excludes = this.getExcludesForTestGroup(testGroupId);
        Set<String> productIds = this.getProductIdsForTestGroup(testGroupId);
        ArrayList<TestGroupProductExecution> products = new ArrayList<TestGroupProductExecution>();
        for (String productId : productIds) {
            ProductHandler product2 = ProductHandlerFactory.create(productId, this.getMavenContext().getProject(), goals, this.getLog());
            Product ctx = this.getProductContexts(goals).get(productId);
            if (ctx == null) {
                throw new MojoExecutionException("The test group '" + testGroupId + "' refers to a product '" + productId + "' that doesn't have an associated <product> configuration.");
            }
            products.add(new TestGroupProductExecution(ctx, product2));
        }
        for (TestGroupProductExecution testGroupProductExecution : products) {
            productHandler = testGroupProductExecution.getProductHandler();
            product = testGroupProductExecution.getProduct();
            product.setInstallPlugin(this.installPlugin);
            int actualHttpPort = 0;
            if (!this.noWebapp) {
                actualHttpPort = productHandler.start(product);
            }
            if (products.size() == 1) {
                systemProperties.put("http.port", String.valueOf(actualHttpPort));
                systemProperties.put("context.path", product.getContextPath());
            }
            systemProperties.put("http." + product.getId() + ".port", String.valueOf(actualHttpPort));
            systemProperties.put("context." + product.getId() + ".path", product.getContextPath());
            systemProperties.put("plugin.jar", pluginJar);
            systemProperties.putAll(this.getProductFunctionalTestProperties(product));
        }
        systemProperties.put("testGroup", testGroupId);
        systemProperties.putAll(this.getTestGroupSystemProperties(testGroupId));
        goals.runTests(this.getProductId(), this.containerId, includes, excludes, systemProperties);
        for (TestGroupProductExecution testGroupProductExecution : products) {
            productHandler = testGroupProductExecution.getProductHandler();
            product = testGroupProductExecution.getProduct();
            if (this.noWebapp) continue;
            productHandler.stop(product);
        }
    }

    private Map<String, String> getTestGroupSystemProperties(String testGroupId) {
        if (NO_TEST_GROUP.equals(testGroupId)) {
            return Collections.emptyMap();
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getSystemProperties();
        }
        return Collections.emptyMap();
    }

    private List<String> getIncludesForTestGroup(String testGroupId) {
        if (NO_TEST_GROUP.equals(testGroupId)) {
            return Collections.singletonList(this.functionalTestPattern);
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getIncludes();
        }
        return Collections.singletonList(this.functionalTestPattern);
    }

    private List<String> getExcludesForTestGroup(String testGroupId) {
        if (NO_TEST_GROUP.equals(testGroupId)) {
            return Collections.emptyList();
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            return group.getExcludes();
        }
        return Collections.emptyList();
    }

    private static class TestGroupProductExecution {
        private final Product product;
        private final ProductHandler productHandler;

        public TestGroupProductExecution(Product product, ProductHandler productHandler) {
            this.product = product;
            this.productHandler = productHandler;
        }

        public ProductHandler getProductHandler() {
            return this.productHandler;
        }

        public Product getProduct() {
            return this.product;
        }
    }
}

