/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerAwareMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProductHandlerMojo
extends AbstractProductHandlerAwareMojo {
    private static final String DEFAULT_CONTAINER = "tomcat6x";
    private static final String DEFAULT_SERVER = "localhost";
    private static final String DEFAULT_PRODUCT_DATA_VERSION = "LATEST";
    private static final String DEFAULT_PDK_VERSION = "0.4";
    private static final String DEFAULT_WEB_CONSOLE_VERSION = "1.2.8";
    @MojoParameter(expression="${container}", defaultValue="tomcat6x")
    protected String containerId;
    @MojoParameter(expression="${http.port}", defaultValue="0")
    private int httpPort;
    @MojoParameter(expression="${context.path}")
    protected String contextPath;
    @MojoParameter(expression="${server}", defaultValue="localhost")
    protected String server;
    @MojoParameter(expression="${product.version}")
    private String productVersion;
    @MojoParameter(expression="${jvmargs}")
    protected String jvmArgs;
    @MojoParameter
    protected Properties systemProperties = new Properties();
    @MojoParameter
    protected File log4jProperties;
    @MojoParameter(expression="${test.resources.version}")
    private String testResourcesVersion;
    @MojoParameter(expression="${product.data.version}", defaultValue="LATEST")
    private String productDataVersion;
    @MojoParameter(expression="${product.data.path}")
    private String productDataPath;
    @MojoParameter
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter(expression="${sal.version}")
    private String salVersion;
    @MojoParameter(expression="${pdk.version}", defaultValue="0.4")
    private String pdkVersion;
    @MojoParameter(expression="${rest.version}")
    private String restVersion;
    @MojoParameter(expression="${web.console.version}", defaultValue="1.2.8")
    private String webConsoleVersion;
    @MojoParameter(expression="${plugins}")
    private String pluginArtifactsString;
    @MojoParameter(expression="${lib.plugins}")
    private String libArtifactsString;
    @MojoParameter(expression="${bundled.plugins}")
    private String bundledArtifactsString;
    @MojoParameter(expression="${project.build.directory}", required=true)
    protected File targetDirectory;
    @MojoParameter(expression="${project.build.finalName}", required=true)
    protected String finalName;
    @MojoParameter(expression="${install.plugin}", defaultValue="true")
    protected boolean installPlugin;
    @MojoComponent
    private ArtifactResolver artifactResolver;
    @MojoParameter(expression="${localRepository}")
    private ArtifactRepository localRepository;
    @MojoParameter(expression="${project.remoteArtifactRepositories}")
    private List repositories;
    @MojoComponent
    private ArtifactFactory artifactFactory;
    @MojoParameter
    protected List<Product> products = new ArrayList<Product>();
    @MojoParameter
    private String output;

    private Product createDefaultProductContext() throws MojoExecutionException {
        Product ctx = new Product();
        ctx.setId(this.getProductId());
        ctx.setContainerId(this.containerId);
        ctx.setServer(this.server);
        ctx.setContextPath(this.contextPath);
        ctx.setJvmArgs(this.jvmArgs);
        ctx.setSystemProperties(this.systemProperties);
        ctx.setBundledArtifacts(this.bundledArtifacts);
        ctx.setLibArtifacts(this.libArtifacts);
        ctx.setPluginArtifacts(this.pluginArtifacts);
        ctx.setLog4jProperties(this.log4jProperties);
        ctx.setHttpPort(this.httpPort);
        ctx.setVersion(this.productVersion);
        ctx.setProductDataVersion(this.productDataVersion);
        ctx.setProductDataPath(this.productDataPath);
        ctx.setRestVersion(this.restVersion);
        ctx.setSalVersion(this.salVersion);
        ctx.setPdkVersion(this.pdkVersion);
        ctx.setWebConsoleVersion(this.webConsoleVersion);
        ctx.setHttpPort(this.httpPort);
        return ctx;
    }

    private void postProcessProduct(Product product) {
        String dversion = System.getProperty("product.data.version", product.getProductDataVersion());
        String pversion = System.getProperty("product.version", product.getVersion());
        String dpath = System.getProperty("product.data.path", product.getProductDataPath());
        product.setProductDataPath(dpath);
        product.setProductDataVersion(dversion);
        product.setVersion(pversion);
        product.setArtifactRetriever(new ArtifactRetriever(this.artifactResolver, this.artifactFactory, this.localRepository, this.repositories));
        if (product.getContainerId() == null) {
            product.setContainerId(DEFAULT_CONTAINER);
        }
        if (product.getServer() == null) {
            product.setServer(DEFAULT_SERVER);
        }
        if (product.getProductDataVersion() == null) {
            product.setProductDataVersion(DEFAULT_PRODUCT_DATA_VERSION);
        }
        if (product.getPdkVersion() == null) {
            product.setPdkVersion(DEFAULT_PDK_VERSION);
        }
        if (product.getWebConsoleVersion() == null) {
            product.setWebConsoleVersion(DEFAULT_WEB_CONSOLE_VERSION);
        }
        if (product.getOutput() == null) {
            product.setOutput(this.output);
        }
    }

    private List<ProductArtifact> stringToArtifactList(String val, List<ProductArtifact> artifacts) {
        if (val == null || val.trim().length() == 0) {
            return artifacts;
        }
        for (String ptn : val.split(",")) {
            String[] items = ptn.split(":");
            if (items.length < 2 || items.length > 3) {
                throw new IllegalArgumentException("Invalid artifact pattern: " + ptn);
            }
            String groupId = items[0];
            String artifactId = items[1];
            String version = items.length == 3 ? items[2] : DEFAULT_PRODUCT_DATA_VERSION;
            artifacts.add(new ProductArtifact(groupId, artifactId, version));
        }
        return artifacts;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.stringToArtifactList(this.pluginArtifactsString, this.pluginArtifacts);
        this.stringToArtifactList(this.libArtifactsString, this.libArtifacts);
        this.stringToArtifactList(this.bundledArtifactsString, this.bundledArtifacts);
        this.doExecute();
    }

    protected Map<String, Product> getProductContexts(MavenGoals goals) throws MojoExecutionException {
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        if (this.getProductId() != null) {
            boolean found = false;
            for (Product product : this.products) {
                if (this.getProductId().equals(product.getId())) {
                    found = true;
                }
                productMap.put(product.getId(), product);
            }
            if (!found) {
                productMap.put(this.getProductId(), this.createDefaultProductContext());
            }
        }
        for (Product ctx : productMap.values()) {
            this.postProcessProduct(ctx);
            ProductHandler handler = ProductHandlerFactory.create(ctx.getId(), this.getMavenContext().getProject(), goals, this.getLog());
            ctx.setHttpPort(ctx.getHttpPort() == 0 ? handler.getDefaultHttpPort() : ctx.getHttpPort());
            ctx.setVersion(ctx.getVersion() == null ? "RELEASE" : ctx.getVersion());
            ctx.setContextPath(ctx.getContextPath() == null ? "/" + handler.getId() : ctx.getContextPath());
        }
        return productMap;
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

